/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.app.Activity;
import android.hardware.Camera;
import android.view.SurfaceHolder;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraUtils {
    public static final int DEFAULT_WIDTH = 1280;
    public static final int DEFAULT_HEIGHT = 720;
    public static final int DESIRED_PREVIEW_FPS = 30;
    private static int mCameraID = 1;
    private static Camera mCamera;
    private static int mCameraPreviewFps;
    private static int mOrientation;

    public static void openFrontalCamera(int expectFps) {
        CameraUtils.openFrontalCamera(expectFps, 1280, 720, mOrientation);
    }

    public static void openFrontalCamera(int expectFps, int width, int height, int degrees) {
        if (mCamera != null) {
            throw new RuntimeException("camera already initialized!");
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        int numCameras = Camera.getNumberOfCameras();
        for (int i = 0; i < numCameras; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing != 1) continue;
            mCamera = Camera.open((int)i);
            mCameraID = info.facing;
            break;
        }
        if (mCamera == null) {
            mCamera = Camera.open();
            mCameraID = 0;
        }
        if (mCamera == null) {
            throw new RuntimeException("Unable to open camera");
        }
        Camera.Parameters parameters = mCamera.getParameters();
        mCameraPreviewFps = CameraUtils.chooseFixedPreviewFps(parameters, expectFps * 1000);
        parameters.setRecordingHint(true);
        mCamera.setParameters(parameters);
        CameraUtils.setPreviewSize(mCamera, width, height);
        CameraUtils.setPictureSize(mCamera, width, height);
        mCamera.setDisplayOrientation(degrees);
    }

    public static void openCamera(int cameraID, int expectFps) {
        if (mCamera != null) {
            throw new RuntimeException("camera already initialized!");
        }
        mCamera = Camera.open((int)cameraID);
        if (mCamera == null) {
            throw new RuntimeException("Unable to open camera");
        }
        mCameraID = cameraID;
        Camera.Parameters parameters = mCamera.getParameters();
        mCameraPreviewFps = CameraUtils.chooseFixedPreviewFps(parameters, expectFps * 1000);
        parameters.setRecordingHint(true);
        mCamera.setParameters(parameters);
        CameraUtils.setPreviewSize(mCamera, 1280, 720);
        CameraUtils.setPictureSize(mCamera, 1280, 720);
        mCamera.setDisplayOrientation(mOrientation);
    }

    public static void startPreviewDisplay(SurfaceHolder holder) {
        if (mCamera == null) {
            throw new IllegalStateException("Camera must be set when start preview");
        }
        try {
            mCamera.setPreviewDisplay(holder);
            mCamera.startPreview();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void switchCamera(int cameraID, SurfaceHolder holder, int orientation) {
        if (mCameraID == cameraID) {
            return;
        }
        mCameraID = cameraID;
        CameraUtils.releaseCamera();
        CameraUtils.openCamera(cameraID, 30);
        CameraUtils.startPreviewDisplay(holder);
    }

    public static void releaseCamera() {
        if (mCamera != null) {
            mCamera.stopPreview();
            mCamera.release();
            mCamera = null;
        }
    }

    public static void startPreview() {
        if (mCamera != null) {
            mCamera.startPreview();
        }
    }

    public static void stopPreview() {
        if (mCamera != null) {
            mCamera.stopPreview();
        }
    }

    public static void takePicture(Camera.ShutterCallback shutterCallback, Camera.PictureCallback rawCallback, Camera.PictureCallback pictureCallback) {
        if (mCamera != null) {
            mCamera.takePicture(shutterCallback, rawCallback, pictureCallback);
        }
    }

    public static void setPreviewSize(Camera camera, int expectWidth, int expectHeight) {
        Camera.Parameters parameters = camera.getParameters();
        Camera.Size size = CameraUtils.calculatePerfectSize(parameters.getSupportedPreviewSizes(), expectWidth, expectHeight);
        parameters.setPreviewSize(size.width, size.height);
        camera.setParameters(parameters);
    }

    public static Camera.Size getPreviewSize() {
        if (mCamera != null) {
            return mCamera.getParameters().getPreviewSize();
        }
        return null;
    }

    public static void setPictureSize(Camera camera, int expectWidth, int expectHeight) {
        Camera.Parameters parameters = camera.getParameters();
        Camera.Size size = CameraUtils.calculatePerfectSize(parameters.getSupportedPictureSizes(), expectWidth, expectHeight);
        parameters.setPictureSize(size.width, size.height);
        camera.setParameters(parameters);
    }

    public static Camera.Size getPictureSize() {
        if (mCamera != null) {
            return mCamera.getParameters().getPictureSize();
        }
        return null;
    }

    public static Camera.Size calculatePerfectSize(List<Camera.Size> sizes, int expectWidth, int expectHeight) {
        CameraUtils.sortList(sizes);
        Camera.Size result = sizes.get(0);
        boolean widthOrHeight = false;
        for (Camera.Size size : sizes) {
            if (size.width == expectWidth && size.height == expectHeight) {
                result = size;
                break;
            }
            if (size.width == expectWidth) {
                widthOrHeight = true;
                if (Math.abs(result.height - expectHeight) <= Math.abs(size.height - expectHeight)) continue;
                result = size;
                continue;
            }
            if (size.height == expectHeight) {
                widthOrHeight = true;
                if (Math.abs(result.width - expectWidth) <= Math.abs(size.width - expectWidth)) continue;
                result = size;
                continue;
            }
            if (widthOrHeight || Math.abs(result.width - expectWidth) <= Math.abs(size.width - expectWidth) || Math.abs(result.height - expectHeight) <= Math.abs(size.height - expectHeight)) continue;
            result = size;
        }
        return result;
    }

    private static void sortList(List<Camera.Size> list) {
        Collections.sort(list, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size pre, Camera.Size after) {
                if (pre.width > after.width) {
                    return 1;
                }
                if (pre.width < after.width) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public static int chooseFixedPreviewFps(Camera.Parameters parameters, int expectedThoudandFps) {
        List supportedFps = parameters.getSupportedPreviewFpsRange();
        for (int[] entry : supportedFps) {
            if (entry[0] != entry[1] || entry[0] != expectedThoudandFps) continue;
            parameters.setPreviewFpsRange(entry[0], entry[1]);
            return entry[0];
        }
        int[] temp = new int[2];
        parameters.getPreviewFpsRange(temp);
        int guess = temp[0] == temp[1] ? temp[0] : temp[1] / 2;
        return guess;
    }

    public static int calculateCameraPreviewOrientation(Activity activity) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)mCameraID, (Camera.CameraInfo)info);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        mOrientation = result;
        return result;
    }

    public static int getCameraID() {
        return mCameraID;
    }

    public static Camera getmCamera() {
        return mCamera;
    }

    public static int getPreviewOrientation() {
        return mOrientation;
    }

    public static void setPreviewOrientation(int orientation) {
        mOrientation = orientation;
    }

    public static int getCameraPreviewThousandFps() {
        return mCameraPreviewFps;
    }

    public static void openFrontalCamera() {
        CameraUtils.openFrontalCamera(30);
    }

    static {
        mOrientation = 90;
    }
}

