/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.network;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.Route;
import org.tcshare.network.AResponse;
import org.tcshare.network.HttpLogInterceptor;
import org.tcshare.network.RequestBuilderFactory;

public class HttpApi {
    private static OkHttpClient client;
    private static final long CONECT_TIMEOUT = 10L;
    private static final long READ_TIMEOUT = 30L;
    private static final long WRITE_TIMEOUT = 300L;
    public static final String UPLOAD_FILE_KEY = "file";
    public static final String UPLOAD_MULTI_FILE_KEY = "file[]";
    private static final HttpLogInterceptor debugInterceptor;

    public static void setDebug(boolean debug) {
        HttpApi.debugInterceptor.debug = debug;
    }

    public static void setClient(OkHttpClient client) {
        HttpApi.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getOkHttpClient() {
        if (client != null) return client;
        Class<HttpApi> clazz = HttpApi.class;
        synchronized (HttpApi.class) {
            if (client != null) return client;
            client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(300L, TimeUnit.SECONDS).addInterceptor((Interceptor)debugInterceptor).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    public static OkHttpClient.Builder getProxyAuthBuilder(String proxyHost, int proxyPort, String username, String password) {
        Authenticator proxyAuthenticator = HttpApi.getProxyHeaderAuth(username, password);
        return new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(300L, TimeUnit.SECONDS).proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort))).proxyAuthenticator(proxyAuthenticator).addInterceptor((Interceptor)debugInterceptor);
    }

    public static Authenticator getProxyHeaderAuth(final String username, final String password) {
        return new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)username, (String)password);
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            }
        };
    }

    public static Authenticator getHeaderAuth(final String username, final String password) {
        return new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)username, (String)password);
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        };
    }

    public static Headers getHeaders() {
        return RequestBuilderFactory.getHeaders();
    }

    public static String getHeader(String name) {
        return RequestBuilderFactory.getHeaders().get(name);
    }

    public static void setHeaders(Map<String, String> map) {
        RequestBuilderFactory.setHeaders(Headers.of(map));
    }

    public static void addHeaders(Map<String, String> map) {
        Headers headers = RequestBuilderFactory.getHeaders();
        Headers.Builder headersBuilder = headers.newBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            headersBuilder.set(entry.getKey(), entry.getValue());
        }
        RequestBuilderFactory.setHeaders(headersBuilder.build());
    }

    public static void addHeader(String name, String value) {
        Headers headers = RequestBuilderFactory.getHeaders();
        Headers.Builder headersBuilder = headers.newBuilder();
        headersBuilder.set(name, value);
        RequestBuilderFactory.setHeaders(headersBuilder.build());
    }

    public static void clearHeaders() {
        RequestBuilderFactory.setHeaders(Headers.of((String[])new String[0]));
    }

    public static void removeHeaders(Map<String, String> map) {
        Headers headers = RequestBuilderFactory.getHeaders();
        Headers.Builder headersBuilder = headers.newBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            headersBuilder.removeAll(entry.getKey());
        }
        RequestBuilderFactory.setHeaders(Headers.of(map));
    }

    public static void removeHeader(String name) {
        Headers headers = RequestBuilderFactory.getHeaders();
        Headers.Builder headersBuilder = headers.newBuilder();
        headersBuilder.removeAll(name);
        RequestBuilderFactory.setHeaders(headersBuilder.build());
    }

    private static Map<String, String> beanToMap(Object bean) {
        String value;
        Object object;
        String key;
        if (bean == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Field[] fields = bean.getClass().getFields();
        if (fields.length == 0) {
            return result;
        }
        for (Field field : fields) {
            key = field.getName();
            try {
                object = field.get(bean);
                if (object == null) continue;
                value = String.valueOf(field.get(bean));
                result.put(key, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        fields = bean.getClass().getSuperclass().getFields();
        if (fields.length == 0) {
            return result;
        }
        for (Field field : fields) {
            key = field.getName();
            try {
                object = field.get(bean);
                if (object == null) continue;
                value = String.valueOf(field.get(bean));
                result.put(key, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Object sendRequest(Request request, Callback callback) {
        HttpApi.getOkHttpClient().newCall(request).enqueue(callback);
        return request.tag();
    }

    public static <T extends AResponse> Object sendRequest(Request request, T callback) {
        callback.onStart();
        HttpApi.getOkHttpClient().newCall(request).enqueue(callback);
        return request.tag();
    }

    public static <T> T sendRequestSync(Request request, Class<T> tClass) {
        Object result = null;
        try {
            Response response = HttpApi.getOkHttpClient().newCall(request).execute();
            String str = response.body().string();
            result = new Gson().fromJson(str, tClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(Request request, File file) {
        ResponseBody responseBody = null;
        FileOutputStream fos = null;
        try {
            Response response = HttpApi.getOkHttpClient().newCall(request).execute();
            responseBody = response.body();
            fos = new FileOutputStream(file);
            fos.write(responseBody.bytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (responseBody != null) {
                try {
                    responseBody.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void downloadSyncByGet(String url, Map<String, String> params, File file) {
        Request.Builder getBuilder = RequestBuilderFactory.createGetRequestBuilder(url, params);
        HttpApi.download(getBuilder.build(), file);
    }

    public static void downloadSyncByGet(String url, File file) {
        HttpApi.downloadSyncByGet(url, null, file);
    }

    public static <T> T getSync(String url, Class<T> tClass) {
        return HttpApi.getSync(url, null, tClass);
    }

    public static <T> T getSync(String url, Object params, Class<T> tClass) {
        return HttpApi.getSync(url, HttpApi.beanToMap(params), tClass);
    }

    public static <T> T getSync(String url, Map<String, String> params, Class<T> tClass) {
        Request.Builder getBuilder = RequestBuilderFactory.createGetRequestBuilder(url, params);
        return HttpApi.sendRequestSync(getBuilder.build(), tClass);
    }

    public static <T> T postSync(String url, Class<T> tClass) {
        return HttpApi.postSync(url, null, tClass);
    }

    public static <T> T postSync(String url, Object params, Class<T> tClass) {
        return HttpApi.postSync(url, HttpApi.beanToMap(params), tClass);
    }

    public static <T> T postSync(String url, Map<String, String> params, Class<T> tClass) {
        Request.Builder formBuilder = RequestBuilderFactory.createPostRequestBuilder(url, params);
        return HttpApi.sendRequestSync(formBuilder.build(), tClass);
    }

    public static <T> T postSync(String url, MediaType formType, Map<String, String> params, String fileKey, List<File> files, Class<T> tClass) {
        Request.Builder multiFormBuilder = RequestBuilderFactory.createMultiPostRequestBuilder(url, formType, fileKey, params, files);
        return HttpApi.sendRequestSync(multiFormBuilder.build(), tClass);
    }

    public static <T> T postSync(String url, Map<String, String> params, String fileKey, List<File> files, Class<T> tClass) {
        return HttpApi.postSync(url, MultipartBody.FORM, params, fileKey, files, tClass);
    }

    public static <T> T postSync(String url, Map<String, String> params, List<File> files, Class<T> tClass) {
        return HttpApi.postSync(url, params, UPLOAD_MULTI_FILE_KEY, files, tClass);
    }

    public static <T> T postSync(String url, Map<String, String> params, File[] files, Class<T> tClass) {
        return HttpApi.postSync(url, params, Arrays.asList(files), tClass);
    }

    public static <T> T postSyncJSON(String url, String json, Class<T> tClass) {
        Request.Builder jsonRequestBuilder = RequestBuilderFactory.createPostJsonRequestBuilder(url, json);
        return HttpApi.sendRequestSync(jsonRequestBuilder.build(), tClass);
    }

    public static <T> T postSyncJSON(String url, Object obj, Class<T> tClass) {
        return HttpApi.postSyncJSON(url, new Gson().toJson(obj), tClass);
    }

    public static <T extends AResponse> void get(String url, T callBack) {
        HttpApi.get(url, null, callBack);
    }

    public static <T extends AResponse> void get(String url, Object params, T callBack) {
        HttpApi.get(url, HttpApi.beanToMap(params), callBack);
    }

    public static <T extends AResponse> void get(String url, Map<String, String> params, T callBack) {
        Request.Builder getBuilder = RequestBuilderFactory.createGetRequestBuilder(url, params);
        HttpApi.sendRequest(getBuilder.build(), callBack);
    }

    public static <T extends AResponse> void post(String url, T callBack) {
        HttpApi.post(url, null, callBack);
    }

    public static <T extends AResponse> void post(String url, Object params, T callBack) {
        HttpApi.post(url, HttpApi.beanToMap(params), callBack);
    }

    public static <T extends AResponse> void post(String url, Map<String, String> params, T callBack) {
        Request.Builder formBuilder = RequestBuilderFactory.createPostRequestBuilder(url, params);
        HttpApi.sendRequest(formBuilder.build(), callBack);
    }

    public static <T extends AResponse> void post(String url, MediaType formType, Map<String, String> params, String fileKey, List<File> files, T callBack) {
        Request.Builder multiFormBuilder = RequestBuilderFactory.createMultiPostRequestBuilder(url, formType, fileKey, params, files);
        HttpApi.sendRequest(multiFormBuilder.build(), callBack);
    }

    public static <T extends AResponse> void post(String url, Map<String, String> params, String fileKey, List<File> files, T callBack) {
        HttpApi.post(url, MultipartBody.FORM, params, fileKey, files, callBack);
    }

    public static <T extends AResponse> void post(String url, Map<String, String> params, List<File> files, T callBack) {
        HttpApi.post(url, params, UPLOAD_MULTI_FILE_KEY, files, callBack);
    }

    public static <T extends AResponse> void post(String url, Map<String, String> params, File[] files, T callBack) {
        HttpApi.post(url, params, Arrays.asList(files), callBack);
    }

    public static <T extends AResponse> void postJSON(String url, String json, T callBack) {
        Request.Builder jsonRequestBuilder = RequestBuilderFactory.createPostJsonRequestBuilder(url, json);
        HttpApi.sendRequest(jsonRequestBuilder.build(), callBack);
    }

    public static <T extends AResponse> void postJSON(String url, Object obj, T callBack) {
        HttpApi.postJSON(url, new Gson().toJson(obj), callBack);
    }

    public static <T extends AResponse> void del(String url, T callBack) {
        HttpApi.del(url, null, callBack);
    }

    public static <T extends AResponse> void del(String url, Map<String, String> params, T callBack) {
        Request.Builder delRequestBuilder = RequestBuilderFactory.createDelRequestBuilder(url, params);
        HttpApi.sendRequest(delRequestBuilder.build(), callBack);
    }

    public static <T extends AResponse> void put(String url, Map<String, String> params, T callBack) {
        Request.Builder formBuilder = RequestBuilderFactory.createPutRequestBuilder(url, params);
        HttpApi.sendRequest(formBuilder.build(), callBack);
    }

    public static <T extends AResponse> void upload(String url, String fileKey, List<File> files, T callBack) {
        HttpApi.post(url, null, fileKey, files, callBack);
    }

    public static <T extends AResponse> void upload(String url, List<File> files, T callBack) {
        HttpApi.post(url, null, UPLOAD_MULTI_FILE_KEY, files, callBack);
    }

    public static <T extends AResponse> void upload(String url, String fileKey, File file, T callBack) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        HttpApi.post(url, null, files, callBack);
    }

    public static <T extends AResponse> void upload(String url, File file, T callBack) {
        HttpApi.upload(url, UPLOAD_FILE_KEY, file, callBack);
    }

    public static <T extends AResponse> void upload(String url, String fileKey, File[] file, T callBack) {
        HttpApi.upload(url, fileKey, file, callBack);
    }

    public static <T extends AResponse> void upload(String url, File[] file, T callBack) {
        HttpApi.upload(url, UPLOAD_MULTI_FILE_KEY, file, callBack);
    }

    static {
        debugInterceptor = new HttpLogInterceptor();
    }
}

