/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.network;

import android.app.Dialog;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.tcshare.androidutils.R;
import org.tcshare.dialog.LoadingDialog;

public abstract class AResponse<T>
implements Callback {
    protected static final Handler handler = new Handler(Looper.getMainLooper());
    protected Context ctx;
    private Dialog loadingDialog;

    public AResponse() {
    }

    public AResponse(Context ctx) {
        this(ctx, false);
    }

    public AResponse(Context ctx, boolean immerse) {
        this.ctx = ctx;
        if (ctx != null) {
            this.loadingDialog = LoadingDialog.createLoadingDialog(ctx, ctx.getString(R.string.loading), immerse);
        }
    }

    public void onFailure(Call call, IOException e) {
        e.printStackTrace();
        this.nextUI(call, e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        T obj = this.processResponce(call, response);
        this.nextUI(call, obj);
    }

    protected abstract T processResponce(Call var1, Response var2);

    private void nextUI(final Call call, final T body) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                AResponse.this.onResponseUI(call, body);
                AResponse.this.onFinished();
            }
        });
    }

    protected void nextUI(final Call call, final IOException e) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                AResponse.this.onFailureUI(call, e);
                AResponse.this.onFinished();
            }
        });
    }

    public void onFailureUI(Call call, IOException e) {
    }

    public abstract void onResponseUI(Call var1, T var2);

    public void onFinished() {
        if (this.loadingDialog != null) {
            this.loadingDialog.dismiss();
        }
    }

    public void onStart() {
        if (this.loadingDialog != null) {
            this.loadingDialog.show();
        }
    }
}

