/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.logview.logcatviewer.ui.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import org.tcshare.androidutils.R;

public class LogcatViewerListAdapter
extends BaseAdapter {
    private LayoutInflater mInflater;
    private ArrayList<String> mLogcatData;
    private ArrayList<String> mFilteredLogcatData;
    private String mLogPriorityLevel = "";
    private String mLogFilterText = "";
    private HashMap<String, Integer> mPriorityLevelColorMap;
    final String[] mPriorityLevels = new String[]{" V ", " D ", " I ", " W ", " E "};
    public static final String PRIORITY_LEVEL_VERBOSE = " V ";
    public static final String PRIORITY_LEVEL_DEBUG = " D ";
    public static final String PRIORITY_LEVEL_INFO = " I ";
    public static final String PRIORITY_LEVEL_WARNING = " W ";
    public static final String PRIORITY_LEVEL_ERROR = " E ";

    public LogcatViewerListAdapter(Context context) {
        this.mLogcatData = new ArrayList();
        this.mFilteredLogcatData = new ArrayList();
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mPriorityLevelColorMap = new HashMap();
        this.mPriorityLevelColorMap.put(PRIORITY_LEVEL_VERBOSE, -3355444);
        this.mPriorityLevelColorMap.put(PRIORITY_LEVEL_DEBUG, -15753896);
        this.mPriorityLevelColorMap.put(PRIORITY_LEVEL_INFO, -12417548);
        this.mPriorityLevelColorMap.put(PRIORITY_LEVEL_WARNING, -26624);
        this.mPriorityLevelColorMap.put(PRIORITY_LEVEL_ERROR, -4640223);
    }

    public void setLogFilterText(String logFilterText) {
        if (this.mLogFilterText.equals(logFilterText)) {
            return;
        }
        this.mLogFilterText = logFilterText;
        this.filterLogcatData();
    }

    public void setLogPriorityLevel(String logPriorityLevel) {
        if (this.mLogPriorityLevel.equals(logPriorityLevel)) {
            return;
        }
        this.mLogPriorityLevel = logPriorityLevel;
        this.filterLogcatData();
    }

    public String getLogFilterText() {
        return this.mLogFilterText;
    }

    public String getLogPriorityLevel() {
        return this.mLogPriorityLevel;
    }

    public int getCount() {
        return this.mFilteredLogcatData.size();
    }

    public long getItemId(int pos) {
        return pos;
    }

    public Object getItem(int pos) {
        return this.mFilteredLogcatData.get(pos);
    }

    public boolean isEmpty() {
        return this.mFilteredLogcatData.size() == 0;
    }

    public View getView(int pos, View convertView, ViewGroup parent) {
        boolean autoscroll;
        TextView holder;
        String logcatEntry = this.mFilteredLogcatData.get(pos);
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.logentry_listitem, parent, false);
            holder = (TextView)convertView.findViewById(R.id.logEntry);
            holder.setTypeface(Typeface.MONOSPACE);
            convertView.setTag((Object)holder);
        } else {
            holder = (TextView)convertView.getTag();
        }
        holder.setText((CharSequence)logcatEntry);
        holder.setTextColor(this.getTextColorForLogcatEntry(logcatEntry));
        boolean bl = autoscroll = parent.getScrollY() + parent.getHeight() >= parent.getBottom();
        if (autoscroll) {
            ((ListView)parent).setSelection(this.mFilteredLogcatData.size() - 1);
        }
        return convertView;
    }

    public void addLogEntry(String logEnry) {
        this.mLogcatData.add(logEnry);
        this.addFilterLogcatEntry(logEnry);
        this.notifyDataSetChanged();
    }

    public void reset() {
        this.mLogFilterText = "";
        this.mLogPriorityLevel = "";
        this.mFilteredLogcatData.clear();
        this.mFilteredLogcatData.addAll(this.mLogcatData);
        this.notifyDataSetChanged();
    }

    private void filterLogcatData() {
        this.mFilteredLogcatData.clear();
        if (TextUtils.isEmpty((CharSequence)this.mLogPriorityLevel) && TextUtils.isEmpty((CharSequence)this.mLogFilterText)) {
            this.mFilteredLogcatData = new ArrayList<String>(this.mLogcatData);
        }
        for (String logcatEntry : this.mLogcatData) {
            if (!TextUtils.isEmpty((CharSequence)this.mLogPriorityLevel) && (TextUtils.isEmpty((CharSequence)this.mLogPriorityLevel) || !this.priorityLevelConditionForFiltering(logcatEntry)) || !TextUtils.isEmpty((CharSequence)this.mLogFilterText) && (TextUtils.isEmpty((CharSequence)this.mLogFilterText) || !logcatEntry.toLowerCase().contains(this.mLogFilterText.toLowerCase()))) continue;
            this.mFilteredLogcatData.add(logcatEntry);
        }
    }

    private boolean priorityLevelConditionForFiltering(String logcatEntry) {
        int size = this.mPriorityLevels.length;
        for (int i = 0; i < size; ++i) {
            if (!this.mPriorityLevels[i].equals(this.mLogPriorityLevel)) continue;
            for (int j = i; j < size; ++j) {
                String priorityLevel1 = this.mPriorityLevels[j].trim() + "/";
                if (!logcatEntry.contains(this.mPriorityLevels[j]) && !logcatEntry.contains(priorityLevel1)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void addFilterLogcatEntry(String logcatEntry) {
        if ((TextUtils.isEmpty((CharSequence)this.mLogPriorityLevel) || !TextUtils.isEmpty((CharSequence)this.mLogPriorityLevel) && this.priorityLevelConditionForFiltering(logcatEntry)) && (TextUtils.isEmpty((CharSequence)this.mLogFilterText) || !TextUtils.isEmpty((CharSequence)this.mLogFilterText) && logcatEntry.toLowerCase().contains(this.mLogFilterText.toLowerCase()))) {
            this.mFilteredLogcatData.add(logcatEntry);
        }
    }

    private int getTextColorForLogcatEntry(String logcatEntry) {
        String priorityLevel = PRIORITY_LEVEL_VERBOSE;
        for (String key : this.mPriorityLevelColorMap.keySet()) {
            String key1 = key.trim() + "/";
            if (!logcatEntry.contains(key) && !logcatEntry.contains(key1)) continue;
            priorityLevel = key;
            break;
        }
        return this.mPriorityLevelColorMap.get(priorityLevel);
    }
}

