/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.logview.logcatviewer.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.tcshare.androidutils.R;
import org.tcshare.logview.logcatviewer.utils.Constants;

public class LogRecordsListAdapter
extends BaseAdapter {
    private File[] mLogRecordsFiles;
    private Context mContext;
    private LayoutInflater mInflater;

    public LogRecordsListAdapter(Context context) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.readAllRecordsFiles();
    }

    public int getCount() {
        return this.mLogRecordsFiles.length;
    }

    public Object getItem(int i) {
        return this.mLogRecordsFiles[i];
    }

    public long getItemId(int i) {
        return i;
    }

    public boolean isEmpty() {
        return this.mLogRecordsFiles.length == 0;
    }

    public View getView(int pos, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        File file = this.mLogRecordsFiles[pos];
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.logrecord_listitem, parent, false);
            viewHolder = new ViewHolder();
            viewHolder.mTvRecordFilename = (TextView)convertView.findViewById(R.id.recordFilename);
            viewHolder.mTvRecordFileLastModified = (TextView)convertView.findViewById(R.id.recordFileLastModified);
            viewHolder.mTvRecordFileSize = (TextView)convertView.findViewById(R.id.recordFileSize);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        viewHolder.mTvRecordFilename.setText((CharSequence)file.getName());
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss", Locale.US);
        viewHolder.mTvRecordFileLastModified.setText((CharSequence)formatter.format(new Date(file.lastModified())));
        viewHolder.mTvRecordFileSize.setText((CharSequence)this.getRecordFileSize(file.length()));
        return convertView;
    }

    public void notifyDataSetChanged() {
        this.readAllRecordsFiles();
        super.notifyDataSetChanged();
    }

    private void readAllRecordsFiles() {
        File logRecordDir = Constants.getRecordDir(this.mContext);
        this.mLogRecordsFiles = logRecordDir.listFiles();
        if (this.mLogRecordsFiles == null) {
            this.mLogRecordsFiles = new File[0];
        }
    }

    private String getRecordFileSize(long fileSize) {
        String fileSizeUnit = fileSize / 0x100000L == 0L ? "KB" : "MB";
        double size = fileSizeUnit.compareTo("KB") == 0 ? (double)fileSize / 1024.0 : (double)fileSize / 1048576.0;
        return String.format("%.2f " + fileSizeUnit, size);
    }

    private class ViewHolder {
        public TextView mTvRecordFilename;
        public TextView mTvRecordFileLastModified;
        public TextView mTvRecordFileSize;

        private ViewHolder() {
        }
    }
}

