/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.jsbridge;

import android.content.Context;
import android.webkit.WebView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class BridgeUtil {
    static final String YY_OVERRIDE_SCHEMA = "yy://";
    static final String YY_RETURN_DATA = "yy://return/";
    static final String YY_FETCH_QUEUE = "yy://return/_fetchQueue/";
    static final String EMPTY_STR = "";
    static final String UNDERLINE_STR = "_";
    static final String SPLIT_MARK = "/";
    static final String CALLBACK_ID_FORMAT = "JAVA_CB_%s";
    static final String JS_HANDLE_MESSAGE_FROM_JAVA = "javascript:WebViewJavascriptBridge._handleMessageFromNative('%s');";
    static final String JS_FETCH_QUEUE_FROM_JAVA = "javascript:WebViewJavascriptBridge._fetchQueue();";
    public static final String JAVASCRIPT_STR = "javascript:";

    public static String parseFunctionName(String jsUrl) {
        return jsUrl.replace("javascript:WebViewJavascriptBridge.", EMPTY_STR).replaceAll("\\(.*\\);", EMPTY_STR);
    }

    public static String getDataFromReturnUrl(String url) {
        if (url.startsWith(YY_FETCH_QUEUE)) {
            return url.replace(YY_FETCH_QUEUE, EMPTY_STR);
        }
        String temp = url.replace(YY_RETURN_DATA, EMPTY_STR);
        String[] functionAndData = temp.split(SPLIT_MARK);
        if (functionAndData.length >= 2) {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < functionAndData.length; ++i) {
                sb.append(functionAndData[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public static String getFunctionFromReturnUrl(String url) {
        String temp = url.replace(YY_RETURN_DATA, EMPTY_STR);
        String[] functionAndData = temp.split(SPLIT_MARK);
        if (functionAndData.length >= 1) {
            return functionAndData[0];
        }
        return null;
    }

    public static void webViewLoadJs(WebView view, String url) {
        String js = "var newscript = document.createElement(\"script\");";
        js = js + "newscript.src=\"" + url + "\";";
        js = js + "document.scripts[0].parentNode.insertBefore(newscript,document.scripts[0]);";
        view.loadUrl(JAVASCRIPT_STR + js);
    }

    public static void webViewLoadLocalJs(WebView view, String path) {
        String jsContent = BridgeUtil.assetFile2Str(view.getContext(), path);
        view.loadUrl(JAVASCRIPT_STR + jsContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String assetFile2Str(Context c, String urlStr) {
        InputStream in = null;
        try {
            in = c.getAssets().open(urlStr);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            StringBuilder sb = new StringBuilder();
            do {
                if ((line = bufferedReader.readLine()) == null || line.matches("^\\s*\\/\\/.*")) continue;
                sb.append(line);
            } while (line != null);
            bufferedReader.close();
            in.close();
            String string2 = sb.toString();
            return string2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

