/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.fileselectorlib;

import android.graphics.Color;
import androidx.annotation.DrawableRes;
import androidx.core.graphics.ColorUtils;
import org.tcshare.androidutils.R;

public class FileSelectorTheme {
    private int themeColor;
    private int topToolBarBackIcon = R.mipmap.fs_back_arrow;
    private int topToolBarTitleColor;
    private int topToolBarTitleSize = 22;
    private int topToolBarMenuIcon;
    private int naviBarTextColor;
    private int naviBarTextSize = 16;
    private int naviBarArrowIcon;
    private int fileNameColor;
    private int fileNameSize = 18;
    private int fileInfoColor;
    private int fileInfoSize = 15;
    private int checkboxDrawable;
    private boolean replaceCheckboxBackground = false;

    public FileSelectorTheme() {
        this.themeColor = Color.parseColor((String)"#1E90FF");
        this.topToolBarTitleColor = Color.parseColor((String)"#FFFFFF");
        this.topToolBarMenuIcon = R.mipmap.fs_menu;
        this.naviBarTextColor = Color.parseColor((String)"#000000");
        this.naviBarArrowIcon = R.mipmap.fs_next;
        this.fileNameColor = Color.parseColor((String)"#000000");
        this.fileInfoColor = Color.parseColor((String)"#A9A9A9");
    }

    public int getThemeColor() {
        return this.themeColor;
    }

    public FileSelectorTheme setThemeColor(int themeColor) {
        this.themeColor = themeColor;
        int default_color = Color.parseColor((String)"#FFFFFF");
        if (this.topToolBarTitleColor == default_color) {
            if (ColorUtils.calculateLuminance((int)themeColor) > 0.5) {
                this.setTopToolBarTitleColor("#000000");
            } else {
                this.setTopToolBarTitleColor("#FFFFFF");
            }
        }
        return this;
    }

    public FileSelectorTheme setThemeColor(String themeColorString) {
        int theme_color = Color.parseColor((String)themeColorString);
        this.setThemeColor(theme_color);
        return this;
    }

    public int getTopToolBarBackIcon() {
        return this.topToolBarBackIcon;
    }

    public FileSelectorTheme setTopToolBarBackIcon(@DrawableRes int topToolBarBackIcon) {
        this.topToolBarBackIcon = topToolBarBackIcon;
        return this;
    }

    public int getTopToolBarTitleColor() {
        return this.topToolBarTitleColor;
    }

    public FileSelectorTheme setTopToolBarTitleColor(int topToolBarTitleColor) {
        this.topToolBarTitleColor = topToolBarTitleColor;
        return this;
    }

    public FileSelectorTheme setTopToolBarTitleColor(String titleColorString) {
        this.topToolBarTitleColor = Color.parseColor((String)titleColorString);
        return this;
    }

    public int getTopToolBarTitleSize() {
        return this.topToolBarTitleSize;
    }

    public FileSelectorTheme setTopToolBarTitleSize(int topToolBarTitleSize) {
        this.topToolBarTitleSize = topToolBarTitleSize;
        return this;
    }

    public int getTopToolBarMenuIcon() {
        return this.topToolBarMenuIcon;
    }

    public FileSelectorTheme setTopToolBarMenuIcon(@DrawableRes int topToolBarMenuIcon) {
        this.topToolBarMenuIcon = topToolBarMenuIcon;
        return this;
    }

    public int getNaviBarTextColor() {
        return this.naviBarTextColor;
    }

    public FileSelectorTheme setNaviBarTextColor(int naviBarTextColor) {
        this.naviBarTextColor = naviBarTextColor;
        return this;
    }

    public FileSelectorTheme setNaviBarTextColor(String textColorString) {
        this.naviBarTextColor = Color.parseColor((String)textColorString);
        return this;
    }

    public int getNaviBarTextSize() {
        return this.naviBarTextSize;
    }

    public FileSelectorTheme setNaviBarTextSize(int naviBarTextSize) {
        this.naviBarTextSize = naviBarTextSize;
        return this;
    }

    public int getNaviBarArrowIcon() {
        return this.naviBarArrowIcon;
    }

    public FileSelectorTheme setNaviBarArrowIcon(@DrawableRes int naviBarArrowIcon) {
        this.naviBarArrowIcon = naviBarArrowIcon;
        return this;
    }

    public int getFileNameColor() {
        return this.fileNameColor;
    }

    public FileSelectorTheme setFileNameColor(int fileNameColor) {
        this.fileNameColor = fileNameColor;
        return this;
    }

    public FileSelectorTheme setFileNameColor(String fileNameColorString) {
        this.fileNameColor = Color.parseColor((String)fileNameColorString);
        return this;
    }

    public int getFileNameSize() {
        return this.fileNameSize;
    }

    public FileSelectorTheme setFileNameSize(int fileNameSize) {
        this.fileNameSize = fileNameSize;
        return this;
    }

    public int getFileInfoColor() {
        return this.fileInfoColor;
    }

    public FileSelectorTheme setFileInfoColor(int fileInfoColor) {
        this.fileInfoColor = fileInfoColor;
        return this;
    }

    public FileSelectorTheme setFileInfoColor(String fileInfoColorString) {
        this.fileInfoColor = Color.parseColor((String)fileInfoColorString);
        return this;
    }

    public int getFileInfoSize() {
        return this.fileInfoSize;
    }

    public FileSelectorTheme setFileInfoSize(int fileInfoSize) {
        this.fileInfoSize = fileInfoSize;
        return this;
    }

    public int getCheckboxDrawable() {
        return this.checkboxDrawable;
    }

    public FileSelectorTheme setCheckboxDrawable(@DrawableRes int checkboxDrawable) {
        this.checkboxDrawable = checkboxDrawable;
        this.replaceCheckboxBackground = true;
        return this;
    }

    public boolean isReplaceCheckboxBackground() {
        return this.replaceCheckboxBackground;
    }
}

