/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import org.tcshare.androidutils.R;

public class LoadMoreAdapterWrapper
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_FOOT = 2580;
    private final RecyclerView.Adapter<RecyclerView.ViewHolder> mAdapter;
    private final OnLoadMoreListener mLoadMoreListener;
    private LoadingState mState = LoadingState.LOADING_STATE_NORMAL;
    private boolean loading = true;
    private int currentPage = 0;
    private int previousTotal = 0;

    public <T extends RecyclerView.Adapter<? extends RecyclerView.ViewHolder>> LoadMoreAdapterWrapper(T mAdapter, OnLoadMoreListener mLoadMoreListener) {
        this.mAdapter = mAdapter;
        this.mLoadMoreListener = mLoadMoreListener;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 2580) {
            View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.default_footer_layout, parent, false);
            return new FooterViewHolder(itemView);
        }
        return this.mAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof FooterViewHolder) {
            FooterViewHolder viewHolder = (FooterViewHolder)holder;
            viewHolder.changState(this.mState);
            return;
        }
        this.mAdapter.onBindViewHolder(holder, position);
    }

    public int getItemCount() {
        return this.mAdapter.getItemCount() + (this.mState == LoadingState.LOADING_STATE_NORMAL ? 0 : 1);
    }

    public int getItemViewType(int position) {
        if (position == this.mAdapter.getItemCount()) {
            return 2580;
        }
        return this.mAdapter.getItemViewType(position);
    }

    public void setHasStableIds(boolean hasStableIds) {
        super.setHasStableIds(hasStableIds);
        this.mAdapter.setHasStableIds(hasStableIds);
    }

    public long getItemId(int position) {
        if (position > this.mAdapter.getItemCount() - 1) {
            return super.getItemId(position);
        }
        return this.mAdapter.getItemId(position);
    }

    public void updateLoadMoreState(LoadingState state) {
        this.mState = state;
        this.notifyDataSetChanged();
    }

    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        if (holder instanceof FooterViewHolder) {
            super.onViewRecycled(holder);
            return;
        }
        this.mAdapter.onViewRecycled(holder);
    }

    public boolean onFailedToRecycleView(@NonNull RecyclerView.ViewHolder holder) {
        if (holder instanceof FooterViewHolder) {
            return super.onFailedToRecycleView(holder);
        }
        return this.mAdapter.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        if (holder instanceof FooterViewHolder) {
            super.onViewAttachedToWindow(holder);
            return;
        }
        this.mAdapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        if (holder instanceof FooterViewHolder) {
            super.onViewDetachedFromWindow(holder);
        }
        this.mAdapter.onViewDetachedFromWindow(holder);
    }

    public void registerAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        super.registerAdapterDataObserver(observer);
        this.mAdapter.registerAdapterDataObserver(observer);
    }

    public void unregisterAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        super.unregisterAdapterDataObserver(observer);
        this.mAdapter.unregisterAdapterDataObserver(observer);
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mAdapter.onAttachedToRecyclerView(recyclerView);
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                LinearLayoutManager mLinearLayoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
                int visibleItemCount = recyclerView.getChildCount();
                int totalItemCount = mLinearLayoutManager.getItemCount();
                int firstVisibleItem = mLinearLayoutManager.findFirstVisibleItemPosition();
                if (LoadMoreAdapterWrapper.this.loading && totalItemCount > LoadMoreAdapterWrapper.this.previousTotal) {
                    LoadMoreAdapterWrapper.this.loading = false;
                    LoadMoreAdapterWrapper.this.previousTotal = totalItemCount;
                }
                if (!LoadMoreAdapterWrapper.this.loading && totalItemCount - visibleItemCount <= firstVisibleItem) {
                    LoadMoreAdapterWrapper.this.currentPage++;
                    if (LoadMoreAdapterWrapper.this.mLoadMoreListener != null && LoadMoreAdapterWrapper.this.mState != LoadingState.LOADING_STATE_LOADING) {
                        LoadMoreAdapterWrapper.this.mState = LoadingState.LOADING_STATE_LOADING;
                        recyclerView.post(() -> LoadMoreAdapterWrapper.this.notifyItemChanged(LoadMoreAdapterWrapper.this.mAdapter.getItemCount()));
                        LoadMoreAdapterWrapper.this.mLoadMoreListener.onLoadMore(LoadMoreAdapterWrapper.this.currentPage, new LoadFinishCallback(){

                            @Override
                            public void loadSuccess() {
                                LoadMoreAdapterWrapper.this.updateLoadMoreState(LoadingState.LOADING_STATE_NORMAL);
                            }

                            @Override
                            public void loadFailed() {
                                LoadMoreAdapterWrapper.this.updateLoadMoreState(LoadingState.LOADING_STATE_ERROR);
                            }

                            @Override
                            public void loadFinish() {
                                LoadMoreAdapterWrapper.this.updateLoadMoreState(LoadingState.LOADING_STATE_NO_MORE);
                            }
                        });
                    }
                    LoadMoreAdapterWrapper.this.loading = true;
                }
            }
        });
    }

    public void resetState() {
        this.updateLoadMoreState(LoadingState.LOADING_STATE_NORMAL);
        this.loading = false;
        this.currentPage = 0;
        this.previousTotal = 0;
    }

    public static enum LoadingState {
        LOADING_STATE_NO_MORE,
        LOADING_STATE_LOADING,
        LOADING_STATE_ERROR,
        LOADING_STATE_NORMAL;

    }

    public static interface OnLoadMoreListener {
        public void onLoadMore(int var1, LoadFinishCallback var2);
    }

    public class FooterViewHolder
    extends RecyclerView.ViewHolder
    implements IFooterView {
        private final ProgressBar mLoadingView;
        private final TextView mLoadingTextView;

        public FooterViewHolder(View itemView) {
            super(itemView);
            this.mLoadingView = (ProgressBar)itemView.findViewById(R.id.loading_view);
            this.mLoadingTextView = (TextView)itemView.findViewById(R.id.loading_text_view);
        }

        @Override
        public void changState(LoadingState state) {
            if (state == LoadingState.LOADING_STATE_LOADING) {
                this.mLoadingView.setVisibility(0);
                this.mLoadingTextView.setVisibility(0);
                this.mLoadingTextView.setText((CharSequence)"\u6b63\u5728\u52a0\u8f7d\uff0c\u8bf7\u7a0d\u540e\uff01");
            } else if (state == LoadingState.LOADING_STATE_NO_MORE) {
                this.mLoadingView.setVisibility(8);
                this.mLoadingTextView.setVisibility(0);
                this.mLoadingTextView.setText((CharSequence)"\u6ca1\u6709\u66f4\u591a\u6570\u636e\u5566\uff01");
                this.resetDelay();
            } else if (state == LoadingState.LOADING_STATE_ERROR) {
                this.mLoadingView.setVisibility(8);
                this.mLoadingTextView.setVisibility(0);
                this.mLoadingTextView.setText((CharSequence)"\u52a0\u8f7d\u51fa\u9519\u5566\uff01");
                this.resetDelay();
            } else if (state == LoadingState.LOADING_STATE_NORMAL) {
                this.mLoadingView.setVisibility(8);
                this.mLoadingTextView.setText((CharSequence)"");
                this.mLoadingTextView.setVisibility(8);
            }
        }

        private void resetDelay() {
            this.itemView.post(() -> {
                LoadMoreAdapterWrapper.this.loading = false;
                LoadMoreAdapterWrapper.this.notifyItemChanged(LoadMoreAdapterWrapper.this.getItemCount());
            });
        }
    }

    public static interface IFooterView {
        public void changState(LoadingState var1);
    }

    public static interface LoadFinishCallback {
        public void loadSuccess();

        public void loadFailed();

        public void loadFinish();
    }
}

