/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.activity;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.os.ResultReceiver;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.tcshare.utils.GetImagePath;

public class TCSelectOnePictureActivity
extends Activity {
    private static final int CHOOSE_PHOTO_0 = 2000;
    private static final int TAKE_PHOTO_0 = 3000;
    public static final String RESULT_RECEIVER = "result_receiver";
    public static final String SELECT_PICTURE = "select_pic";
    public static final String ACT_TYPE = "action_type";
    private ResultReceiver resultReceiver;
    private File cacheDir;
    private File imageFile;
    private Uri imgUri;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.overridePendingTransition(0, 0);
        if (this.getIntent() != null) {
            this.cacheDir = new File(this.getExternalFilesDir(Environment.DIRECTORY_PICTURES), "tcache");
            this.resultReceiver = (ResultReceiver)this.getIntent().getParcelableExtra(RESULT_RECEIVER);
            int actType = this.getIntent().getIntExtra(ACT_TYPE, 0);
            Intent intent = new Intent();
            this.imgUri = this.getImageUri();
            switch (actType) {
                case 0: {
                    intent.addFlags(1);
                    intent.addFlags(2);
                    intent.putExtra("output", (Parcelable)this.imgUri);
                    intent.setAction("android.media.action.IMAGE_CAPTURE");
                    this.startActivityForResult(intent, 3000);
                    break;
                }
                case 1: {
                    intent.setAction("android.intent.action.GET_CONTENT");
                    intent.setType("image/*");
                    this.startActivityForResult(intent, 2000);
                }
            }
        } else {
            this.finish();
        }
    }

    private Uri getImageUri() {
        this.cacheDir.mkdirs();
        this.imageFile = new File(this.cacheDir, String.format("%d.jpg", System.currentTimeMillis()));
        Uri imageUri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)this, (String)(this.getPackageName() + ".provider"), (File)this.imageFile) : Uri.fromFile((File)this.imageFile);
        return imageUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Bundle bundle = new Bundle();
        bundle.putString(SELECT_PICTURE, "");
        if (resultCode == -1) {
            switch (requestCode) {
                case 3000: {
                    bundle.putString(SELECT_PICTURE, this.imageFile.getPath());
                    break;
                }
                case 2000: {
                    ImageDecoder.Source sourceMap = null;
                    if (Build.VERSION.SDK_INT >= 28) {
                        sourceMap = ImageDecoder.createSource((ContentResolver)this.getContentResolver(), (Uri)data.getData());
                        Bitmap bitmap = null;
                        OutputStream fos = null;
                        bitmap = ImageDecoder.decodeBitmap((ImageDecoder.Source)sourceMap).copy(Bitmap.Config.ARGB_8888, true);
                        fos = this.getContentResolver().openOutputStream(this.imgUri, "rw");
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 95, fos);
                        fos.flush();
                        bundle.putString(SELECT_PICTURE, this.imageFile.getPath());
                        if (fos == null) break;
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                        break;
                        catch (IOException e) {
                            try {
                                e.printStackTrace();
                                bundle.putString(SELECT_PICTURE, null);
                                if (fos == null) break;
                            }
                            catch (Throwable throwable) {
                                if (fos != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                            break;
                        }
                    }
                    bundle.putString(SELECT_PICTURE, GetImagePath.getPath((Context)this, data.getData()));
                    break;
                }
            }
        }
        this.resultReceiver.send(resultCode, bundle);
        this.finish();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }
}

