package com.random_guys.pica

import android.os.Parcel
import android.os.Parcelable

class MainContact() : Parcelable{

    var mainContactType = MainContactType.None
    var localContact: Contact? = null
    var serverContact: Contact? = null

    constructor(parcel: Parcel) : this() {

    }

    enum class MainContactType {
        Server, Local, None
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {

    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<MainContact> {
        override fun createFromParcel(parcel: Parcel): MainContact {
            return MainContact(parcel)
        }

        override fun newArray(size: Int): Array<MainContact?> {
            return arrayOfNulls(size)
        }

        fun fromServerContact(contact: Contact): MainContact {
            val mainContact = MainContact()
            mainContact.serverContact = contact
            mainContact.mainContactType = MainContactType.Server

            return mainContact
        }

        fun fromLocalContact(contact: Contact): MainContact {
            val mainContact = MainContact()
            mainContact.localContact = contact
            mainContact.mainContactType = MainContactType.Local

            return mainContact
        }
    }
}