/*
 * Decompiled with CFR 0.152.
 */
package com.ramotion.foldingcell.animations;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;

public class FoldAnimation
extends Animation {
    private final FoldAnimationMode mFoldMode;
    private final int mCameraHeight;
    private float mFromDegrees;
    private float mToDegrees;
    private float mCenterX;
    private float mCenterY;
    private Camera mCamera;

    public FoldAnimation(FoldAnimationMode foldMode, int cameraHeight, long duration) {
        this.mFoldMode = foldMode;
        this.setFillAfter(true);
        this.setDuration(duration);
        this.mCameraHeight = cameraHeight;
    }

    public FoldAnimation withAnimationListener(Animation.AnimationListener animationListener) {
        this.setAnimationListener(animationListener);
        return this;
    }

    public FoldAnimation withStartOffset(int offset) {
        this.setStartOffset(offset);
        return this;
    }

    public FoldAnimation withInterpolator(Interpolator interpolator) {
        if (interpolator != null) {
            this.setInterpolator(interpolator);
        }
        return this;
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mCamera = new Camera();
        this.mCamera.setLocation(0.0f, 0.0f, (float)(-this.mCameraHeight));
        this.mCenterX = width / 2;
        switch (this.mFoldMode) {
            case FOLD_UP: {
                this.mCenterY = 0.0f;
                this.mFromDegrees = 0.0f;
                this.mToDegrees = 90.0f;
                break;
            }
            case FOLD_DOWN: {
                this.mCenterY = height;
                this.mFromDegrees = 0.0f;
                this.mToDegrees = -90.0f;
                break;
            }
            case UNFOLD_UP: {
                this.mCenterY = height;
                this.mFromDegrees = -90.0f;
                this.mToDegrees = 0.0f;
                break;
            }
            case UNFOLD_DOWN: {
                this.mCenterY = 0.0f;
                this.mFromDegrees = 90.0f;
                this.mToDegrees = 0.0f;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown animation mode.");
            }
        }
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        Camera camera = this.mCamera;
        Matrix matrix = t.getMatrix();
        float fromDegrees = this.mFromDegrees;
        float degrees = fromDegrees + (this.mToDegrees - fromDegrees) * interpolatedTime;
        camera.save();
        camera.rotateX(degrees);
        camera.getMatrix(matrix);
        camera.restore();
        matrix.preTranslate(-this.mCenterX, -this.mCenterY);
        matrix.postTranslate(this.mCenterX, this.mCenterY);
    }

    public String toString() {
        return "FoldAnimation{mFoldMode=" + (Object)((Object)this.mFoldMode) + ", mFromDegrees=" + this.mFromDegrees + ", mToDegrees=" + this.mToDegrees + '}';
    }

    public static enum FoldAnimationMode {
        FOLD_UP,
        UNFOLD_DOWN,
        FOLD_DOWN,
        UNFOLD_UP;

    }
}

