/*
 * Decompiled with CFR 0.152.
 */
package com.ramostear.captcha;

import com.ramostear.captcha.common.ConstArray;
import com.ramostear.captcha.common.Fonts;
import com.ramostear.captcha.support.CaptchaType;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import sun.misc.BASE64Encoder;

public abstract class AbstractCaptcha {
    public static final SecureRandom RANDOM = new SecureRandom();
    private Font font;
    protected int length = 5;
    protected int width = 160;
    protected int height = 50;
    protected CaptchaType type = CaptchaType.DEFAULT;
    protected String code = null;
    protected char[] expr = new char[this.length];

    public abstract void render(OutputStream var1);

    public abstract String toBase64();

    protected char[] captcha() {
        char[] codes = new char[this.length];
        block13: for (int i = 0; i < codes.length; ++i) {
            switch (this.type) {
                case ARITHMETIC: {
                    codes[i] = AbstractCaptcha.arithmeticExp(i, false);
                    continue block13;
                }
                case ARITHMETIC_ZH: {
                    codes[i] = AbstractCaptcha.arithmeticExp(i, true);
                    continue block13;
                }
                case WORD: {
                    codes[i] = AbstractCaptcha.nextChar(1);
                    continue block13;
                }
                case WORD_LOWER: {
                    codes[i] = AbstractCaptcha.nextChar(2);
                    continue block13;
                }
                case WORD_UPPER: {
                    codes[i] = AbstractCaptcha.nextChar(3);
                    continue block13;
                }
                case WORD_NUMBER_LOWER: {
                    codes[i] = AbstractCaptcha.nextChar(4);
                    continue block13;
                }
                case WORD_NUMBER_UPPER: {
                    codes[i] = AbstractCaptcha.nextChar(5);
                    continue block13;
                }
                case NUMBER: {
                    codes[i] = ConstArray.NUM_ARABIC[AbstractCaptcha.nextInt(ConstArray.NUM_ARABIC.length)];
                    continue block13;
                }
                case NUMBER_ZH_CN: {
                    codes[i] = ConstArray.NUM_ZH_CN[AbstractCaptcha.nextInt(ConstArray.NUM_ZH_CN.length)];
                    continue block13;
                }
                case NUMBER_ZH_HK: {
                    codes[i] = ConstArray.NUM_ZH_HK[AbstractCaptcha.nextInt(ConstArray.NUM_ZH_HK.length)];
                    continue block13;
                }
                case CHINESE: {
                    codes[i] = ConstArray.MODERN_CHINESE[AbstractCaptcha.nextInt(ConstArray.MODERN_CHINESE.length)];
                    continue block13;
                }
                default: {
                    codes[i] = AbstractCaptcha.nextChar();
                }
            }
        }
        this.code = this.type.equals((Object)CaptchaType.ARITHMETIC) || this.type.equals((Object)CaptchaType.ARITHMETIC_ZH) ? AbstractCaptcha.arithmeticResult(codes) : new String(codes);
        this.expr = codes;
        return codes;
    }

    public static int nextInt(int start, int end) {
        return Math.min(start, end) + AbstractCaptcha.nextInt(Math.abs(start - end));
    }

    public static int nextInt(int end) {
        return RANDOM.nextInt(end);
    }

    public static char nextChar() {
        return ConstArray.NUM_EN_MIX[AbstractCaptcha.nextInt(ConstArray.NUM_EN_MIX.length)];
    }

    public static char nextChar(int type) {
        switch (type) {
            case 1: {
                return ConstArray.EN_MIX[AbstractCaptcha.nextInt(ConstArray.EN_MIX.length)];
            }
            case 2: {
                return ConstArray.EN_LOWER[AbstractCaptcha.nextInt(ConstArray.EN_LOWER.length)];
            }
            case 3: {
                return ConstArray.EN_UPPER[AbstractCaptcha.nextInt(ConstArray.EN_UPPER.length)];
            }
            case 4: {
                return ConstArray.NUM_EN_MIX_LOWER[AbstractCaptcha.nextInt(ConstArray.NUM_EN_MIX_LOWER.length)];
            }
            case 5: {
                return ConstArray.NUM_EN_MIX_UPPER[AbstractCaptcha.nextInt(ConstArray.NUM_EN_MIX_UPPER.length)];
            }
        }
        return AbstractCaptcha.nextChar();
    }

    protected Color color(int start, int end) {
        start = Math.min(start, 255);
        end = Math.min(end, 255);
        int r = AbstractCaptcha.nextInt(start, end);
        int g = AbstractCaptcha.nextInt(start, end);
        int b = AbstractCaptcha.nextInt(start, end);
        return new Color(r, g, b);
    }

    protected Color color() {
        int[] rgb = ConstArray.COLORS[AbstractCaptcha.nextInt(ConstArray.COLORS.length)];
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public String toBase64(String type) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.render(outputStream);
        return type + new BASE64Encoder().encode(outputStream.toByteArray());
    }

    public String getCaptchaCode() {
        this.checkCode();
        return this.code;
    }

    public char[] text() {
        this.checkCode();
        return this.expr;
    }

    public void drawLine(Graphics2D g) {
        this.drawLine(AbstractCaptcha.nextInt(3, 5), g);
    }

    public void drawLine(int size, Graphics2D g) {
        size = Math.max(size, 3);
        for (int i = 0; i < size; ++i) {
            g.setColor(this.color());
            int x = AbstractCaptcha.nextInt(5);
            int y = AbstractCaptcha.nextInt(this.height);
            int _width = AbstractCaptcha.nextInt(this.width - 5, this.width);
            int _height = AbstractCaptcha.nextInt(this.height);
            g.drawLine(x, y, _width, _height);
        }
    }

    public void drawOval(Graphics2D g) {
        this.drawOval(AbstractCaptcha.nextInt(3, 8), g);
    }

    public void drawOval(int size, Graphics2D g) {
        size = Math.max(size, 3);
        for (int i = 0; i < size; ++i) {
            g.setColor(this.color());
            g.drawOval(AbstractCaptcha.nextInt(this.width - 20), AbstractCaptcha.nextInt(this.height - 10), AbstractCaptcha.nextInt(5, 15), AbstractCaptcha.nextInt(5, 15));
        }
    }

    public void drawBezierLine(Graphics2D g) {
        this.drawBezierLine(AbstractCaptcha.nextInt(2, 5), g);
    }

    public void drawBezierLine(int size, Graphics2D g) {
        size = Math.max(size, 2);
        for (int i = 0; i < size; ++i) {
            g.setColor(this.color());
            int x1 = 5;
            int y1 = AbstractCaptcha.nextInt(5, this.height / 2);
            int x2 = this.width - 5;
            int y2 = AbstractCaptcha.nextInt(this.height / 2, this.height - 5);
            int ctrlX = AbstractCaptcha.nextInt(this.width / 4, this.width / 4 * 3);
            int ctrlY = AbstractCaptcha.nextInt(5, this.height - 5);
            if (AbstractCaptcha.nextInt(2) == 0) {
                int ty = y1;
                y1 = y2;
                y2 = ty;
            }
            if (AbstractCaptcha.nextInt(2) == 0) {
                QuadCurve2D.Double shape = new QuadCurve2D.Double();
                ((QuadCurve2D)shape).setCurve(x1, y1, ctrlX, ctrlY, x2, y2);
                g.draw(shape);
                continue;
            }
            int ctrlX1 = AbstractCaptcha.nextInt(this.width / 4, this.width / 4 * 3);
            int ctrlY1 = AbstractCaptcha.nextInt(5, this.height - 5);
            CubicCurve2D.Double shape = new CubicCurve2D.Double(x1, y1, ctrlX, ctrlY, ctrlX1, ctrlY1, x2, y2);
            g.draw(shape);
        }
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = Fonts.getInstance().defaultFont();
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public CaptchaType getType() {
        return this.type;
    }

    public void setType(CaptchaType type) {
        this.type = type;
    }

    public String getCode() {
        return this.code;
    }

    public char[] getExpr() {
        return this.expr;
    }

    public void checkCode() {
        if (this.code == null || this.code.trim().equals("")) {
            this.captcha();
        }
    }

    private static char arithmeticExp(int i, boolean zh_cn) {
        if (zh_cn) {
            switch (i) {
                case 0: 
                case 2: {
                    return ConstArray.NUM_ZH_CN[AbstractCaptcha.nextInt(ConstArray.NUM_ZH_CN.length)];
                }
                case 1: {
                    return ConstArray.OPERATOR_ZH[AbstractCaptcha.nextInt(ConstArray.OPERATOR_ZH.length)];
                }
                case 3: {
                    return '=';
                }
            }
            return '?';
        }
        switch (i) {
            case 0: 
            case 2: {
                return ConstArray.NUM_ARABIC[AbstractCaptcha.nextInt(ConstArray.NUM_ARABIC.length)];
            }
            case 1: {
                return ConstArray.OPERATOR_EN[AbstractCaptcha.nextInt(ConstArray.OPERATOR_EN.length)];
            }
            case 3: {
                return '=';
            }
        }
        return '?';
    }

    private static String arithmeticResult(char[] codes) {
        char operator = codes[1];
        int num_1 = AbstractCaptcha.analysisChar(codes[0]);
        int num_2 = AbstractCaptcha.analysisChar(codes[2]);
        if (operator == '+' || operator == '\u52a0') {
            return String.valueOf(num_1 + num_2);
        }
        if (operator == '-' || operator == '\u51cf') {
            return String.valueOf(num_1 - num_2);
        }
        if (operator == '*' || operator == 'x' || operator == 'X' || operator == '\u4e58') {
            return String.valueOf(num_1 * num_2);
        }
        return "0";
    }

    private static int analysisChar(char character) {
        if (character == '0' || character == '\u96f6') {
            return 0;
        }
        if (character == '1' || character == '\u58f9' || character == '\u4e00') {
            return 1;
        }
        if (character == '2' || character == '\u8d30' || character == '\u4e8c') {
            return 2;
        }
        if (character == '3' || character == '\u53c1' || character == '\u4e09') {
            return 3;
        }
        if (character == '4' || character == '\u8086' || character == '\u56db') {
            return 4;
        }
        if (character == '5' || character == '\u4f0d' || character == '\u4e94') {
            return 5;
        }
        if (character == '6' || character == '\u9646' || character == '\u516d') {
            return 6;
        }
        if (character == '7' || character == '\u67d2' || character == '\u4e03') {
            return 7;
        }
        if (character == '8' || character == '\u634c' || character == '\u516b') {
            return 8;
        }
        if (character == '9' || character == '\u7396' || character == '\u4e5d') {
            return 9;
        }
        return 0;
    }
}

