/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.view;

import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.view.View;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.adapter.ArrayWheelAdapter;
import com.bigkoo.pickerview.lib.WheelView;
import com.bigkoo.pickerview.listener.OnItemSelectedListener;
import java.util.ArrayList;

public class MyWheelOptions<T> {
    private View view;
    private WheelView wv_option1;
    private WheelView wv_option2;
    private WheelView wv_option3;
    private ArrayList<T> mOptions1Items;
    private ArrayList<T> mOptions2Items;
    private ArrayList<T> mOptions3Items;
    private boolean linkage = false;
    private OnItemSelectedListener wheelListener_option1;
    private OnItemSelectedListener wheelListener_option2;
    private OnItemSelectedListener option1SelectedListener;
    private OnItemSelectedListener option2SelectedListener;
    private OnItemSelectedListener option3SelectedListener;

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public MyWheelOptions(View view) {
        this.view = view;
        this.setView(view);
    }

    public void setPicker(ArrayList<T> optionsItems) {
        this.setPicker(optionsItems, null, null, false);
    }

    public void setPicker(ArrayList<T> options1Items, ArrayList<T> options2Items, boolean linkage) {
        this.setPicker(options1Items, options2Items, null, linkage);
    }

    public void setPicker(ArrayList<T> options1Items, ArrayList<T> options2Items, ArrayList<T> options3Items, boolean linkage) {
        this.linkage = linkage;
        this.mOptions1Items = options1Items;
        this.mOptions2Items = options2Items;
        this.mOptions3Items = options3Items;
        int len = 4;
        this.wv_option1 = (WheelView)this.view.findViewById(R.id.options1);
        this.wv_option1.setAdapter(new ArrayWheelAdapter<T>(this.mOptions1Items, this.mOptions1Items.size()));
        this.wv_option1.setCurrentItem(0);
        this.wv_option2 = (WheelView)this.view.findViewById(R.id.options2);
        if (this.mOptions2Items != null) {
            this.wv_option2.setAdapter(new ArrayWheelAdapter<T>(this.mOptions2Items, this.mOptions2Items.size()));
        }
        this.wv_option2.setCurrentItem(this.wv_option1.getCurrentItem());
        this.wv_option3 = (WheelView)this.view.findViewById(R.id.options3);
        if (this.mOptions3Items != null) {
            this.wv_option3.setAdapter(new ArrayWheelAdapter<T>(this.mOptions3Items, this.mOptions3Items.size()));
        }
        this.wv_option3.setCurrentItem(this.wv_option3.getCurrentItem());
        int textSize = 25;
        this.wv_option1.setTextSize(textSize);
        this.wv_option2.setTextSize(textSize);
        this.wv_option3.setTextSize(textSize);
        if (this.mOptions2Items == null) {
            this.wv_option2.setVisibility(8);
        }
        if (this.mOptions3Items == null) {
            this.wv_option3.setVisibility(8);
        }
        this.wheelListener_option1 = new OnItemSelectedListener(){

            @Override
            public void onItemSelected(int index) {
                int opt2Select = 0;
                if (MyWheelOptions.this.mOptions2Items != null) {
                    opt2Select = MyWheelOptions.this.wv_option2.getCurrentItem();
                    opt2Select = opt2Select >= MyWheelOptions.this.mOptions2Items.size() - 1 ? MyWheelOptions.this.mOptions2Items.size() - 1 : opt2Select;
                    MyWheelOptions.this.wv_option2.setAdapter(new ArrayWheelAdapter(MyWheelOptions.this.mOptions2Items));
                    MyWheelOptions.this.wv_option2.setCurrentItem(opt2Select);
                }
                if (MyWheelOptions.this.mOptions3Items != null) {
                    MyWheelOptions.this.wheelListener_option2.onItemSelected(opt2Select);
                }
                if (MyWheelOptions.this.option1SelectedListener != null) {
                    MyWheelOptions.this.option1SelectedListener.onItemSelected(index);
                }
            }
        };
        this.wheelListener_option2 = new OnItemSelectedListener(){

            @Override
            public void onItemSelected(int index) {
                if (MyWheelOptions.this.mOptions3Items != null) {
                    int opt1Select = MyWheelOptions.this.wv_option1.getCurrentItem();
                    MyWheelOptions.this.wv_option3.setAdapter(new ArrayWheelAdapter(MyWheelOptions.this.mOptions3Items));
                    MyWheelOptions.this.wv_option3.setCurrentItem(index);
                    if (MyWheelOptions.this.option2SelectedListener != null) {
                        MyWheelOptions.this.option2SelectedListener.onItemSelected(index);
                    }
                    if (MyWheelOptions.this.option3SelectedListener != null) {
                        MyWheelOptions.this.option3SelectedListener.onItemSelected(index);
                    }
                }
            }
        };
        if (options2Items != null && linkage) {
            this.wv_option1.setOnItemSelectedListener(this.wheelListener_option1);
        } else {
            this.wv_option1.setOnItemSelectedListener(this.option1SelectedListener);
            if (options2Items != null) {
                this.wv_option2.setOnItemSelectedListener(this.option2SelectedListener);
            }
        }
        if (options3Items != null && linkage) {
            this.wv_option2.setOnItemSelectedListener(this.wheelListener_option2);
        } else if (options3Items != null) {
            this.wv_option3.setOnItemSelectedListener(this.option3SelectedListener);
        }
    }

    public void setLabels(String label1, String label2, String label3) {
        if (label1 != null) {
            this.wv_option1.setLabel(label1);
        }
        if (label2 != null) {
            this.wv_option2.setLabel(label2);
        }
        if (label3 != null) {
            this.wv_option3.setLabel(label3);
        }
    }

    public void setCyclic(boolean cyclic) {
        this.wv_option1.setCyclic(cyclic);
        this.wv_option2.setCyclic(cyclic);
        this.wv_option3.setCyclic(cyclic);
    }

    public void setCyclic(boolean cyclic1, boolean cyclic2, boolean cyclic3) {
        this.wv_option1.setCyclic(cyclic1);
        this.wv_option2.setCyclic(cyclic2);
        this.wv_option3.setCyclic(cyclic3);
    }

    public void setOption2Cyclic(boolean cyclic) {
        this.wv_option2.setCyclic(cyclic);
    }

    public void setOption3Cyclic(boolean cyclic) {
        this.wv_option3.setCyclic(cyclic);
    }

    public int[] getCurrentItems() {
        int[] currentItems = new int[]{this.wv_option1.getCurrentItem(), this.wv_option2.getCurrentItem(), this.wv_option3.getCurrentItem()};
        return currentItems;
    }

    public void setCurrentItems(int option1, int option2, int option3) {
        if (this.linkage) {
            this.itemSelected(option1, option2, option3);
        }
        this.wv_option1.setCurrentItem(option1);
        this.wv_option2.setCurrentItem(option2);
        this.wv_option3.setCurrentItem(option3);
    }

    public void setOption1SelectedListener(OnItemSelectedListener option1SelectedListener) {
        this.option1SelectedListener = option1SelectedListener;
    }

    public void setOption2SelectedListener(OnItemSelectedListener option2SelectedListener) {
        this.option2SelectedListener = option2SelectedListener;
    }

    public void setOption3SelectedListener(OnItemSelectedListener option3SelectedListener) {
        this.option3SelectedListener = option3SelectedListener;
    }

    private void itemSelected(int opt1Select, int opt2Select, int opt3Select) {
        if (this.mOptions2Items != null) {
            this.wv_option2.setAdapter(new ArrayWheelAdapter<T>(this.mOptions2Items));
            this.wv_option2.setCurrentItem(opt2Select);
        }
        if (this.mOptions3Items != null) {
            this.wv_option3.setAdapter(new ArrayWheelAdapter<T>(this.mOptions3Items));
            this.wv_option3.setCurrentItem(opt3Select);
        }
    }

    public void setCustomTypeface(@NonNull Typeface typeface) {
        this.wv_option1.setFont(typeface);
        this.wv_option2.setFont(typeface);
        this.wv_option3.setFont(typeface);
    }
}

