/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.listener.OnDismissListener;
import com.bigkoo.pickerview.utils.PickerViewAnimateUtil;

public abstract class BasePickerView {
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    private Context context;
    protected ViewGroup contentContainer;
    private ViewGroup decorView;
    private ViewGroup rootView;
    private FrameLayout overlayFrameLayout;
    private OnDismissListener onDismissListener;
    private boolean isDismissing;
    Button btnSubmit;
    Button btnCancel;
    private Animation outAnim;
    private Animation inAnim;
    private int gravity = 80;
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                BasePickerView.this.dismiss();
            }
            return false;
        }
    };

    public View getBtnSubmit() {
        return this.btnSubmit;
    }

    public void setBtnSubmit(Button btnSubmit) {
        this.btnSubmit = btnSubmit;
    }

    public View getBtnCancel() {
        return this.btnCancel;
    }

    public void setBtnCancel(Button btnCancel) {
        this.btnCancel = btnCancel;
    }

    public void hideCancelButton() {
        if (this.btnCancel != null) {
            this.btnCancel.setVisibility(8);
        }
    }

    public void hideSubmitButton() {
        if (this.btnSubmit != null) {
            this.btnSubmit.setVisibility(8);
        }
    }

    public void showCancelButton() {
        if (this.btnCancel != null) {
            this.btnCancel.setVisibility(0);
        }
    }

    public void showSubmitButton() {
        if (this.btnSubmit != null) {
            this.btnSubmit.setVisibility(0);
        }
    }

    public void setCancelButtonText(String newText) {
        if (this.btnCancel != null) {
            this.btnCancel.setText((CharSequence)newText);
        }
    }

    public void setSubmitButtonText(String newText) {
        if (this.btnSubmit != null) {
            this.btnSubmit.setText((CharSequence)newText);
        }
    }

    public void setCancelButtonText(int resId) {
        if (this.btnCancel != null) {
            this.btnCancel.setText(resId);
        }
    }

    public void setSubmitButtonText(int resId) {
        if (this.btnSubmit != null) {
            this.btnSubmit.setText(resId);
        }
    }

    public abstract void setCustomFont(@NonNull Typeface var1);

    public BasePickerView(Context context) {
        this.context = context;
        this.initViews();
        this.init();
        this.initEvents();
    }

    protected void initViews() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
        this.decorView = (ViewGroup)((Activity)this.context).getWindow().getDecorView().findViewById(0x1020002);
        this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.layout_basepickerview, this.decorView, false);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.overlayFrameLayout = (FrameLayout)this.rootView.findViewById(R.id.outmost_container);
        this.contentContainer = (ViewGroup)this.rootView.findViewById(R.id.content_container);
        this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    public void hideOverlay() {
        this.overlayFrameLayout.setBackgroundResource(0);
    }

    protected void init() {
        this.inAnim = this.getInAnimation();
        this.outAnim = this.getOutAnimation();
    }

    protected void initEvents() {
    }

    private void onAttached(View view) {
        this.decorView.addView(view);
        this.contentContainer.startAnimation(this.inAnim);
    }

    public void show() {
        if (this.isShowing()) {
            return;
        }
        this.onAttached((View)this.rootView);
    }

    public boolean isShowing() {
        View view = this.decorView.findViewById(R.id.outmost_container);
        return view != null;
    }

    public void dismiss() {
        if (this.isDismissing) {
            return;
        }
        this.outAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                BasePickerView.this.decorView.post(new Runnable(){

                    @Override
                    public void run() {
                        BasePickerView.this.decorView.removeView((View)BasePickerView.this.rootView);
                        BasePickerView.this.isDismissing = false;
                        if (BasePickerView.this.onDismissListener != null) {
                            BasePickerView.this.onDismissListener.onDismiss(BasePickerView.this);
                        }
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.contentContainer.startAnimation(this.outAnim);
        this.isDismissing = true;
    }

    public Animation getInAnimation() {
        int res = PickerViewAnimateUtil.getAnimationResource(this.gravity, true);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public Animation getOutAnimation() {
        int res = PickerViewAnimateUtil.getAnimationResource(this.gravity, false);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public BasePickerView setOnDismissListener(OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
        return this;
    }

    public BasePickerView setCancelable(boolean isCancelable) {
        View view = this.rootView.findViewById(R.id.outmost_container);
        if (isCancelable) {
            view.setOnTouchListener(this.onCancelableTouchListener);
        } else {
            view.setOnTouchListener(null);
        }
        return this;
    }

    public View findViewById(int id2) {
        return this.contentContainer.findViewById(id2);
    }
}

