/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.view.BasePickerView;
import com.bigkoo.pickerview.view.MyWheelTime;
import com.bigkoo.pickerview.view.WheelTime;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class TimePickerView
extends BasePickerView
implements View.OnClickListener {
    MyWheelTime wheelTime;
    private View btnSubmit;
    private View btnCancel;
    private TextView tvTitle;
    private static final String TAG_SUBMIT = "submit";
    private static final String TAG_CANCEL = "cancel";
    private OnTimeSelectListener timeSelectListener;

    @Override
    public void setCustomFont(@NonNull Typeface typeface) {
        this.wheelTime.setCustomTypeface(typeface);
    }

    public TimePickerView(Context context, Type type) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.pickerview_time, this.contentContainer);
        this.setBtnSubmit((Button)this.findViewById(R.id.btnSubmit));
        this.getBtnSubmit().setTag((Object)TAG_SUBMIT);
        this.setBtnCancel((Button)this.findViewById(R.id.btnCancel));
        this.getBtnCancel().setTag((Object)TAG_CANCEL);
        this.getBtnSubmit().setOnClickListener((View.OnClickListener)this);
        this.getBtnCancel().setOnClickListener((View.OnClickListener)this);
        this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        View timepickerview = this.findViewById(R.id.timepicker);
        this.wheelTime = new MyWheelTime(timepickerview, type);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hours = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int ampm = calendar.get(9);
        this.wheelTime.setPicker(year, month, day, hours, minute, second, ampm);
    }

    public void setRange(int startYear, int endYear) {
        this.wheelTime.setStartYear(startYear);
        this.wheelTime.setEndYear(endYear);
    }

    public void setTime(Date date, Type type) {
        Calendar calendar = Calendar.getInstance();
        if (date == null) {
            calendar.setTimeInMillis(System.currentTimeMillis());
        } else {
            calendar.setTime(date);
        }
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hours = type == Type.HOUR_MIN_APPM ? calendar.get(10) : calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        Log.v((String)"am_pm", (String)("" + calendar.get(9)));
        int ampm = calendar.get(9);
        this.wheelTime.setPicker(year, month, day, hours, minute, second, ampm);
    }

    public void setCyclic(boolean cyclic) {
        this.wheelTime.setCyclic(cyclic);
    }

    public void onClick(View v) {
        String tag = (String)v.getTag();
        if (tag.equals(TAG_CANCEL)) {
            this.dismiss();
            return;
        }
        if (this.timeSelectListener != null) {
            try {
                Date date = WheelTime.dateFormat.parse(this.wheelTime.getTime());
                this.timeSelectListener.onTimeSelect(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        this.dismiss();
    }

    public void setOnTimeSelectListener(OnTimeSelectListener timeSelectListener) {
        this.timeSelectListener = timeSelectListener;
    }

    public void setTitle(String title) {
        this.tvTitle.setText((CharSequence)title);
    }

    public static interface OnTimeSelectListener {
        public void onTimeSelect(Date var1);
    }

    public static enum Type {
        ALL,
        YEAR_MONTH_DAY,
        HOURS_MINS,
        MONTH_DAY_HOUR_MIN,
        YEAR_MONTH,
        HOUR_MIN_SEC,
        HOUR_MIN_APPM;

    }
}

