/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.view;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.TimePickerView;
import com.bigkoo.pickerview.adapter.ArrayWheelAdapter;
import com.bigkoo.pickerview.adapter.NumericWheelAdapter;
import com.bigkoo.pickerview.lib.WheelView;
import com.bigkoo.pickerview.listener.OnItemSelectedListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class WheelTime {
    public static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private View view;
    private WheelView wv_year;
    private WheelView wv_month;
    private WheelView wv_day;
    private WheelView wv_hours;
    private WheelView wv_mins;
    private WheelView wv_seconds;
    private WheelView wv_ampm;
    private TimePickerView.Type type;
    public static final int DEFULT_START_YEAR = 1990;
    public static final int DEFULT_END_YEAR = 2100;
    private int startYear = 1990;
    private int endYear = 2100;
    public static int s_year;
    public static int s_month;
    public static int s_day;
    public static int s_h;
    public static int s_m;
    public static int s_s;
    public static int s_ampm;

    public WheelTime(View view) {
        this.view = view;
        this.type = TimePickerView.Type.ALL;
        this.setView(view);
    }

    public WheelTime(View view, TimePickerView.Type type) {
        this.view = view;
        this.type = type;
        this.setView(view);
    }

    public void setPicker(int first, int second, int third, TimePickerView.Type type) {
        if (type == TimePickerView.Type.YEAR_MONTH_DAY) {
            this.setPicker(first, second, third, 0, 0, 0, 0);
        } else if (type == TimePickerView.Type.HOUR_MIN_SEC) {
            this.setPicker(0, 0, 0, first, second, third, 0);
        }
    }

    public void setPicker(int year, int month, int day, int h, int m, int s, int ampm) {
        String[] months_big = new String[]{"1", "3", "5", "7", "8", "10", "12"};
        String[] months_little = new String[]{"4", "6", "9", "11"};
        final List<String> list_big = Arrays.asList(months_big);
        final List<String> list_little = Arrays.asList(months_little);
        Context context = this.view.getContext();
        this.wv_year = (WheelView)this.view.findViewById(R.id.year);
        this.wv_year.setAdapter(new NumericWheelAdapter(this.startYear, this.endYear));
        this.wv_year.setLabel(context.getString(R.string.pickerview_year));
        this.wv_year.setCurrentItem(year - this.startYear);
        this.wv_month = (WheelView)this.view.findViewById(R.id.month);
        this.wv_month.setAdapter(new NumericWheelAdapter(1, 12));
        this.wv_month.setLabel(context.getString(R.string.pickerview_month));
        this.wv_month.setCurrentItem(month);
        this.wv_day = (WheelView)this.view.findViewById(R.id.day);
        if (list_big.contains(String.valueOf(month + 1))) {
            this.wv_day.setAdapter(new NumericWheelAdapter(1, 31));
        } else if (list_little.contains(String.valueOf(month + 1))) {
            this.wv_day.setAdapter(new NumericWheelAdapter(1, 30));
        } else if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            this.wv_day.setAdapter(new NumericWheelAdapter(1, 29));
        } else {
            this.wv_day.setAdapter(new NumericWheelAdapter(1, 28));
        }
        this.wv_day.setLabel(context.getString(R.string.pickerview_day));
        this.wv_day.setCurrentItem(day - 1);
        if (this.type == TimePickerView.Type.HOUR_MIN_APPM) {
            this.wv_hours = (WheelView)this.view.findViewById(R.id.hour);
            this.wv_hours.setAdapter(new NumericWheelAdapter(1, 12));
            this.wv_hours.setLabel(context.getString(R.string.pickerview_hours));
            this.wv_hours.setCurrentItem(h);
        } else {
            this.wv_hours = (WheelView)this.view.findViewById(R.id.hour);
            this.wv_hours.setAdapter(new NumericWheelAdapter(0, 23));
            this.wv_hours.setLabel(context.getString(R.string.pickerview_hours));
            this.wv_hours.setCurrentItem(h);
        }
        this.wv_mins = (WheelView)this.view.findViewById(R.id.min);
        this.wv_mins.setAdapter(new NumericWheelAdapter(0, 59));
        this.wv_mins.setLabel(context.getString(R.string.pickerview_minutes));
        this.wv_mins.setCurrentItem(m);
        this.wv_seconds = (WheelView)this.view.findViewById(R.id.sec);
        this.wv_seconds.setAdapter(new NumericWheelAdapter(0, 59));
        this.wv_seconds.setLabel(context.getString(R.string.pickerview_seconds));
        String[] amPM = new String[]{"AM", "PM"};
        ArrayList<String> ampmlist = new ArrayList<String>(Arrays.asList(amPM));
        this.wv_ampm = (WheelView)this.view.findViewById(R.id.amPm);
        this.wv_ampm.setAdapter(new ArrayWheelAdapter<String>(ampmlist, ampmlist.size()));
        this.wv_ampm.setLabel(context.getString(R.string.pickerview_ampm));
        this.wv_ampm.setCurrentItem(ampm);
        OnItemSelectedListener wheelListener_year = new OnItemSelectedListener(){

            @Override
            public void onItemSelected(int index) {
                int year_num = index + WheelTime.this.startYear;
                int maxItem = 30;
                if (list_big.contains(String.valueOf(WheelTime.this.wv_month.getCurrentItem() + 1))) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 31));
                    maxItem = 31;
                } else if (list_little.contains(String.valueOf(WheelTime.this.wv_month.getCurrentItem() + 1))) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 30));
                    maxItem = 30;
                } else if (year_num % 4 == 0 && year_num % 100 != 0 || year_num % 400 == 0) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 29));
                    maxItem = 29;
                } else {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 28));
                    maxItem = 28;
                }
                if (WheelTime.this.wv_day.getCurrentItem() > maxItem - 1) {
                    WheelTime.this.wv_day.setCurrentItem(maxItem - 1);
                }
            }
        };
        OnItemSelectedListener wheelListener_month = new OnItemSelectedListener(){

            @Override
            public void onItemSelected(int index) {
                int month_num = index + 1;
                int maxItem = 30;
                if (list_big.contains(String.valueOf(month_num))) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 31));
                    maxItem = 31;
                } else if (list_little.contains(String.valueOf(month_num))) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 30));
                    maxItem = 30;
                } else if ((WheelTime.this.wv_year.getCurrentItem() + WheelTime.this.startYear) % 4 == 0 && (WheelTime.this.wv_year.getCurrentItem() + WheelTime.this.startYear) % 100 != 0 || (WheelTime.this.wv_year.getCurrentItem() + WheelTime.this.startYear) % 400 == 0) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 29));
                    maxItem = 29;
                } else {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 28));
                    maxItem = 28;
                }
                if (WheelTime.this.wv_day.getCurrentItem() > maxItem - 1) {
                    WheelTime.this.wv_day.setCurrentItem(maxItem - 1);
                }
            }
        };
        this.wv_year.setOnItemSelectedListener(wheelListener_year);
        this.wv_month.setOnItemSelectedListener(wheelListener_month);
        int textSize = 6;
        switch (this.type) {
            case ALL: {
                textSize *= 3;
                break;
            }
            case YEAR_MONTH_DAY: {
                textSize *= 4;
                this.wv_hours.setVisibility(8);
                this.wv_mins.setVisibility(8);
                this.wv_ampm.setVisibility(8);
                break;
            }
            case HOURS_MINS: {
                textSize *= 4;
                this.wv_year.setVisibility(8);
                this.wv_month.setVisibility(8);
                this.wv_day.setVisibility(8);
                this.wv_ampm.setVisibility(8);
                break;
            }
            case MONTH_DAY_HOUR_MIN: {
                textSize *= 3;
                this.wv_year.setVisibility(8);
                this.wv_ampm.setVisibility(8);
                break;
            }
            case YEAR_MONTH: {
                textSize *= 4;
                this.wv_day.setVisibility(8);
                this.wv_hours.setVisibility(8);
                this.wv_mins.setVisibility(8);
                this.wv_ampm.setVisibility(8);
                break;
            }
            case HOUR_MIN_SEC: {
                textSize *= 3;
                this.wv_year.setVisibility(8);
                this.wv_month.setVisibility(8);
                this.wv_day.setVisibility(8);
                this.wv_ampm.setVisibility(8);
                break;
            }
            case HOUR_MIN_APPM: {
                textSize *= 3;
                this.wv_year.setVisibility(8);
                this.wv_month.setVisibility(8);
                this.wv_day.setVisibility(8);
                this.wv_seconds.setVisibility(8);
            }
        }
        this.wv_day.setTextSize(textSize);
        this.wv_month.setTextSize(textSize);
        this.wv_year.setTextSize(textSize);
        this.wv_hours.setTextSize(textSize);
        this.wv_mins.setTextSize(textSize);
        this.wv_seconds.setTextSize(textSize);
        this.wv_ampm.setTextSize(textSize);
    }

    public void setCyclic(boolean cyclic) {
        this.wv_year.setCyclic(cyclic);
        this.wv_month.setCyclic(cyclic);
        this.wv_day.setCyclic(cyclic);
        this.wv_hours.setCyclic(cyclic);
        this.wv_mins.setCyclic(cyclic);
        this.wv_seconds.setCyclic(cyclic);
        this.wv_ampm.setCyclic(cyclic);
    }

    public String getTime() {
        StringBuffer sb = new StringBuffer();
        if (this.type == TimePickerView.Type.HOUR_MIN_SEC) {
            sb.append(this.wv_hours.getCurrentItem()).append(":").append(this.wv_mins.getCurrentItem()).append(this.wv_seconds.getCurrentItem());
        } else if (this.type == TimePickerView.Type.HOUR_MIN_APPM) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            sb.append(calendar.get(1)).append("-").append(calendar.get(2) + 1).append("-").append(calendar.get(5)).append(" ").append(this.wv_hours.getCurrentItem()).append(":").append(this.wv_mins.getCurrentItem()).append(" ").append(this.wv_ampm.getCurrentItem());
        } else {
            sb.append(this.wv_year.getCurrentItem() + this.startYear).append("-").append(this.wv_month.getCurrentItem() + 1).append("-").append(this.wv_day.getCurrentItem() + 1).append(" ").append(this.wv_hours.getCurrentItem()).append(":").append(this.wv_mins.getCurrentItem()).append(this.wv_seconds.getCurrentItem()).append(this.wv_ampm.getCurrentItem());
        }
        Log.v((String)"get timee", (String)sb.toString());
        return sb.toString();
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }
}

