/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.view;

import android.view.View;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.adapter.ArrayWheelAdapter;
import com.bigkoo.pickerview.lib.WheelView;
import com.bigkoo.pickerview.listener.OnItemSelectedListener;
import java.util.ArrayList;

public class WheelOptions<T> {
    private View view;
    private WheelView wv_option1;
    private WheelView wv_option2;
    private WheelView wv_option3;
    private ArrayList<T> mOptions1Items;
    private ArrayList<ArrayList<T>> mOptions2Items;
    private ArrayList<ArrayList<ArrayList<T>>> mOptions3Items;
    private boolean linkage = false;
    private OnItemSelectedListener wheelListener_option1;
    private OnItemSelectedListener wheelListener_option2;

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public WheelOptions(View view) {
        this.view = view;
        this.setView(view);
    }

    public void setPicker(ArrayList<T> optionsItems) {
        this.setPicker(optionsItems, null, null, false);
    }

    public void setPicker(ArrayList<T> options1Items, ArrayList<ArrayList<T>> options2Items, boolean linkage) {
        this.setPicker(options1Items, options2Items, null, linkage);
    }

    public void setPicker(ArrayList<T> options1Items, ArrayList<ArrayList<T>> options2Items, ArrayList<ArrayList<ArrayList<T>>> options3Items, boolean linkage) {
        this.linkage = linkage;
        this.mOptions1Items = options1Items;
        this.mOptions2Items = options2Items;
        this.mOptions3Items = options3Items;
        int len = 4;
        if (this.mOptions3Items == null) {
            len = 8;
        }
        if (this.mOptions2Items == null) {
            len = 12;
        }
        this.wv_option1 = (WheelView)this.view.findViewById(R.id.options1);
        this.wv_option1.setAdapter(new ArrayWheelAdapter<T>(this.mOptions1Items, len));
        this.wv_option1.setCurrentItem(0);
        this.wv_option2 = (WheelView)this.view.findViewById(R.id.options2);
        if (this.mOptions2Items != null) {
            this.wv_option2.setAdapter(new ArrayWheelAdapter<T>(this.mOptions2Items.get(0)));
        }
        this.wv_option2.setCurrentItem(this.wv_option1.getCurrentItem());
        this.wv_option3 = (WheelView)this.view.findViewById(R.id.options3);
        if (this.mOptions3Items != null) {
            this.wv_option3.setAdapter(new ArrayWheelAdapter<T>(this.mOptions3Items.get(0).get(0)));
        }
        this.wv_option3.setCurrentItem(this.wv_option3.getCurrentItem());
        int textSize = 25;
        this.wv_option1.setTextSize(textSize);
        this.wv_option2.setTextSize(textSize);
        this.wv_option3.setTextSize(textSize);
        if (this.mOptions2Items == null) {
            this.wv_option2.setVisibility(8);
        }
        if (this.mOptions3Items == null) {
            this.wv_option3.setVisibility(8);
        }
        this.wheelListener_option1 = new OnItemSelectedListener(){

            @Override
            public void onItemSelected(int index) {
                int opt2Select = 0;
                if (WheelOptions.this.mOptions2Items != null) {
                    opt2Select = WheelOptions.this.wv_option2.getCurrentItem();
                    opt2Select = opt2Select >= ((ArrayList)WheelOptions.this.mOptions2Items.get(index)).size() - 1 ? ((ArrayList)WheelOptions.this.mOptions2Items.get(index)).size() - 1 : opt2Select;
                    WheelOptions.this.wv_option2.setAdapter(new ArrayWheelAdapter((ArrayList)WheelOptions.this.mOptions2Items.get(index)));
                    WheelOptions.this.wv_option2.setCurrentItem(opt2Select);
                }
                if (WheelOptions.this.mOptions3Items != null) {
                    WheelOptions.this.wheelListener_option2.onItemSelected(opt2Select);
                }
            }
        };
        this.wheelListener_option2 = new OnItemSelectedListener(){

            @Override
            public void onItemSelected(int index) {
                if (WheelOptions.this.mOptions3Items != null) {
                    int opt1Select = WheelOptions.this.wv_option1.getCurrentItem();
                    opt1Select = opt1Select >= WheelOptions.this.mOptions3Items.size() - 1 ? WheelOptions.this.mOptions3Items.size() - 1 : opt1Select;
                    index = index >= ((ArrayList)WheelOptions.this.mOptions2Items.get(opt1Select)).size() - 1 ? ((ArrayList)WheelOptions.this.mOptions2Items.get(opt1Select)).size() - 1 : index;
                    int opt3 = WheelOptions.this.wv_option3.getCurrentItem();
                    opt3 = opt3 >= ((ArrayList)((ArrayList)WheelOptions.this.mOptions3Items.get(opt1Select)).get(index)).size() - 1 ? ((ArrayList)((ArrayList)WheelOptions.this.mOptions3Items.get(opt1Select)).get(index)).size() - 1 : opt3;
                    WheelOptions.this.wv_option3.setAdapter(new ArrayWheelAdapter((ArrayList)((ArrayList)WheelOptions.this.mOptions3Items.get(WheelOptions.this.wv_option1.getCurrentItem())).get(index)));
                    WheelOptions.this.wv_option3.setCurrentItem(opt3);
                }
            }
        };
        if (options2Items != null && linkage) {
            this.wv_option1.setOnItemSelectedListener(this.wheelListener_option1);
        }
        if (options3Items != null && linkage) {
            this.wv_option2.setOnItemSelectedListener(this.wheelListener_option2);
        }
    }

    public void setLabels(String label1, String label2, String label3) {
        if (label1 != null) {
            this.wv_option1.setLabel(label1);
        }
        if (label2 != null) {
            this.wv_option2.setLabel(label2);
        }
        if (label3 != null) {
            this.wv_option3.setLabel(label3);
        }
    }

    public void setCyclic(boolean cyclic) {
        this.wv_option1.setCyclic(cyclic);
        this.wv_option2.setCyclic(cyclic);
        this.wv_option3.setCyclic(cyclic);
    }

    public void setCyclic(boolean cyclic1, boolean cyclic2, boolean cyclic3) {
        this.wv_option1.setCyclic(cyclic1);
        this.wv_option2.setCyclic(cyclic2);
        this.wv_option3.setCyclic(cyclic3);
    }

    public void setOption2Cyclic(boolean cyclic) {
        this.wv_option2.setCyclic(cyclic);
    }

    public void setOption3Cyclic(boolean cyclic) {
        this.wv_option3.setCyclic(cyclic);
    }

    public int[] getCurrentItems() {
        int[] currentItems = new int[]{this.wv_option1.getCurrentItem(), this.wv_option2.getCurrentItem(), this.wv_option3.getCurrentItem()};
        return currentItems;
    }

    public void setCurrentItems(int option1, int option2, int option3) {
        if (this.linkage) {
            this.itemSelected(option1, option2, option3);
        }
        this.wv_option1.setCurrentItem(option1);
        this.wv_option2.setCurrentItem(option2);
        this.wv_option3.setCurrentItem(option3);
    }

    private void itemSelected(int opt1Select, int opt2Select, int opt3Select) {
        if (this.mOptions2Items != null) {
            this.wv_option2.setAdapter(new ArrayWheelAdapter<T>(this.mOptions2Items.get(opt1Select)));
            this.wv_option2.setCurrentItem(opt2Select);
        }
        if (this.mOptions3Items != null) {
            this.wv_option3.setAdapter(new ArrayWheelAdapter<T>(this.mOptions3Items.get(opt1Select).get(opt2Select)));
            this.wv_option3.setCurrentItem(opt3Select);
        }
    }
}

