/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.view.BasePickerView;
import com.bigkoo.pickerview.view.MyWheelOptions;
import java.util.ArrayList;

public class MyOptionsPickerView<T>
extends BasePickerView
implements View.OnClickListener {
    MyWheelOptions wheelOptions;
    private View btnSubmit;
    private View btnCancel;
    private TextView tvTitle;
    private OnOptionsSelectListener optionsSelectListener;
    private static final String TAG_SUBMIT = "submit";
    private static final String TAG_CANCEL = "cancel";

    public MyOptionsPickerView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.pickerview_options, this.contentContainer);
        this.btnSubmit = this.findViewById(R.id.btnSubmit);
        this.btnSubmit.setTag((Object)TAG_SUBMIT);
        this.btnCancel = this.findViewById(R.id.btnCancel);
        this.btnCancel.setTag((Object)TAG_CANCEL);
        this.btnSubmit.setOnClickListener((View.OnClickListener)this);
        this.btnCancel.setOnClickListener((View.OnClickListener)this);
        this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        View optionspicker = this.findViewById(R.id.optionspicker);
        this.wheelOptions = new MyWheelOptions(optionspicker);
    }

    public void setPicker(ArrayList<T> optionsItems) {
        this.wheelOptions.setPicker(optionsItems, null, null, false);
    }

    public void setPicker(ArrayList<T> options1Items, ArrayList<T> options2Items, boolean linkage) {
        this.wheelOptions.setPicker(options1Items, options2Items, null, linkage);
    }

    public void setPicker(ArrayList<T> options1Items, ArrayList<T> options2Items, ArrayList<T> options3Items, boolean linkage) {
        this.wheelOptions.setPicker(options1Items, options2Items, options3Items, linkage);
    }

    public void setSelectOptions(int option1) {
        this.wheelOptions.setCurrentItems(option1, 0, 0);
    }

    public void setSelectOptions(int option1, int option2) {
        this.wheelOptions.setCurrentItems(option1, option2, 0);
    }

    public void setSelectOptions(int option1, int option2, int option3) {
        this.wheelOptions.setCurrentItems(option1, option2, option3);
    }

    public void setLabels(String label1) {
        this.wheelOptions.setLabels(label1, null, null);
    }

    public void setLabels(String label1, String label2) {
        this.wheelOptions.setLabels(label1, label2, null);
    }

    public void setLabels(String label1, String label2, String label3) {
        this.wheelOptions.setLabels(label1, label2, label3);
    }

    public void setCyclic(boolean cyclic) {
        this.wheelOptions.setCyclic(cyclic);
    }

    public void setCyclic(boolean cyclic1, boolean cyclic2, boolean cyclic3) {
        this.wheelOptions.setCyclic(cyclic1, cyclic2, cyclic3);
    }

    public void onClick(View v) {
        String tag = (String)v.getTag();
        if (tag.equals(TAG_CANCEL)) {
            this.dismiss();
            return;
        }
        if (this.optionsSelectListener != null) {
            int[] optionsCurrentItems = this.wheelOptions.getCurrentItems();
            this.optionsSelectListener.onOptionsSelect(optionsCurrentItems[0], optionsCurrentItems[1], optionsCurrentItems[2]);
        }
        this.dismiss();
    }

    public void setOnoptionsSelectListener(OnOptionsSelectListener optionsSelectListener) {
        this.optionsSelectListener = optionsSelectListener;
    }

    public void setTitle(String title) {
        this.tvTitle.setText((CharSequence)title);
    }

    public static interface OnOptionsSelectListener {
        public void onOptionsSelect(int var1, int var2, int var3);
    }
}

