/*
 * Decompiled with CFR 0.152.
 */
package com.rajatthareja.reportbuilder.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rajatthareja.reportbuilder.report.Example;
import com.rajatthareja.reportbuilder.report.Hook;
import com.rajatthareja.reportbuilder.report.Step;
import com.rajatthareja.reportbuilder.report.Tag;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Scenario {
    private List<Tag> tags;
    private List<Hook> after;
    private String id;
    private String description;
    private List<Hook> before;
    private String keyword;
    private String name;
    private String line;
    private List<Step> steps = new ArrayList<Step>();
    private String type;
    private List<Example> examples;

    public Duration getDuration() {
        Duration duration = Duration.ofSeconds(0L);
        for (Step step : this.steps) {
            duration = duration.plus(step.getDuration());
        }
        if (this.before != null) {
            for (Hook hook : this.before) {
                duration = duration.plus(hook.getDuration());
            }
        }
        if (this.after != null) {
            for (Hook hook : this.after) {
                duration = duration.plus(hook.getDuration());
            }
        }
        return duration;
    }

    public String getStatus() {
        return this.steps.stream().anyMatch(s -> s.getResult().getStatus().equals("failed")) ? "failed" : (this.steps.stream().allMatch(s -> s.getResult().getStatus().equals("passed")) ? "passed" : "skipped");
    }

    public String getError() {
        String error = null;
        for (Step step : this.steps) {
            if (step.getResult().getErrorMessage() == null) continue;
            error = step.getResult().getErrorMessage().split("\n")[0];
            break;
        }
        return error;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<Hook> getAfter() {
        return this.after;
    }

    public void setAfter(List<Hook> after) {
        this.after = after;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Hook> getBefore() {
        return this.before;
    }

    public void setBefore(List<Hook> before) {
        this.before = before;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Example> getExamples() {
        return this.examples;
    }

    public void setExamples(List<Example> examples) {
        this.examples = examples;
    }
}

