/*
 * Decompiled with CFR 0.152.
 */
package com.rajatthareja.reportbuilder;

import com.rajatthareja.reportbuilder.Color;
import com.rajatthareja.reportbuilder.Report;
import freemarker.template.Configuration;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportBuilder {
    private String reportTitle = "Test Report";
    private String reportDirectory = "";
    private String reportFileName = "report";
    private String reportColor = Color.BROWN.toString();
    private Map<String, String> additionalInfo = new HashMap<String, String>();
    private boolean voiceControl = false;

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    public String getReportTitle() {
        return this.reportTitle;
    }

    public void setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo.putAll(additionalInfo);
    }

    public String getAdditionalInfo(String key) {
        return this.additionalInfo.get(key);
    }

    public void setAdditionalInfo(String key, String value) {
        this.additionalInfo.put(key, value);
    }

    public void clearAdditionalInfo() {
        this.additionalInfo.clear();
    }

    public String getReportColor() {
        return this.reportColor;
    }

    public void setReportColor(String reportColor) {
        this.reportColor = reportColor;
    }

    public void setReportColor(Color reportColor) {
        this.reportColor = reportColor.toString();
    }

    public void enableVoiceControl() {
        this.voiceControl = true;
    }

    public void disableVoiceControl() {
        this.voiceControl = false;
    }

    public void build(List<Object> cucumberJsonReports) {
        this.build(cucumberJsonReports.toArray());
    }

    public void build(Object ... cucumberJsonReports) {
        Report report = new Report(cucumberJsonReports);
        Configuration config = new Configuration(Configuration.VERSION_2_3_23);
        config.setClassForTemplateLoading(ReportBuilder.class, "template");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("reportTitle", this.reportTitle);
        data.put("reportColor", this.reportColor);
        data.put("additionalInfo", this.additionalInfo);
        data.put("voiceControl", this.voiceControl);
        data.put("report", report);
        new File(this.reportDirectory).mkdirs();
        try (PrintWriter out = new PrintWriter(this.reportDirectory + this.reportFileName + ".html");){
            config.getTemplate("report.ftl").process(data, (Writer)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to build report!");
        }
    }
}

