/*
 * Decompiled with CFR 0.152.
 */
package com.rajatthareja.reportbuilder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rajatthareja.reportbuilder.report.Example;
import com.rajatthareja.reportbuilder.report.Feature;
import com.rajatthareja.reportbuilder.report.Row;
import com.rajatthareja.reportbuilder.report.Scenario;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class Report {
    private List<Feature> features = new ArrayList<Feature>();
    private List<String> errors = new ArrayList<String>();
    private Duration duration = Duration.ofNanos(0L);

    public Report(Object ... cucumberJsonReports) {
        ArrayList<Object> jsonReports = new ArrayList<Object>();
        jsonReports.addAll(Arrays.asList(cucumberJsonReports));
        List<Object> reportDirs = jsonReports.stream().filter(r -> r instanceof File && ((File)r).isDirectory()).collect(Collectors.toList());
        jsonReports.removeAll(reportDirs);
        reportDirs.forEach(reportDir -> {
            try {
                jsonReports.addAll(Files.walk(Paths.get(((File)reportDir).getPath(), new String[0]), new FileVisitOption[0]).filter(p -> p.toString().endsWith(".json")).map(p -> new File(p.toString())).collect(Collectors.toList()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<Feature[]> builds = new ArrayList<Feature[]>();
        for (Object e : jsonReports) {
            try {
                if (e instanceof File) {
                    try {
                        builds.add((Feature[])mapper.readValue((File)e, Feature[].class));
                    }
                    catch (Exception e2) {
                        builds.add((Feature[])mapper.readValue(this.decode(new String(Files.readAllBytes(((File)e).toPath()))), Feature[].class));
                    }
                    continue;
                }
                if (e instanceof URL) {
                    try {
                        builds.add((Feature[])mapper.readValue((URL)e, Feature[].class));
                    }
                    catch (Exception e3) {
                        builds.add((Feature[])mapper.readValue(this.decode(this.readUrl((URL)e)), Feature[].class));
                    }
                    continue;
                }
                if (e instanceof String) {
                    try {
                        builds.add((Feature[])mapper.readValue((String)e, Feature[].class));
                    }
                    catch (Exception e4) {
                        builds.add((Feature[])mapper.readValue(this.decode((String)e), Feature[].class));
                    }
                    continue;
                }
                if (e instanceof JSONObject) {
                    try {
                        builds.add((Feature[])mapper.readValue(e.toString(), Feature[].class));
                    }
                    catch (Exception e5) {
                        builds.add((Feature[])mapper.readValue(this.decode(e.toString()), Feature[].class));
                    }
                    continue;
                }
                throw new Exception("Invalid jsonReport!");
            }
            catch (Exception e6) {
                System.out.println("Error:: While mapping jsonReport");
                e6.printStackTrace();
            }
        }
        this.process(builds);
    }

    private void process(List<Feature[]> builds) {
        for (Feature[] build : builds) {
            this.features.addAll(Arrays.asList(build));
        }
        HashMap<String, Feature> featuresMap = new HashMap<String, Feature>();
        for (Feature feature : this.features) {
            if (featuresMap.get(feature.getId()) == null) {
                featuresMap.put(feature.getId(), feature);
                continue;
            }
            ((Feature)featuresMap.get(feature.getId())).getScenarios().addAll(feature.getScenarios());
        }
        this.features = new ArrayList(featuresMap.values());
        for (Feature feature : this.features) {
            HashMap<String, Scenario> scenariosMap = new HashMap<String, Scenario>();
            ArrayList<Row> examples = new ArrayList<Row>();
            for (Scenario scenario : feature.getScenarios()) {
                String error;
                if (scenario.getExamples() != null) {
                    for (Example e2 : scenario.getExamples()) {
                        examples.addAll(e2.getRows());
                    }
                    continue;
                }
                if (scenariosMap.get(scenario.getId()) != null && !scenario.getStatus().equals("passed")) continue;
                if (scenario.getKeyword().equals("Scenario Outline")) {
                    examples.stream().filter(e -> e.getId().equals(scenario.getId())).findFirst().ifPresent(row -> scenario.setName(scenario.getName() + " " + row.getCells()));
                }
                if ((error = scenario.getError()) != null && !this.errors.contains(error)) {
                    this.errors.add(error);
                }
                scenariosMap.put(scenario.getId(), scenario);
            }
            feature.setScenarios(new ArrayList<Scenario>(scenariosMap.values()));
            this.duration = this.duration.plus(feature.getDuration());
        }
    }

    private String decode(String json) {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteBuffer data = ByteBuffer.wrap(json.getBytes());
        try {
            return decoder.decode(data).toString();
        }
        catch (CharacterCodingException e) {
            System.out.println("Error:: While decoding JSON report");
            e.printStackTrace();
            return json;
        }
    }

    private String readUrl(URL url) {
        StringBuilder content = new StringBuilder();
        try {
            String line;
            URLConnection urlConnection = url.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line).append("\n");
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            System.out.println("Error:: While reading JSON report from URL");
            e.printStackTrace();
        }
        return content.toString();
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String getDurationString(Duration duration) {
        return duration.withNanos(0).toString().substring(2);
    }
}

