/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera.request;

import com.ragnarok.rxcamera.OnRxCameraPreviewFrameCallback;
import com.ragnarok.rxcamera.RxCamera;
import com.ragnarok.rxcamera.RxCameraData;
import com.ragnarok.rxcamera.error.CameraDataNullException;
import com.ragnarok.rxcamera.request.BaseRxCameraRequest;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;
import rx.schedulers.Schedulers;

public class PeriodicDataRequest
extends BaseRxCameraRequest
implements OnRxCameraPreviewFrameCallback {
    private static final String TAG = "MicroMsg.PeriodicDataRequest";
    private long intervalMills;
    private boolean isInstallCallback = false;
    private Subscriber<? super RxCameraData> subscriber = null;
    private RxCameraData currentData = new RxCameraData();
    private long lastSendDataTimestamp = 0L;

    public PeriodicDataRequest(RxCamera rxCamera, long intervalMills) {
        super(rxCamera);
        this.intervalMills = intervalMills;
    }

    @Override
    public Observable<RxCameraData> get() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCameraData>(){

            public void call(final Subscriber<? super RxCameraData> subscriber) {
                PeriodicDataRequest.this.subscriber = subscriber;
                subscriber.add(Schedulers.newThread().createWorker().schedulePeriodically(new Action0(){

                    public void call() {
                        if (((PeriodicDataRequest)PeriodicDataRequest.this).currentData.cameraData != null && !subscriber.isUnsubscribed() && PeriodicDataRequest.this.rxCamera.isOpenCamera()) {
                            subscriber.onNext((Object)PeriodicDataRequest.this.currentData);
                        }
                    }
                }, 0L, PeriodicDataRequest.this.intervalMills, TimeUnit.MILLISECONDS));
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                PeriodicDataRequest.this.rxCamera.uninstallPreviewCallback(PeriodicDataRequest.this);
                PeriodicDataRequest.this.isInstallCallback = false;
            }
        }).doOnSubscribe(new Action0(){

            public void call() {
                if (!PeriodicDataRequest.this.isInstallCallback) {
                    PeriodicDataRequest.this.rxCamera.installPreviewCallback(PeriodicDataRequest.this);
                    PeriodicDataRequest.this.isInstallCallback = true;
                }
            }
        }).doOnTerminate(new Action0(){

            public void call() {
                PeriodicDataRequest.this.rxCamera.uninstallPreviewCallback(PeriodicDataRequest.this);
                PeriodicDataRequest.this.isInstallCallback = false;
            }
        }).observeOn(AndroidSchedulers.mainThread());
    }

    @Override
    public void onPreviewFrame(byte[] data) {
        if (this.subscriber != null && !this.subscriber.isUnsubscribed() && this.rxCamera.isOpenCamera()) {
            if (data == null || data.length == 0) {
                this.subscriber.onError((Throwable)new CameraDataNullException());
            }
            this.currentData.cameraData = data;
            this.currentData.rotateMatrix = this.rxCamera.getRotateMatrix();
        }
    }
}

