/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera.request;

import android.hardware.Camera;
import com.ragnarok.rxcamera.RxCamera;
import com.ragnarok.rxcamera.RxCameraData;
import com.ragnarok.rxcamera.error.FaceDetectionNotSupportError;
import com.ragnarok.rxcamera.request.BaseRxCameraRequest;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;

public class FaceDetectionRequest
extends BaseRxCameraRequest
implements Camera.FaceDetectionListener {
    private Subscriber<? super RxCameraData> subscriber;

    public FaceDetectionRequest(RxCamera rxCamera) {
        super(rxCamera);
    }

    @Override
    public Observable<RxCameraData> get() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCameraData>(){

            public void call(Subscriber<? super RxCameraData> subscriber) {
                if (FaceDetectionRequest.this.rxCamera.getNativeCamera().getParameters().getMaxNumDetectedFaces() > 0) {
                    FaceDetectionRequest.this.subscriber = subscriber;
                } else {
                    subscriber.onError((Throwable)new FaceDetectionNotSupportError("Camera not support face detection"));
                }
            }
        }).doOnSubscribe(new Action0(){

            public void call() {
                FaceDetectionRequest.this.rxCamera.getNativeCamera().setFaceDetectionListener((Camera.FaceDetectionListener)FaceDetectionRequest.this);
                FaceDetectionRequest.this.rxCamera.getNativeCamera().startFaceDetection();
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                FaceDetectionRequest.this.rxCamera.getNativeCamera().setFaceDetectionListener(null);
                FaceDetectionRequest.this.rxCamera.getNativeCamera().stopFaceDetection();
            }
        });
    }

    public void onFaceDetection(Camera.Face[] faces, Camera camera) {
        if (this.subscriber != null && !this.subscriber.isUnsubscribed() && this.rxCamera.isOpenCamera()) {
            RxCameraData cameraData = new RxCameraData();
            cameraData.faceList = faces;
            this.subscriber.onNext((Object)cameraData);
        }
    }
}

