/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera.config;

import android.graphics.Point;
import android.hardware.Camera;
import com.ragnarok.rxcamera.config.CameraUtil;

public class RxCameraConfig {
    public static Point DEFAULT_PREFER_PREVIEW_SIZE = new Point(320, 240);
    public final boolean isFaceCamera;
    public final int currentCameraId;
    public final Point preferPreviewSize;
    public final boolean acceptSquarePreview;
    public final int minPreferPreviewFrameRate;
    public final int maxPreferPreviewFrameRate;
    public final int previewFormat;
    public final int displayOrientation;
    public final boolean isAutoFocus;
    public final int previewBufferSize;
    public final boolean isHandleSurfaceEvent;
    public final int cameraOrientation;
    public final boolean muteShutterSound;

    public RxCameraConfig(Builder builder) {
        this.isFaceCamera = builder.isFaceCamera;
        this.currentCameraId = builder.currentCameraId;
        this.preferPreviewSize = builder.preferPreviewSize;
        this.acceptSquarePreview = builder.acceptSquarePreview;
        this.minPreferPreviewFrameRate = builder.minPreferPreviewFrameRate;
        this.maxPreferPreviewFrameRate = builder.maxPreferPreviewFrameRate;
        this.previewFormat = builder.previewFormat;
        this.displayOrientation = builder.displayOrientation;
        this.isAutoFocus = builder.isAutoFocus;
        this.previewBufferSize = builder.previewBufferSize;
        this.isHandleSurfaceEvent = builder.isHandleSurfaceEvent;
        this.cameraOrientation = builder.cameraOrientation;
        this.muteShutterSound = builder.muteShutterSound;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("RxCameraConfig ");
        result.append(String.format("isFaceCamera: %b, currentCameraId: %d, ", this.isFaceCamera, this.currentCameraId));
        result.append(String.format("preferPreviewSize: %s, ", this.preferPreviewSize));
        result.append(String.format("minPreferPreviewFrameRate: %d, maxPreferPreviewFrameRate: %d, ", this.minPreferPreviewFrameRate, this.maxPreferPreviewFrameRate));
        result.append(String.format("previewFormat: %d, ", this.previewFormat));
        result.append(String.format("displayOrientation: %d, ", this.displayOrientation));
        result.append(String.format("isAutoFocus: %b", this.isAutoFocus));
        result.append(String.format("previewBufferSize: %d, ", this.previewBufferSize));
        result.append(String.format("isHandleSurfaceEvent: %b, ", this.isHandleSurfaceEvent));
        result.append(String.format("cameraOrientation: %d, ", this.cameraOrientation));
        result.append(String.format("acceptSquarePreview: %s, ", this.acceptSquarePreview));
        result.append(String.format("muteShutterSound: %s", this.muteShutterSound));
        return result.toString();
    }

    public static class Builder {
        private boolean isFaceCamera = false;
        private int currentCameraId = -1;
        private Point preferPreviewSize = null;
        private boolean acceptSquarePreview = true;
        private int minPreferPreviewFrameRate = -1;
        private int maxPreferPreviewFrameRate = -1;
        private int previewFormat = -1;
        private int displayOrientation = -1;
        private boolean isAutoFocus = false;
        private int previewBufferSize = -1;
        private boolean isHandleSurfaceEvent = false;
        private int cameraOrientation = -1;
        private boolean muteShutterSound = false;

        public Builder useFrontCamera() {
            this.isFaceCamera = true;
            this.currentCameraId = CameraUtil.getFrontCameraId();
            return this;
        }

        public Builder useBackCamera() {
            this.isFaceCamera = false;
            this.currentCameraId = CameraUtil.getBackCameraId();
            return this;
        }

        public Builder setPreferPreviewSize(Point size, boolean acceptSquarePreview) {
            if (size == null) {
                return this;
            }
            this.preferPreviewSize = size;
            this.acceptSquarePreview = acceptSquarePreview;
            return this;
        }

        public Builder setPreferPreviewFrameRate(int minFrameRate, int maxFrameRate) {
            if (minFrameRate <= 0 || maxFrameRate <= 0 || maxFrameRate < minFrameRate) {
                return this;
            }
            this.minPreferPreviewFrameRate = minFrameRate;
            this.maxPreferPreviewFrameRate = maxFrameRate;
            return this;
        }

        public Builder setPreviewFormat(int previewFormat) {
            this.previewFormat = previewFormat;
            return this;
        }

        public Builder setDisplayOrientation(int displayOrientation) {
            if (displayOrientation < 0) {
                return this;
            }
            if (displayOrientation != 0 && displayOrientation != 90 && displayOrientation != 180 && displayOrientation != 270) {
                throw new IllegalArgumentException("display orientation: " + displayOrientation + ". (must be 0, 90, 180, or 270)");
            }
            this.displayOrientation = displayOrientation;
            return this;
        }

        public Builder setAutoFocus(boolean isAutoFocus) {
            this.isAutoFocus = isAutoFocus;
            return this;
        }

        public Builder setHandleSurfaceEvent(boolean isHandle) {
            this.isHandleSurfaceEvent = isHandle;
            return this;
        }

        public Builder setPreviewBufferSize(int size) {
            this.previewBufferSize = size;
            return this;
        }

        public Builder setMuteShutterSound(boolean mute) {
            this.muteShutterSound = mute;
            return this;
        }

        private Builder setProperConfigVal() {
            Camera.CameraInfo cameraInfo;
            if (this.currentCameraId == -1) {
                this.currentCameraId = this.isFaceCamera ? CameraUtil.getFrontCameraId() : CameraUtil.getBackCameraId();
            }
            if (this.preferPreviewSize == null) {
                this.preferPreviewSize = DEFAULT_PREFER_PREVIEW_SIZE;
            }
            if ((cameraInfo = CameraUtil.getCameraInfo(this.currentCameraId)) != null) {
                this.cameraOrientation = cameraInfo.orientation;
            }
            return this;
        }

        public Builder from(RxCameraConfig config) {
            if (config.isFaceCamera) {
                this.useFrontCamera();
            } else {
                this.useBackCamera();
            }
            this.setPreferPreviewSize(config.preferPreviewSize, config.acceptSquarePreview);
            this.setPreferPreviewFrameRate(config.maxPreferPreviewFrameRate, config.minPreferPreviewFrameRate);
            this.setPreviewFormat(config.previewFormat);
            this.setDisplayOrientation(config.displayOrientation);
            this.setAutoFocus(config.isAutoFocus);
            this.setHandleSurfaceEvent(config.isHandleSurfaceEvent);
            this.setPreviewBufferSize(config.previewBufferSize);
            this.setMuteShutterSound(config.muteShutterSound);
            return this;
        }

        public RxCameraConfig build() {
            this.setProperConfigVal();
            return new RxCameraConfig(this);
        }
    }
}

