/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera.config;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import android.view.WindowManager;
import java.util.List;

public class CameraUtil {
    private static final String TAG = "RxCamera.CameraUtil";
    private static int frontCameraId = -1;
    private static int backCameraId = -1;
    private static int cameraNumber = -1;

    public static int getCameraNumber() {
        if (cameraNumber == -1) {
            cameraNumber = Camera.getNumberOfCameras();
        }
        return cameraNumber;
    }

    public static int getFrontCameraId() {
        if (frontCameraId == -1) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            for (int i = 0; i < CameraUtil.getCameraNumber(); ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != 1) continue;
                frontCameraId = i;
                break;
            }
        }
        return frontCameraId;
    }

    public static Camera.CameraInfo getCameraInfo(int id) {
        if (id >= 0 && id < CameraUtil.getCameraNumber()) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)id, (Camera.CameraInfo)cameraInfo);
            return cameraInfo;
        }
        return null;
    }

    public static boolean hasFrontCamera() {
        return CameraUtil.getFrontCameraId() != -1;
    }

    public static boolean hasBackCamera() {
        return CameraUtil.getBackCameraId() != -1;
    }

    public static int getBackCameraId() {
        if (backCameraId == -1) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            for (int i = 0; i < CameraUtil.getCameraNumber(); ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != 0) continue;
                backCameraId = i;
                break;
            }
        }
        return backCameraId;
    }

    public static int getPortraitCameraDisplayOrientation(Context context, int cameraId, boolean isFrontCamera) {
        int result;
        if (cameraId < 0 || cameraId > CameraUtil.getCameraNumber()) {
            return -1;
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        int rotation = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (isFrontCamera) {
            result = (cameraInfo.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (cameraInfo.orientation - degrees + 360) % 360;
        }
        return result;
    }

    public static int[] findClosestFpsRange(Camera camera, int minFrameRate, int maxFrameRate) {
        minFrameRate *= 1000;
        maxFrameRate *= 1000;
        Camera.Parameters parameters = camera.getParameters();
        int minIndex = 0;
        int minDiff = Integer.MAX_VALUE;
        List rangeList = parameters.getSupportedPreviewFpsRange();
        Log.d((String)TAG, (String)("support preview fps range list: " + CameraUtil.dumpFpsRangeList(rangeList)));
        for (int i = 0; i < rangeList.size(); ++i) {
            int[] fpsRange = (int[])rangeList.get(i);
            if (fpsRange.length != 2) continue;
            int minFps = fpsRange[0] / 1000;
            int maxFps = fpsRange[1] / 1000;
            int diff = Math.abs(minFps - minFrameRate) + Math.abs(maxFps - maxFrameRate);
            if (diff >= minDiff) continue;
            minDiff = diff;
            minIndex = i;
        }
        int[] result = (int[])rangeList.get(minIndex);
        return result;
    }

    private static String dumpFpsRangeList(List<int[]> rangeList) {
        String result = "";
        for (int[] range : rangeList) {
            if (range.length != 2) continue;
            result = result + "(" + range[0] + "," + range[1] + ") ";
        }
        return result;
    }

    public static Camera.Size findClosestPreviewSize(Camera camera, Point preferSize) {
        int preferX = preferSize.x;
        int preferY = preferSize.y;
        Camera.Parameters parameters = camera.getParameters();
        List allSupportSizes = parameters.getSupportedPreviewSizes();
        Log.d((String)TAG, (String)("all support preview size: " + CameraUtil.dumpPreviewSizeList(allSupportSizes)));
        int minDiff = Integer.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < allSupportSizes.size(); ++i) {
            Camera.Size size = (Camera.Size)allSupportSizes.get(i);
            int x = size.width;
            int y = size.height;
            int diff = Math.abs(x - preferX) + Math.abs(y - preferY);
            if (diff >= minDiff) continue;
            minDiff = diff;
            index = i;
        }
        Camera.Size size = (Camera.Size)allSupportSizes.get(index);
        return size;
    }

    public static Camera.Size findClosestNonSquarePreviewSize(Camera camera, Point preferSize) {
        int preferX = preferSize.x;
        int preferY = preferSize.y;
        Camera.Parameters parameters = camera.getParameters();
        List allSupportSizes = parameters.getSupportedPreviewSizes();
        Log.d((String)TAG, (String)("all support preview size: " + CameraUtil.dumpPreviewSizeList(allSupportSizes)));
        int minDiff = Integer.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < allSupportSizes.size(); ++i) {
            int diff;
            Camera.Size size = (Camera.Size)allSupportSizes.get(i);
            int x = size.width;
            int y = size.height;
            if (x == y || (diff = Math.abs(x - preferX) + Math.abs(y - preferY)) >= minDiff) continue;
            minDiff = diff;
            index = i;
        }
        Camera.Size size = (Camera.Size)allSupportSizes.get(index);
        return size;
    }

    private static String dumpPreviewSizeList(List<Camera.Size> sizes) {
        String result = "";
        for (Camera.Size size : sizes) {
            result = result + "(" + size.width + "," + size.height + ") ";
        }
        return result;
    }

    public static Rect transferCameraAreaFromOuterSize(Point center, Point outerSize, int size) {
        int left = CameraUtil.clampAreaCoord((int)((float)center.x / (float)outerSize.x * 2000.0f - 1000.0f), size);
        int top = CameraUtil.clampAreaCoord((int)((float)center.y / (float)outerSize.y * 2000.0f - 1000.0f), size);
        return new Rect(left, top, left + size, top + size);
    }

    private static int clampAreaCoord(int center, int focusAreaSize) {
        int result = Math.abs(center) + focusAreaSize / 2 > 1000 ? (center > 0 ? 1000 - focusAreaSize / 2 : -1000 + focusAreaSize / 2) : center - focusAreaSize / 2;
        return result;
    }

    public static boolean canDisableShutter(int id) {
        if (Build.VERSION.SDK_INT >= 17) {
            Camera.CameraInfo cameraInfo = CameraUtil.getCameraInfo(id);
            return cameraInfo != null && cameraInfo.canDisableShutterSound;
        }
        Log.d((String)TAG, (String)"SDK does not support disabling shutter sound");
        return false;
    }
}

