/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera.action;

import android.hardware.Camera;
import com.ragnarok.rxcamera.RxCamera;
import com.ragnarok.rxcamera.error.SettingAreaFocusError;
import com.ragnarok.rxcamera.error.SettingFlashException;
import com.ragnarok.rxcamera.error.SettingMeterAreaError;
import com.ragnarok.rxcamera.error.ZoomFailedException;
import java.util.List;
import rx.Observable;
import rx.Subscriber;

public class RxCameraActionBuilder {
    private RxCamera rxCamera;

    public RxCameraActionBuilder(RxCamera rxCamera) {
        this.rxCamera = rxCamera;
    }

    public Observable<RxCamera> zoom(final int level) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(Subscriber<? super RxCamera> subscriber) {
                Camera.Parameters parameters = RxCameraActionBuilder.this.rxCamera.getNativeCamera().getParameters();
                if (!parameters.isZoomSupported()) {
                    subscriber.onError((Throwable)new ZoomFailedException(ZoomFailedException.Reason.ZOOM_NOT_SUPPORT));
                    return;
                }
                int maxZoomLevel = parameters.getMaxZoom();
                if (level < 0 || level > maxZoomLevel) {
                    subscriber.onError((Throwable)new ZoomFailedException(ZoomFailedException.Reason.ZOOM_RANGE_ERROR));
                    return;
                }
                parameters.setZoom(level);
                RxCameraActionBuilder.this.rxCamera.getNativeCamera().setParameters(parameters);
                subscriber.onNext((Object)RxCameraActionBuilder.this.rxCamera);
            }
        });
    }

    public Observable<RxCamera> smoothZoom(final int level) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(Subscriber<? super RxCamera> subscriber) {
                Camera.Parameters parameters = RxCameraActionBuilder.this.rxCamera.getNativeCamera().getParameters();
                if (!parameters.isZoomSupported() || !parameters.isSmoothZoomSupported()) {
                    subscriber.onError((Throwable)new ZoomFailedException(ZoomFailedException.Reason.ZOOM_NOT_SUPPORT));
                    return;
                }
                int maxZoomLevel = parameters.getMaxZoom();
                if (level < 0 || level > maxZoomLevel) {
                    subscriber.onError((Throwable)new ZoomFailedException(ZoomFailedException.Reason.ZOOM_RANGE_ERROR));
                    return;
                }
                RxCameraActionBuilder.this.rxCamera.getNativeCamera().startSmoothZoom(level);
                subscriber.onNext((Object)RxCameraActionBuilder.this.rxCamera);
            }
        });
    }

    public Observable<RxCamera> flashAction(final boolean isOn) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(Subscriber<? super RxCamera> subscriber) {
                Camera.Parameters parameters = RxCameraActionBuilder.this.rxCamera.getNativeCamera().getParameters();
                if (parameters.getSupportedFlashModes() == null || parameters.getSupportedFlashModes().size() <= 0) {
                    subscriber.onError((Throwable)new SettingFlashException(SettingFlashException.Reason.NOT_SUPPORT));
                    return;
                }
                if (isOn) {
                    if (parameters.getSupportedFlashModes().contains("torch")) {
                        parameters.setFlashMode("torch");
                        RxCameraActionBuilder.this.rxCamera.getNativeCamera().setParameters(parameters);
                        subscriber.onNext((Object)RxCameraActionBuilder.this.rxCamera);
                        return;
                    }
                    subscriber.onError((Throwable)new SettingFlashException(SettingFlashException.Reason.NOT_SUPPORT));
                } else if (parameters.getSupportedFlashModes().contains("off")) {
                    parameters.setFlashMode("off");
                    RxCameraActionBuilder.this.rxCamera.getNativeCamera().setParameters(parameters);
                    subscriber.onNext((Object)RxCameraActionBuilder.this.rxCamera);
                } else {
                    subscriber.onError((Throwable)new SettingFlashException(SettingFlashException.Reason.NOT_SUPPORT));
                }
            }
        });
    }

    public Observable<RxCamera> areaFocusAction(final List<Camera.Area> focusAreaList) {
        if (focusAreaList == null || focusAreaList.size() == 0) {
            return null;
        }
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(final Subscriber<? super RxCamera> subscriber) {
                Camera.Parameters parameters = RxCameraActionBuilder.this.rxCamera.getNativeCamera().getParameters();
                if (parameters.getMaxNumFocusAreas() < focusAreaList.size()) {
                    subscriber.onError((Throwable)new SettingAreaFocusError(SettingAreaFocusError.Reason.NOT_SUPPORT));
                } else {
                    List focusModes;
                    if (parameters.getFocusMode() != "auto" && (focusModes = parameters.getSupportedFocusModes()).contains("auto")) {
                        parameters.setFocusMode("auto");
                    }
                    parameters.setFocusAreas(focusAreaList);
                    RxCameraActionBuilder.this.rxCamera.getNativeCamera().setParameters(parameters);
                    RxCameraActionBuilder.this.rxCamera.getNativeCamera().autoFocus(new Camera.AutoFocusCallback(){

                        public void onAutoFocus(boolean success, Camera camera) {
                            if (success) {
                                subscriber.onNext((Object)RxCameraActionBuilder.this.rxCamera);
                            } else {
                                subscriber.onError((Throwable)new SettingAreaFocusError(SettingAreaFocusError.Reason.SET_AREA_FOCUS_FAILED));
                            }
                        }
                    });
                }
            }
        });
    }

    public Observable<RxCamera> areaMeterAction(final List<Camera.Area> meterAreaList) {
        if (meterAreaList == null || meterAreaList.size() == 0) {
            return null;
        }
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(Subscriber<? super RxCamera> subscriber) {
                Camera.Parameters parameters = RxCameraActionBuilder.this.rxCamera.getNativeCamera().getParameters();
                if (parameters.getMaxNumMeteringAreas() < meterAreaList.size()) {
                    subscriber.onError((Throwable)new SettingMeterAreaError(SettingMeterAreaError.Reason.NOT_SUPPORT));
                } else {
                    parameters.setFocusAreas(meterAreaList);
                    RxCameraActionBuilder.this.rxCamera.getNativeCamera().setParameters(parameters);
                    subscriber.onNext((Object)RxCameraActionBuilder.this.rxCamera);
                }
            }
        });
    }
}

