/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Point;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import com.ragnarok.rxcamera.OnRxCameraPreviewFrameCallback;
import com.ragnarok.rxcamera.SurfaceCallback;
import com.ragnarok.rxcamera.config.CameraUtil;
import com.ragnarok.rxcamera.config.RxCameraConfig;
import com.ragnarok.rxcamera.error.BindSurfaceFailedException;
import com.ragnarok.rxcamera.error.OpenCameraException;
import com.ragnarok.rxcamera.error.OpenCameraFailedReason;
import com.ragnarok.rxcamera.error.StartPreviewFailedException;
import java.util.ArrayList;
import java.util.List;

public class RxCameraInternal
implements SurfaceCallback.SurfaceListener,
Camera.PreviewCallback {
    private static final String TAG = "RxCamera.CameraInternal";
    private Camera camera;
    private RxCameraConfig cameraConfig;
    private Context context;
    private boolean isBindSurface = false;
    private boolean isOpenCamera = false;
    private SurfaceView bindSurfaceView;
    private TextureView bindTextureView;
    private SurfaceCallback surfaceCallback = new SurfaceCallback();
    private boolean isSurfaceAvailable = false;
    private boolean isNeedStartPreviewLater = false;
    private List<byte[]> callbackBuffList;
    private static final int CALLBACK_BUFF_COUNT = 3;
    private OpenCameraFailedReason openCameraFailedReason;
    private Throwable openCameraFailedCause;
    private String bindSurfaceFailedMessage;
    private Throwable bindSurfaceFailedCause;
    private String previewFailedMessage;
    private Throwable previewFailedCause;
    private Point finalPreviewSize;
    private boolean isSetPreviewCallback = false;
    private List<OnRxCameraPreviewFrameCallback> previewFrameCallbackList = new ArrayList<OnRxCameraPreviewFrameCallback>();
    private List<OnRxCameraPreviewFrameCallback> oneshotPrevieFrameCallbackList = new ArrayList<OnRxCameraPreviewFrameCallback>();

    public void setConfig(RxCameraConfig config) {
        this.cameraConfig = config;
    }

    public RxCameraConfig getConfig() {
        return this.cameraConfig;
    }

    public Camera getNativeCamera() {
        return this.camera;
    }

    public Point getFinalPreviewSize() {
        return this.finalPreviewSize;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public boolean openCameraInternal() {
        this.reset();
        if (this.cameraConfig == null) {
            this.openCameraFailedReason = OpenCameraFailedReason.PARAMETER_ERROR;
            return false;
        }
        this.surfaceCallback = new SurfaceCallback();
        try {
            this.camera = Camera.open((int)this.cameraConfig.currentCameraId);
        }
        catch (Exception e) {
            this.openCameraFailedReason = OpenCameraFailedReason.OPEN_FAILED;
            this.openCameraFailedCause = e;
            Log.e((String)TAG, (String)("open camera failed: " + e.getMessage()));
            return false;
        }
        Camera.Parameters parameters = null;
        try {
            parameters = this.camera.getParameters();
        }
        catch (Exception e) {
            this.openCameraFailedReason = OpenCameraFailedReason.GET_PARAMETER_FAILED;
            this.openCameraFailedCause = e;
            Log.e((String)TAG, (String)("get parameter failed: " + e.getMessage()));
        }
        if (parameters == null) {
            this.openCameraFailedReason = OpenCameraFailedReason.GET_PARAMETER_FAILED;
            return false;
        }
        if (this.cameraConfig.minPreferPreviewFrameRate != -1 && this.cameraConfig.maxPreferPreviewFrameRate != -1) {
            try {
                int[] range = CameraUtil.findClosestFpsRange(this.camera, this.cameraConfig.minPreferPreviewFrameRate, this.cameraConfig.maxPreferPreviewFrameRate);
                parameters.setPreviewFpsRange(range[0], range[1]);
            }
            catch (Exception e) {
                this.openCameraFailedReason = OpenCameraFailedReason.SET_FPS_FAILED;
                this.openCameraFailedCause = e;
                Log.e((String)TAG, (String)("set preview fps range failed: " + e.getMessage()));
                return false;
            }
        }
        if (this.cameraConfig.preferPreviewSize != null) {
            try {
                Camera.Size previewSize;
                if (this.cameraConfig.acceptSquarePreview) {
                    previewSize = CameraUtil.findClosestPreviewSize(this.camera, this.cameraConfig.preferPreviewSize);
                    parameters.setPreviewSize(previewSize.width, previewSize.height);
                    this.finalPreviewSize = new Point(previewSize.width, previewSize.height);
                } else {
                    previewSize = CameraUtil.findClosestNonSquarePreviewSize(this.camera, this.cameraConfig.preferPreviewSize);
                    parameters.setPreviewSize(previewSize.width, previewSize.height);
                    this.finalPreviewSize = new Point(previewSize.width, previewSize.height);
                }
            }
            catch (Exception e) {
                this.openCameraFailedReason = OpenCameraFailedReason.SET_PREVIEW_SIZE_FAILED;
                this.openCameraFailedCause = e;
                Log.e((String)TAG, (String)("set preview size failed: " + e.getMessage()));
                return false;
            }
        }
        if (this.cameraConfig.previewFormat != -1) {
            try {
                parameters.setPreviewFormat(this.cameraConfig.previewFormat);
                parameters.setPictureFormat(256);
            }
            catch (Exception e) {
                this.openCameraFailedReason = OpenCameraFailedReason.SET_PREVIEW_FORMAT_FAILED;
                this.openCameraFailedCause = e;
                Log.e((String)TAG, (String)("set preview format failed: " + e.getMessage()));
                return false;
            }
        }
        if (this.cameraConfig.isAutoFocus) {
            try {
                List focusModes = parameters.getSupportedFocusModes();
                if (focusModes.contains("auto")) {
                    parameters.setFocusMode("auto");
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("set auto focus failed: " + e.getMessage()));
                this.openCameraFailedReason = OpenCameraFailedReason.SET_AUTO_FOCUS_FAILED;
                this.openCameraFailedCause = e;
                return false;
            }
        }
        try {
            this.camera.setParameters(parameters);
        }
        catch (Exception e) {
            this.openCameraFailedReason = OpenCameraFailedReason.SET_PARAMETER_FAILED;
            this.openCameraFailedCause = e;
            Log.e((String)TAG, (String)("set final parameter failed: " + e.getMessage()));
            return false;
        }
        if (this.cameraConfig.displayOrientation == -1) {
            this.cameraConfig.displayOrientation = CameraUtil.getPortraitCamearaDisplayOrientation(this.context, this.cameraConfig.currentCameraId, this.cameraConfig.isFaceCamera);
        }
        try {
            this.camera.setDisplayOrientation(this.cameraConfig.displayOrientation);
        }
        catch (Exception e) {
            this.openCameraFailedReason = OpenCameraFailedReason.SET_DISPLAY_ORIENTATION_FAILED;
            this.openCameraFailedCause = e;
            Log.e((String)TAG, (String)("open camera failed: " + e.getMessage()));
            return false;
        }
        this.isOpenCamera = true;
        return true;
    }

    public OpenCameraException openCameraException() {
        return new OpenCameraException(this.openCameraFailedReason, this.openCameraFailedCause);
    }

    public boolean isBindSurface() {
        return this.isBindSurface;
    }

    public boolean isOpenCamera() {
        return this.isOpenCamera;
    }

    public boolean installPreviewCallback(OnRxCameraPreviewFrameCallback onRxCameraPreviewFrameCallback) {
        if (this.isOpenCamera) {
            if (this.callbackBuffList == null) {
                this.initCallbackBuffList();
            }
            for (int i = 0; i < this.callbackBuffList.size(); ++i) {
                this.camera.addCallbackBuffer(this.callbackBuffList.get(i));
            }
            this.previewFrameCallbackList.add(onRxCameraPreviewFrameCallback);
            if (!this.isSetPreviewCallback) {
                this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
                this.isSetPreviewCallback = true;
            }
            return true;
        }
        return false;
    }

    public boolean installOneShotPreviewCallback(OnRxCameraPreviewFrameCallback onRxCameraPreviewFrameCallback) {
        if (this.isOpenCamera) {
            this.oneshotPrevieFrameCallbackList.add(onRxCameraPreviewFrameCallback);
            this.camera.setOneShotPreviewCallback((Camera.PreviewCallback)this);
            this.isSetPreviewCallback = false;
            return true;
        }
        return false;
    }

    public boolean uninstallPreviewCallback(OnRxCameraPreviewFrameCallback onRxCameraPreviewFrameCallback) {
        return this.previewFrameCallbackList.remove(onRxCameraPreviewFrameCallback);
    }

    public boolean uninstallOneShotPreviewCallback(OnRxCameraPreviewFrameCallback onRxCameraPreviewFrameCallback) {
        return this.oneshotPrevieFrameCallbackList.remove(onRxCameraPreviewFrameCallback);
    }

    private void initCallbackBuffList() {
        int buffSize = this.cameraConfig.previewBufferSize;
        if (this.cameraConfig.previewBufferSize == -1) {
            buffSize = this.getPreviewBufferSizeFromParameter();
        }
        this.callbackBuffList = new ArrayList<byte[]>();
        for (int i = 0; i < 3; ++i) {
            this.callbackBuffList.add(new byte[buffSize]);
        }
    }

    private int getPreviewBufferSizeFromParameter() {
        Log.d((String)TAG, (String)("getPreviewBufferSizeFromParameter, previewFormat: " + this.camera.getParameters().getPreviewFormat() + ", " + "previewSize: " + this.camera.getParameters().getPreviewSize() + ", bitsPerPixels: " + ImageFormat.getBitsPerPixel((int)this.camera.getParameters().getPreviewFormat())));
        if (this.camera.getParameters().getPreviewFormat() == 842094169) {
            int width = this.camera.getParameters().getPreviewSize().width;
            int height = this.camera.getParameters().getPreviewSize().height;
            int yStride = (int)Math.ceil((double)width / 16.0) * 16;
            int uvStride = (int)Math.ceil((double)(yStride / 2) / 16.0) * 16;
            int ySize = yStride * height;
            int uvSize = uvStride * height / 2;
            int size = ySize + uvSize * 2;
            return size;
        }
        return this.camera.getParameters().getPreviewSize().width * this.camera.getParameters().getPreviewSize().height * ImageFormat.getBitsPerPixel((int)this.camera.getParameters().getPreviewFormat()) / 8;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        for (OnRxCameraPreviewFrameCallback callback : this.previewFrameCallbackList) {
            callback.onPreviewFrame(data);
        }
        for (OnRxCameraPreviewFrameCallback callback : this.oneshotPrevieFrameCallbackList) {
            callback.onPreviewFrame(data);
        }
        this.oneshotPrevieFrameCallbackList.clear();
        camera.addCallbackBuffer(data);
    }

    public boolean bindSurfaceInternal(SurfaceView surfaceView) {
        if (this.camera == null || this.isBindSurface || surfaceView == null) {
            return false;
        }
        try {
            this.bindSurfaceView = surfaceView;
            if (this.cameraConfig.isHandleSurfaceEvent) {
                this.surfaceCallback.setSurfaceListener(this);
                this.bindSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this.surfaceCallback);
            }
            if (this.bindSurfaceView.getHolder() != null) {
                this.bindSurfaceView.getHolder().setType(3);
                this.camera.setPreviewDisplay(surfaceView.getHolder());
            }
            this.isBindSurface = true;
        }
        catch (Exception e) {
            this.bindSurfaceFailedMessage = e.getMessage();
            this.bindSurfaceFailedCause = e;
            Log.e((String)TAG, (String)("bindSurface failed: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public BindSurfaceFailedException bindSurfaceFailedException() {
        return new BindSurfaceFailedException(this.bindSurfaceFailedMessage, this.bindSurfaceFailedCause);
    }

    public boolean bindTextureInternal(TextureView textureView) {
        if (this.camera == null || this.isBindSurface || textureView == null) {
            return false;
        }
        try {
            this.bindTextureView = textureView;
            if (this.cameraConfig.isHandleSurfaceEvent) {
                this.surfaceCallback.setSurfaceListener(this);
                this.bindTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.surfaceCallback);
            }
            if (this.bindTextureView.getSurfaceTexture() != null) {
                this.camera.setPreviewTexture(this.bindTextureView.getSurfaceTexture());
            }
            this.isBindSurface = true;
        }
        catch (Exception e) {
            this.bindSurfaceFailedMessage = e.getMessage();
            this.bindSurfaceFailedCause = e;
            Log.e((String)TAG, (String)("bindSurfaceTexture failed: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean startPreviewInternal() {
        if (this.camera == null || !this.isBindSurface) {
            return false;
        }
        try {
            this.isSurfaceAvailable = false;
            if (this.bindTextureView != null && this.bindTextureView.isAvailable()) {
                this.isSurfaceAvailable = true;
            }
            if (this.bindSurfaceView != null && this.bindSurfaceView.getWindowToken() != null && this.bindSurfaceView.getHolder() != null && !this.bindSurfaceView.getHolder().isCreating()) {
                this.isSurfaceAvailable = true;
            }
            if (!this.isSurfaceAvailable && this.cameraConfig.isHandleSurfaceEvent) {
                this.isNeedStartPreviewLater = true;
                return true;
            }
            this.camera.startPreview();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("start preview failed: " + e.getMessage()));
            this.previewFailedMessage = e.getMessage();
            this.previewFailedCause = e;
            return false;
        }
        return true;
    }

    public StartPreviewFailedException startPreviewFailedException() {
        return new StartPreviewFailedException(this.previewFailedMessage, this.previewFailedCause);
    }

    public boolean closeCameraInternal() {
        if (this.camera == null) {
            return false;
        }
        try {
            this.camera.setPreviewCallback(null);
            this.camera.release();
            this.reset();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("close camera failed: " + e.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    public void onAvailable() {
        if (this.isNeedStartPreviewLater) {
            try {
                if (this.bindSurfaceView != null) {
                    this.bindSurfaceView.getHolder().setType(3);
                    this.camera.setPreviewDisplay(this.bindSurfaceView.getHolder());
                } else if (this.bindTextureView != null) {
                    this.camera.setPreviewTexture(this.bindTextureView.getSurfaceTexture());
                }
                this.camera.startPreview();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"onAvailable, start preview failed");
            }
        }
    }

    @Override
    public void onDestroy() {
        this.isSurfaceAvailable = false;
    }

    private void reset() {
        this.isBindSurface = false;
        this.isOpenCamera = false;
        this.isNeedStartPreviewLater = false;
        this.isSurfaceAvailable = false;
        this.openCameraFailedCause = null;
        this.openCameraFailedReason = null;
        this.previewFailedCause = null;
        this.previewFailedMessage = null;
        this.bindSurfaceFailedCause = null;
        this.bindSurfaceFailedMessage = null;
        this.finalPreviewSize = null;
        this.previewFrameCallbackList.clear();
        this.oneshotPrevieFrameCallbackList.clear();
        if (this.bindSurfaceView != null && this.surfaceCallback != null) {
            this.bindSurfaceView.getHolder().removeCallback((SurfaceHolder.Callback)this.surfaceCallback);
        }
        this.bindSurfaceView = null;
        if (this.bindTextureView != null) {
            this.bindTextureView.setSurfaceTextureListener(null);
        }
        this.bindTextureView = null;
        if (this.surfaceCallback != null) {
            this.surfaceCallback.setSurfaceListener(null);
            this.surfaceCallback = null;
        }
    }
}

