/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera.request;

import android.hardware.Camera;
import com.ragnarok.rxcamera.RxCamera;
import com.ragnarok.rxcamera.RxCameraData;
import com.ragnarok.rxcamera.error.TakePictureFailedException;
import com.ragnarok.rxcamera.request.BaseRxCameraRequest;
import com.ragnarok.rxcamera.request.Func;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;

public class TakePictureRequest
extends BaseRxCameraRequest {
    private Func shutterAction;
    private boolean isContinuePreview;
    private int pictureFormat = -1;
    private int pictureWidth = -1;
    private int pictureHeight = -1;
    private boolean openFlash = false;

    public TakePictureRequest(RxCamera rxCamera, Func shutterAction, boolean isContinuePreview) {
        this(rxCamera, shutterAction, isContinuePreview, false);
    }

    public TakePictureRequest(RxCamera rxCamera, Func shutterAction, boolean isContinuePreview, boolean openFlash) {
        this(rxCamera, shutterAction, isContinuePreview, -1, -1, -1, openFlash);
    }

    public TakePictureRequest(RxCamera rxCamera, Func shutterAction, boolean isContinuePreview, int width, int height, int format, boolean openFlash) {
        super(rxCamera);
        this.shutterAction = shutterAction;
        this.isContinuePreview = isContinuePreview;
        this.pictureWidth = width;
        this.pictureHeight = height;
        this.pictureFormat = format;
        this.openFlash = openFlash;
    }

    @Override
    public Observable<RxCameraData> get() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCameraData>(){

            public void call(final Subscriber<? super RxCameraData> subscriber) {
                Camera.Parameters param;
                try {
                    param = TakePictureRequest.this.rxCamera.getNativeCamera().getParameters();
                    if (TakePictureRequest.this.pictureFormat != -1) {
                        param.setPictureFormat(TakePictureRequest.this.pictureFormat);
                    }
                    TakePictureRequest.this.rxCamera.getNativeCamera().setParameters(param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Camera.Size size;
                    param = TakePictureRequest.this.rxCamera.getNativeCamera().getParameters();
                    if (TakePictureRequest.this.pictureWidth != -1 && TakePictureRequest.this.pictureHeight != -1 && (size = TakePictureRequest.this.findClosetPictureSize(param.getSupportedPictureSizes(), TakePictureRequest.this.pictureWidth, TakePictureRequest.this.pictureHeight)) != null) {
                        param.setPictureSize(size.width, size.height);
                    }
                    if (TakePictureRequest.this.openFlash && param.getSupportedFlashModes() != null && param.getSupportedFlashModes().contains("on")) {
                        param.setFlashMode("on");
                    }
                    TakePictureRequest.this.rxCamera.getNativeCamera().setParameters(param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                TakePictureRequest.this.rxCamera.getNativeCamera().takePicture(new Camera.ShutterCallback(){

                    public void onShutter() {
                        if (TakePictureRequest.this.shutterAction != null) {
                            TakePictureRequest.this.shutterAction.call();
                        }
                    }
                }, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] data, Camera camera) {
                    }
                }, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] data, Camera camera) {
                        if (TakePictureRequest.this.isContinuePreview) {
                            TakePictureRequest.this.rxCamera.startPreview().doOnError((Action1)new Action1<Throwable>(){

                                public void call(Throwable throwable) {
                                    subscriber.onError(throwable);
                                }
                            }).subscribe();
                        }
                        if (data != null) {
                            RxCameraData rxCameraData = new RxCameraData();
                            rxCameraData.cameraData = data;
                            rxCameraData.rotateMatrix = TakePictureRequest.this.rxCamera.getRotateMatrix();
                            subscriber.onNext((Object)rxCameraData);
                            if (TakePictureRequest.this.openFlash) {
                                Camera.Parameters param = TakePictureRequest.this.rxCamera.getNativeCamera().getParameters();
                                if (param.getSupportedFlashModes() != null && param.getSupportedFlashModes().contains("off")) {
                                    param.setFlashMode("off");
                                }
                                TakePictureRequest.this.rxCamera.getNativeCamera().setParameters(param);
                            }
                        } else {
                            subscriber.onError((Throwable)new TakePictureFailedException("cannot get take picture data"));
                        }
                    }
                });
            }
        });
    }

    private Camera.Size findClosetPictureSize(List<Camera.Size> sizeList, int width, int height) {
        if (sizeList == null || sizeList.size() <= 0) {
            return null;
        }
        int minDiff = Integer.MAX_VALUE;
        Camera.Size bestSize = null;
        for (Camera.Size size : sizeList) {
            int diff = Math.abs(size.width - width) + Math.abs(size.height);
            if (diff >= minDiff) continue;
            minDiff = diff;
            bestSize = size;
        }
        return bestSize;
    }
}

