/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera.request;

import android.hardware.Camera;
import com.ragnarok.rxcamera.RxCamera;
import com.ragnarok.rxcamera.RxCameraData;
import com.ragnarok.rxcamera.error.TakePictureFailedException;
import com.ragnarok.rxcamera.request.BaseRxCameraRequest;
import com.ragnarok.rxcamera.request.Func;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;

public class TakePictureRequest
extends BaseRxCameraRequest {
    private Func shutterAction;
    private boolean isContinuePreview;
    private int pictureFormat = -1;
    private int pictureWidth = -1;
    private int pictureHeight = -1;

    public TakePictureRequest(RxCamera rxCamera, Func shutterAction, boolean isContinuePreview) {
        this(rxCamera, shutterAction, isContinuePreview, -1, -1, -1);
    }

    public TakePictureRequest(RxCamera rxCamera, Func shutterAction, boolean isContinuePreview, int width, int height, int format) {
        super(rxCamera);
        this.shutterAction = shutterAction;
        this.isContinuePreview = isContinuePreview;
        this.pictureWidth = width;
        this.pictureHeight = height;
        this.pictureFormat = format;
    }

    @Override
    public Observable<RxCameraData> get() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCameraData>(){

            public void call(final Subscriber<? super RxCameraData> subscriber) {
                Camera.Parameters param;
                try {
                    param = TakePictureRequest.this.rxCamera.getNativeCamera().getParameters();
                    if (TakePictureRequest.this.pictureFormat != -1) {
                        param.setPictureFormat(TakePictureRequest.this.pictureFormat);
                    }
                    TakePictureRequest.this.rxCamera.getNativeCamera().setParameters(param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    param = TakePictureRequest.this.rxCamera.getNativeCamera().getParameters();
                    if (TakePictureRequest.this.pictureWidth != -1 && TakePictureRequest.this.pictureHeight != -1) {
                        param.setPictureSize(TakePictureRequest.this.pictureWidth, TakePictureRequest.this.pictureHeight);
                    }
                    TakePictureRequest.this.rxCamera.getNativeCamera().setParameters(param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TakePictureRequest.this.rxCamera.getNativeCamera().takePicture(new Camera.ShutterCallback(){

                    public void onShutter() {
                        if (TakePictureRequest.this.shutterAction != null) {
                            TakePictureRequest.this.shutterAction.call();
                        }
                    }
                }, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] data, Camera camera) {
                    }
                }, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] data, Camera camera) {
                        if (TakePictureRequest.this.isContinuePreview) {
                            TakePictureRequest.this.rxCamera.startPreview().doOnError((Action1)new Action1<Throwable>(){

                                public void call(Throwable throwable) {
                                    subscriber.onError(throwable);
                                }
                            }).subscribe();
                        }
                        if (data != null) {
                            RxCameraData rxCameraData = new RxCameraData();
                            rxCameraData.cameraData = data;
                            rxCameraData.rotateMatrix = TakePictureRequest.this.rxCamera.getRotateMatrix();
                            subscriber.onNext((Object)rxCameraData);
                        } else {
                            subscriber.onError((Throwable)new TakePictureFailedException("cannot get take picture data"));
                        }
                    }
                });
            }
        });
    }
}

