/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera.config;

import android.graphics.Point;
import android.hardware.Camera;
import com.ragnarok.rxcamera.config.CameraUtil;
import com.ragnarok.rxcamera.config.RxCameraConfig;

public class RxCameraConfigChooser {
    private RxCameraConfig configResult = new RxCameraConfig();

    private RxCameraConfigChooser() {
    }

    public static RxCameraConfigChooser obtain() {
        return new RxCameraConfigChooser();
    }

    public RxCameraConfigChooser useFrontCamera() {
        this.configResult.isFaceCamera = true;
        this.configResult.currentCameraId = CameraUtil.getFrontCameraId();
        return this;
    }

    public RxCameraConfigChooser useBackCamera() {
        this.configResult.isFaceCamera = false;
        this.configResult.currentCameraId = CameraUtil.getBackCameraId();
        return this;
    }

    public RxCameraConfigChooser setPreferPreviewSize(Point size) {
        if (size == null) {
            return this;
        }
        this.configResult.preferPreviewSize = size;
        return this;
    }

    public RxCameraConfigChooser setPreferPreviewFrameRate(int minFrameRate, int maxFrameRate) {
        if (minFrameRate <= 0 || maxFrameRate <= 0 || maxFrameRate < minFrameRate) {
            return this;
        }
        this.configResult.minPreferPreviewFrameRate = minFrameRate;
        this.configResult.maxPreferPreviewFrameRate = maxFrameRate;
        return this;
    }

    public RxCameraConfigChooser setPreviewFormat(int previewFormat) {
        this.configResult.previewFormat = previewFormat;
        return this;
    }

    public RxCameraConfigChooser setDisplayOrientation(int displayOrientation) {
        this.configResult.displayOrientation = displayOrientation;
        return this;
    }

    public RxCameraConfigChooser setAutoFocus(boolean isAutoFocus) {
        this.configResult.isAutoFocus = isAutoFocus;
        return this;
    }

    public RxCameraConfigChooser setHandleSurfaceEvent(boolean isHandle) {
        this.configResult.isHandleSurfaceEvent = isHandle;
        return this;
    }

    public RxCameraConfigChooser setPreviewBufferSize(int size) {
        this.configResult.previewBufferSize = size;
        return this;
    }

    private RxCameraConfigChooser setProperConfigVal() {
        Camera.CameraInfo cameraInfo;
        if (this.configResult.currentCameraId == -1) {
            this.configResult.currentCameraId = this.configResult.isFaceCamera ? CameraUtil.getFrontCameraId() : CameraUtil.getBackCameraId();
        }
        if (this.configResult.preferPreviewSize == null) {
            this.configResult.preferPreviewSize = RxCameraConfig.DEFAULT_PREFER_PREVIEW_SIZE;
        }
        if ((cameraInfo = CameraUtil.getCameraInfo(this.configResult.currentCameraId)) != null) {
            this.configResult.cameraOrien = cameraInfo.orientation;
        }
        return this;
    }

    public RxCameraConfig get() {
        this.setProperConfigVal();
        return this.configResult;
    }
}

