/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera.action;

import android.hardware.Camera;
import com.ragnarok.rxcamera.RxCamera;
import com.ragnarok.rxcamera.error.ZoomFailedException;
import rx.Observable;
import rx.Subscriber;

public class RxCameraActionBuilder {
    private RxCamera rxCamera;

    public RxCameraActionBuilder(RxCamera rxCamera) {
        this.rxCamera = rxCamera;
    }

    public Observable<RxCamera> zoom(final int level) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(Subscriber<? super RxCamera> subscriber) {
                Camera.Parameters parameters = RxCameraActionBuilder.this.rxCamera.getNativeCamera().getParameters();
                if (!parameters.isZoomSupported()) {
                    subscriber.onError((Throwable)new ZoomFailedException(ZoomFailedException.Reason.ZOOM_NOT_SUPPORT));
                    return;
                }
                int maxZoomLevel = parameters.getMaxZoom();
                if (level < 0 || level > maxZoomLevel) {
                    subscriber.onError((Throwable)new ZoomFailedException(ZoomFailedException.Reason.ZOOM_RANGE_ERROR));
                    return;
                }
                parameters.setZoom(level);
                RxCameraActionBuilder.this.rxCamera.getNativeCamera().setParameters(parameters);
                subscriber.onNext((Object)RxCameraActionBuilder.this.rxCamera);
            }
        });
    }

    public Observable<RxCamera> smoothZoom(final int level) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(Subscriber<? super RxCamera> subscriber) {
                Camera.Parameters parameters = RxCameraActionBuilder.this.rxCamera.getNativeCamera().getParameters();
                if (!parameters.isZoomSupported() || !parameters.isSmoothZoomSupported()) {
                    subscriber.onError((Throwable)new ZoomFailedException(ZoomFailedException.Reason.ZOOM_NOT_SUPPORT));
                    return;
                }
                int maxZoomLevel = parameters.getMaxZoom();
                if (level < 0 || level > maxZoomLevel) {
                    subscriber.onError((Throwable)new ZoomFailedException(ZoomFailedException.Reason.ZOOM_RANGE_ERROR));
                    return;
                }
                RxCameraActionBuilder.this.rxCamera.getNativeCamera().startSmoothZoom(level);
                subscriber.onNext((Object)RxCameraActionBuilder.this.rxCamera);
            }
        });
    }
}

