/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera.request;

import com.ragnarok.rxcamera.OnRxCameraPreviewFrameCallback;
import com.ragnarok.rxcamera.RxCamera;
import com.ragnarok.rxcamera.RxCameraData;
import com.ragnarok.rxcamera.error.CameraDataNullException;
import com.ragnarok.rxcamera.request.BaseRxCameraRequest;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;

public class SuccessiveDataRequest
extends BaseRxCameraRequest
implements OnRxCameraPreviewFrameCallback {
    private boolean isInstallSuccessivePreviewCallback = false;
    private Subscriber<? super RxCameraData> successiveDataSubscriber = null;

    public SuccessiveDataRequest(RxCamera rxCamera) {
        super(rxCamera);
    }

    @Override
    public Observable<RxCameraData> get() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCameraData>(){

            public void call(Subscriber<? super RxCameraData> subscriber) {
                SuccessiveDataRequest.this.successiveDataSubscriber = subscriber;
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                SuccessiveDataRequest.this.rxCamera.uninstallPreviewCallback(SuccessiveDataRequest.this);
                SuccessiveDataRequest.this.isInstallSuccessivePreviewCallback = false;
            }
        }).doOnSubscribe(new Action0(){

            public void call() {
                if (!SuccessiveDataRequest.this.isInstallSuccessivePreviewCallback) {
                    SuccessiveDataRequest.this.rxCamera.installPreviewCallback(SuccessiveDataRequest.this);
                    SuccessiveDataRequest.this.isInstallSuccessivePreviewCallback = true;
                }
            }
        }).doOnTerminate(new Action0(){

            public void call() {
                SuccessiveDataRequest.this.rxCamera.uninstallPreviewCallback(SuccessiveDataRequest.this);
                SuccessiveDataRequest.this.isInstallSuccessivePreviewCallback = false;
            }
        });
    }

    @Override
    public void onPreviewFrame(byte[] data) {
        if (this.successiveDataSubscriber != null && !this.successiveDataSubscriber.isUnsubscribed() && this.rxCamera.isOpenCamera()) {
            if (data == null || data.length == 0) {
                this.successiveDataSubscriber.onError((Throwable)new CameraDataNullException());
            }
            RxCameraData cameraData = new RxCameraData();
            cameraData.cameraData = data;
            cameraData.rotateMatrix = this.rxCamera.getRotateMatrix();
            this.successiveDataSubscriber.onNext((Object)cameraData);
        }
    }
}

