/*
 * Decompiled with CFR 0.152.
 */
package com.ragnarok.rxcamera;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Point;
import android.hardware.Camera;
import android.view.SurfaceView;
import android.view.TextureView;
import com.ragnarok.rxcamera.OnRxCameraPreviewFrameCallback;
import com.ragnarok.rxcamera.RxCameraInternal;
import com.ragnarok.rxcamera.config.RxCameraConfig;
import com.ragnarok.rxcamera.request.RxCameraRequestBuilder;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public class RxCamera {
    private static final String TAG = "RxCamera";
    private RxCameraInternal cameraInternal = new RxCameraInternal();
    private Matrix rotateMatrix = null;

    public static Observable<RxCamera> open(final Context context, final RxCameraConfig config) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(Subscriber<? super RxCamera> subscriber) {
                RxCamera rxCamera = new RxCamera(context, config);
                if (rxCamera.cameraInternal.openCameraInternal()) {
                    subscriber.onNext((Object)rxCamera);
                    subscriber.onCompleted();
                } else {
                    subscriber.onError((Throwable)rxCamera.cameraInternal.openCameraException());
                }
            }
        });
    }

    public static Observable<RxCamera> openAndStartPreview(Context context, RxCameraConfig config, final SurfaceView surfaceView) {
        return RxCamera.open(context, config).flatMap((Func1)new Func1<RxCamera, Observable<RxCamera>>(){

            public Observable<RxCamera> call(RxCamera rxCamera) {
                return rxCamera.bindSurface(surfaceView);
            }
        }).flatMap((Func1)new Func1<RxCamera, Observable<RxCamera>>(){

            public Observable<RxCamera> call(RxCamera rxCamera) {
                return rxCamera.startPreview();
            }
        });
    }

    public static Observable<RxCamera> openAndStartPreview(Context context, RxCameraConfig config, final TextureView textureView) {
        return RxCamera.open(context, config).flatMap((Func1)new Func1<RxCamera, Observable<RxCamera>>(){

            public Observable<RxCamera> call(RxCamera rxCamera) {
                return rxCamera.bindTexture(textureView);
            }
        }).flatMap((Func1)new Func1<RxCamera, Observable<RxCamera>>(){

            public Observable<RxCamera> call(RxCamera rxCamera) {
                return rxCamera.startPreview();
            }
        });
    }

    private RxCamera(Context context, RxCameraConfig config) {
        this.cameraInternal.setConfig(config);
        this.cameraInternal.setContext(context);
        this.rotateMatrix = new Matrix();
        this.rotateMatrix.postRotate((float)config.cameraOrien, 0.5f, 0.5f);
    }

    public Matrix getRotateMatrix() {
        return this.rotateMatrix;
    }

    public Observable<RxCamera> bindSurface(final SurfaceView surfaceView) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(Subscriber<? super RxCamera> subscriber) {
                boolean result = RxCamera.this.cameraInternal.bindSurfaceInternal(surfaceView);
                if (result) {
                    subscriber.onNext((Object)RxCamera.this);
                    subscriber.onCompleted();
                } else {
                    subscriber.onError((Throwable)RxCamera.this.cameraInternal.bindSurfaceFailedException());
                }
            }
        });
    }

    public Observable<RxCamera> bindTexture(final TextureView textureView) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(Subscriber<? super RxCamera> subscriber) {
                boolean result = RxCamera.this.cameraInternal.bindTextureInternal(textureView);
                if (result) {
                    subscriber.onNext((Object)RxCamera.this);
                    subscriber.onCompleted();
                } else {
                    subscriber.onError((Throwable)RxCamera.this.cameraInternal.bindSurfaceFailedException());
                }
            }
        });
    }

    public Observable<RxCamera> startPreview() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RxCamera>(){

            public void call(Subscriber<? super RxCamera> subscriber) {
                boolean result = RxCamera.this.cameraInternal.startPreviewInternal();
                if (result) {
                    subscriber.onNext((Object)RxCamera.this);
                    subscriber.onCompleted();
                } else {
                    subscriber.onError((Throwable)RxCamera.this.cameraInternal.startPreviewFailedException());
                }
            }
        });
    }

    public Observable<Boolean> closeCameraWithResult() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Boolean>(){

            public void call(Subscriber<? super Boolean> subscriber) {
                subscriber.onNext((Object)RxCamera.this.cameraInternal.closeCameraInternal());
                subscriber.onCompleted();
            }
        });
    }

    public RxCameraRequestBuilder request() {
        return new RxCameraRequestBuilder(this);
    }

    public boolean closeCamera() {
        return this.cameraInternal.closeCameraInternal();
    }

    public boolean isOpenCamera() {
        return this.cameraInternal.isOpenCamera();
    }

    public boolean isBindSurface() {
        return this.cameraInternal.isBindSurface();
    }

    public RxCameraConfig getConfig() {
        return this.cameraInternal.getConfig();
    }

    public Camera getNativeCamera() {
        return this.cameraInternal.getNativeCamera();
    }

    public Point getFinalPreviewSize() {
        return this.cameraInternal.getFinalPreviewSize();
    }

    public void installPreviewCallback(OnRxCameraPreviewFrameCallback previewCallback) {
        this.cameraInternal.installPreviewCallback(previewCallback);
    }

    public void uninstallPreviewCallback(OnRxCameraPreviewFrameCallback previewCallback) {
        this.cameraInternal.uninstallPreviewCallback(previewCallback);
    }

    public void installOneShotPreviewCallback(OnRxCameraPreviewFrameCallback previewFrameCallback) {
        this.cameraInternal.installOneShotPreviewCallback(previewFrameCallback);
    }

    public void uninstallOneShotPreviewCallback(OnRxCameraPreviewFrameCallback previewFrameCallback) {
        this.cameraInternal.uninstallOneShotPreviewCallback(previewFrameCallback);
    }
}

