/*
 * Decompiled with CFR 0.152.
 */
package com.race604.flyrefresh;

public class HeaderController {
    private int mHeight;
    private int mMaxHegiht;
    private int mMinHegiht;
    private float mOverDistance;
    private float mResistance = 0.5f;
    private boolean mIsInTouch = false;
    private float mScroll = 0.0f;
    private int mMaxScroll = 0;
    private int mMinScroll = 0;

    public HeaderController(int height, int maxHeight, int minHeight) {
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("maxHeight must > 0");
        }
        this.setSize(height, maxHeight, minHeight);
    }

    public void setSize(int height, int maxHeight, int minHeight) {
        this.mHeight = Math.max(0, height);
        this.mMaxHegiht = Math.max(0, maxHeight);
        this.mMinHegiht = Math.max(0, minHeight);
        this.mOverDistance = this.mMaxHegiht - this.mHeight;
        this.mScroll = 0.0f;
        this.mMaxScroll = this.mHeight - this.mMinHegiht;
        this.mMinScroll = this.mHeight - this.mMaxHegiht;
    }

    public int getMaxHeight() {
        return this.mMaxHegiht;
    }

    public int getMinHeight() {
        return this.mMinHegiht;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getScroll() {
        return (int)this.mScroll;
    }

    public int getMaxScroll() {
        return this.mMaxScroll;
    }

    public int getMinScroll() {
        return this.mMinScroll;
    }

    public int getCurPosition() {
        return (int)((float)this.mHeight - this.mScroll);
    }

    public boolean isInTouch() {
        return this.mIsInTouch;
    }

    public boolean canScrollDown() {
        return this.mScroll > (float)this.mMinScroll;
    }

    public boolean canScrollUp() {
        return this.mScroll < (float)this.mMaxScroll;
    }

    public int move(float deltaY) {
        float willTo;
        float consumed = deltaY;
        if (this.mScroll >= 0.0f) {
            willTo = this.mScroll + deltaY;
            if (willTo < 0.0f) {
                if ((willTo *= this.mResistance) < (float)this.mMinScroll) {
                    consumed -= (willTo - (float)this.mMinScroll) / this.mResistance;
                    willTo = this.mMinScroll;
                }
            } else if (willTo > (float)this.mMaxHegiht) {
                consumed -= willTo - (float)this.mMaxScroll;
                willTo = this.mMaxScroll;
            }
        } else {
            willTo = this.mScroll + deltaY * this.mResistance;
            if (willTo > 0.0f) {
                if ((willTo /= this.mResistance) > (float)this.mMaxScroll) {
                    consumed -= willTo - (float)this.mMaxScroll;
                    willTo = this.mMaxScroll;
                }
            } else if (willTo < (float)this.mMinScroll) {
                consumed -= willTo - (float)this.mMinScroll;
                willTo = this.mMinScroll;
            }
        }
        this.mScroll = willTo;
        return (int)consumed;
    }

    public boolean isOverHeight() {
        return this.mScroll < 0.0f;
    }

    public float getMovePercentage() {
        return -this.mScroll / this.mOverDistance;
    }

    public boolean needSendRefresh() {
        return this.getMovePercentage() > 0.9f;
    }
}

