/*
 * Decompiled with CFR 0.152.
 */
package com.race604.flyrefresh;

public class HeaderController {
    private int mHeight;
    private int mMaxHegiht;
    private int mMinHegiht;
    private float mOverDistance;
    private float mResistance = 0.5f;
    private float mStartX;
    private float mStartY;
    private int mOffsetX;
    private int mOffsetY;
    private boolean mIsInTouch = false;
    private int mStartPos = -1;
    private int mCurrentPos = -1;

    public HeaderController(int height, int maxHeight, int minHeight) {
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("maxHeight must > 0");
        }
        this.setSize(height, maxHeight, minHeight);
    }

    public void setSize(int height, int maxHeight, int minHeight) {
        this.mHeight = Math.max(0, height);
        this.mMaxHegiht = Math.max(0, maxHeight);
        this.mMinHegiht = Math.max(0, minHeight);
        this.mOverDistance = this.mMaxHegiht - this.mHeight;
        this.mCurrentPos = this.mStartPos = this.mHeight;
    }

    public int getMaxHeight() {
        return this.mMaxHegiht;
    }

    public int getMinHeight() {
        return this.mMinHegiht;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getCurrentPos() {
        return this.mCurrentPos;
    }

    public int getOffsetX() {
        return this.mOffsetX;
    }

    public int getOffsetY() {
        return this.mOffsetY;
    }

    public boolean isInTouch() {
        return this.mIsInTouch;
    }

    public boolean hasMoved() {
        return this.mStartPos != this.mCurrentPos;
    }

    public boolean canMoveUp() {
        return this.mCurrentPos > this.mMinHegiht;
    }

    public boolean canMoveDown() {
        return this.mCurrentPos < this.mMaxHegiht;
    }

    public void onTouchRelease() {
        this.mIsInTouch = false;
    }

    public void onTouchDown(float x, float y) {
        this.mIsInTouch = true;
        this.mStartX = x;
        this.mStartY = y;
        this.mOffsetY = 0;
        this.mOffsetX = 0;
        this.startMove();
    }

    public void onTouchMove(float x, float y) {
        this.mOffsetX = (int)(x - this.mStartX);
        this.mOffsetY = (int)(y - this.mStartY);
    }

    public void startMove() {
        this.mStartPos = this.mCurrentPos;
    }

    public int willMove(float deltaY) {
        float willTo;
        if (this.mStartPos > this.mHeight) {
            willTo = (float)this.mStartPos + deltaY * this.mResistance;
            if (willTo < (float)this.mHeight) {
                willTo = (float)this.mHeight + (willTo - (float)this.mHeight) / this.mResistance;
            }
        } else {
            willTo = (float)this.mStartPos + deltaY;
            if (willTo > (float)this.mHeight) {
                willTo = (float)this.mHeight + (willTo - (float)this.mHeight) * this.mResistance;
            }
        }
        int offsetY = Math.max(this.mMinHegiht, Math.min(this.mMaxHegiht, (int)willTo));
        int move = offsetY - this.mCurrentPos;
        this.mCurrentPos = offsetY;
        return move;
    }

    public int moveTo(float pos) {
        int offsetY = Math.max(this.mMinHegiht, Math.min(this.mMaxHegiht, (int)pos));
        int delta = offsetY - this.mCurrentPos;
        this.mCurrentPos = offsetY;
        return delta;
    }

    public boolean isOverHeight() {
        return this.mCurrentPos > this.mHeight;
    }

    public float getMovePercentage() {
        if (this.mCurrentPos >= this.mHeight) {
            return (float)(this.mCurrentPos - this.mHeight) / this.mOverDistance;
        }
        return (float)(this.mCurrentPos - this.mHeight) / this.mOverDistance;
    }

    public boolean needSendRefresh() {
        return this.getMovePercentage() > 0.9f;
    }
}

