/*
 * Decompiled with CFR 0.152.
 */
package com.race604.flyrefresh;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.race604.flyrefresh.PullHeaderLayout;
import com.race604.flyrefresh.R;
import com.race604.flyrefresh.internal.MountanScenceView;
import com.race604.flyrefresh.internal.SimpleAnimatorListener;
import com.race604.utils.UIUtils;

public class FlyRefreshLayout
extends PullHeaderLayout {
    private AnimatorSet mFlyAnimator = null;
    private OnPullRefreshListener mListener;

    public FlyRefreshLayout(Context context) {
        super(context);
        this.init(context);
    }

    public FlyRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public FlyRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public FlyRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        MountanScenceView headerView = new MountanScenceView(this.getContext());
        PullHeaderLayout.LayoutParams lp = new PullHeaderLayout.LayoutParams(-1, this.mHeaderController.getMaxHeight());
        this.setHeaderView(headerView, lp);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getIconView() == null) {
            this.setActionDrawable(this.getResources().getDrawable(R.mipmap.ic_send));
        }
    }

    @Override
    protected void onStartRefreshAnimation() {
        if (this.mFlyAnimator != null) {
            this.mFlyAnimator.end();
        }
        View iconView = this.getIconView();
        UIUtils.clearAnimator(iconView);
        AnimatorSet flyUpAnim = new AnimatorSet();
        flyUpAnim.setDuration(800L);
        ObjectAnimator transX = ObjectAnimator.ofFloat((Object)iconView, (String)"translationX", (float[])new float[]{0.0f, this.getWidth()});
        ObjectAnimator transY = ObjectAnimator.ofFloat((Object)iconView, (String)"translationY", (float[])new float[]{0.0f, -this.mHeaderController.getHeight()});
        transY.setInterpolator((TimeInterpolator)PathInterpolatorCompat.create((float)0.7f, (float)1.0f));
        ObjectAnimator rotation = ObjectAnimator.ofFloat((Object)iconView, (String)"rotation", (float[])new float[]{-45.0f, 0.0f});
        rotation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        ObjectAnimator rotationX = ObjectAnimator.ofFloat((Object)iconView, (String)"rotationX", (float[])new float[]{0.0f, 60.0f});
        rotationX.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        flyUpAnim.playTogether(new Animator[]{transX, transY, rotationX, ObjectAnimator.ofFloat((Object)iconView, (String)"scaleX", (float[])new float[]{1.0f, 0.5f}), ObjectAnimator.ofFloat((Object)iconView, (String)"scaleY", (float[])new float[]{1.0f, 0.5f}), rotation});
        this.mFlyAnimator = flyUpAnim;
        this.mFlyAnimator.start();
        if (this.mListener != null) {
            this.mListener.onRefresh(this);
        }
    }

    public void setOnPullRefreshListener(OnPullRefreshListener listener) {
        this.mListener = listener;
    }

    public void onRefreshFinish() {
        if (this.mFlyAnimator != null) {
            this.mFlyAnimator.cancel();
        }
        final View iconView = this.getIconView();
        UIUtils.clearAnimator(iconView);
        int offDistX = -iconView.getRight();
        int offDistY = -UIUtils.dpToPx(10);
        AnimatorSet flyDownAnim = new AnimatorSet();
        flyDownAnim.setDuration(800L);
        ObjectAnimator transX1 = ObjectAnimator.ofFloat((Object)iconView, (String)"translationX", (float[])new float[]{this.getWidth(), offDistX});
        ObjectAnimator transY1 = ObjectAnimator.ofFloat((Object)iconView, (String)"translationY", (float[])new float[]{-this.mHeaderController.getHeight(), offDistY});
        transY1.setInterpolator((TimeInterpolator)PathInterpolatorCompat.create((float)0.1f, (float)1.0f));
        ObjectAnimator rotation1 = ObjectAnimator.ofFloat((Object)iconView, (String)"rotation", (float[])new float[]{iconView.getRotation(), 0.0f});
        rotation1.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        flyDownAnim.playTogether(new Animator[]{transX1, transY1, ObjectAnimator.ofFloat((Object)iconView, (String)"scaleX", (float[])new float[]{0.5f, 0.9f}), ObjectAnimator.ofFloat((Object)iconView, (String)"scaleY", (float[])new float[]{0.5f, 0.9f}), rotation1});
        flyDownAnim.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                iconView.setRotationY(180.0f);
            }
        });
        AnimatorSet flyInAnim = new AnimatorSet();
        flyInAnim.setDuration(400L);
        flyInAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        ObjectAnimator tranX2 = ObjectAnimator.ofFloat((Object)iconView, (String)"translationX", (float[])new float[]{offDistX, 0.0f});
        ObjectAnimator tranY2 = ObjectAnimator.ofFloat((Object)iconView, (String)"translationY", (float[])new float[]{offDistY, 0.0f});
        ObjectAnimator rotationX2 = ObjectAnimator.ofFloat((Object)iconView, (String)"rotationX", (float[])new float[]{30.0f, 0.0f});
        flyInAnim.playTogether(new Animator[]{tranX2, tranY2, rotationX2, ObjectAnimator.ofFloat((Object)iconView, (String)"scaleX", (float[])new float[]{0.9f, 1.0f}), ObjectAnimator.ofFloat((Object)iconView, (String)"scaleY", (float[])new float[]{0.9f, 1.0f})});
        flyInAnim.setStartDelay(100L);
        flyInAnim.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                iconView.setRotationY(0.0f);
            }
        });
        this.mFlyAnimator = new AnimatorSet();
        this.mFlyAnimator.playSequentially(new Animator[]{flyDownAnim, flyInAnim});
        this.mFlyAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                if (FlyRefreshLayout.this.mListener != null) {
                    FlyRefreshLayout.this.mListener.onRefreshAnimationEnd(FlyRefreshLayout.this);
                }
            }
        });
        this.mFlyAnimator.start();
    }

    @Override
    protected void onMoveHeader(int state, float progress) {
        super.onMoveHeader(state, progress);
        if (this.mHeaderController.isOverHeight()) {
            this.getIconView().setRotation(-45.0f * progress);
        }
    }

    public static interface OnPullRefreshListener {
        public void onRefresh(FlyRefreshLayout var1);

        public void onRefreshAnimationEnd(FlyRefreshLayout var1);
    }
}

