/*
 * Decompiled with CFR 0.152.
 */
package com.race604.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.support.v4.view.ViewCompat;
import android.util.TypedValue;
import android.view.View;

public class UIUtils {
    public static final int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static int lighterColor(int color2, float factor) {
        int red = (int)(((float)Color.red((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int green = (int)(((float)Color.green((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int blue = (int)(((float)Color.blue((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        return Color.argb((int)Color.alpha((int)color2), (int)red, (int)green, (int)blue);
    }

    public static int darkerColor(int color2, float factor) {
        int a = Color.alpha((int)color2);
        int r = Color.red((int)color2);
        int g = Color.green((int)color2);
        int b = Color.blue((int)color2);
        return Color.argb((int)a, (int)Math.max((int)((float)r * factor), 0), (int)Math.max((int)((float)g * factor), 0), (int)Math.max((int)((float)b * factor), 0));
    }

    public static int getThemeColor(Context ctx, int attr2) {
        TypedValue tv = new TypedValue();
        if (ctx.getTheme().resolveAttribute(attr2, tv, true)) {
            return tv.data;
        }
        return 0;
    }

    public static int getThemeColorFromAttrOrRes(Context ctx, int attr2, int res) {
        int color2 = UIUtils.getThemeColor(ctx, attr2);
        if (color2 == 0) {
            color2 = ctx.getResources().getColor(res);
        }
        return color2;
    }

    public static void clearAnimator(View v) {
        ViewCompat.setAlpha((View)v, (float)1.0f);
        ViewCompat.setScaleY((View)v, (float)1.0f);
        ViewCompat.setScaleX((View)v, (float)1.0f);
        ViewCompat.setTranslationY((View)v, (float)0.0f);
        ViewCompat.setTranslationX((View)v, (float)0.0f);
        ViewCompat.setRotation((View)v, (float)0.0f);
        ViewCompat.setRotationY((View)v, (float)0.0f);
        ViewCompat.setRotationX((View)v, (float)0.0f);
        v.setPivotY((float)(v.getMeasuredHeight() / 2));
        ViewCompat.setPivotX((View)v, (float)(v.getMeasuredWidth() / 2));
        ViewCompat.animate((View)v).setInterpolator(null);
    }
}

