/*
 * Decompiled with CFR 0.152.
 */
package com.race604.flyrefresh.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.util.FloatMath;
import android.view.animation.Interpolator;

public class TreeDrawable
extends Drawable {
    private static final int DEFAULT_WIDTH = 100;
    private static final int DEFAULT_HEIGHT = 200;
    private float mSizeFactor = 1.0f;
    private float mBendScale = 0.0f;
    private Paint mTrunkPaint = new Paint();
    private Paint mBranchPaint = new Paint();
    private Path mTrunk = new Path();
    private Path mBranch = new Path();
    private Path mBaseLine = new Path();
    private Paint mBaseLinePaint = new Paint();

    public TreeDrawable() {
        this.mTrunkPaint.setAntiAlias(true);
        this.mTrunkPaint.setStrokeWidth(0.1f);
        this.mTrunkPaint.setColor(-12303292);
        this.mBranchPaint.setAntiAlias(true);
        this.mBranchPaint.setColor(-16711936);
        this.mBaseLinePaint.setAntiAlias(true);
        this.mBaseLinePaint.setColor(-65536);
        this.mBaseLinePaint.setStrokeWidth(0.5f);
        this.mBaseLinePaint.setStyle(Paint.Style.STROKE);
        this.updateTree();
    }

    public void setBendScale(float scale) {
        this.mBendScale = scale;
        this.updateTree();
    }

    public void updateTree() {
        int i;
        int i2;
        Interpolator interpolator = PathInterpolatorCompat.create((float)0.8f, (float)(-0.6f * this.mBendScale));
        float width = 100.0f * this.mSizeFactor;
        float height = 200.0f * this.mSizeFactor;
        float maxMove = width * 0.45f * this.mBendScale;
        float trunkSize = width * 0.05f;
        float branchSize = width * 0.2f;
        float x0 = width / 2.0f;
        float y0 = height;
        this.mBaseLine.reset();
        this.mBaseLine.moveTo(x0, y0);
        int N = 50;
        float dp = 0.02f;
        float dy = -0.02f * height;
        float y = y0;
        float p = 0.0f;
        float[] xx = new float[51];
        float[] yy = new float[51];
        for (int i3 = 0; i3 <= 50; ++i3) {
            xx[i3] = interpolator.getInterpolation(p) * maxMove + x0;
            yy[i3] = y;
            this.mBaseLine.lineTo(xx[i3], yy[i3]);
            y += dy;
            p += 0.02f;
        }
        this.mTrunk.reset();
        this.mTrunk.moveTo(x0 - trunkSize, y0);
        int max = 30;
        int max1 = (int)((float)max * 0.6f);
        float diff = max - max1;
        for (i2 = 0; i2 < max; ++i2) {
            if (i2 < max1) {
                this.mTrunk.lineTo(xx[i2] - trunkSize, yy[i2]);
                continue;
            }
            this.mTrunk.lineTo(xx[i2] - trunkSize * (float)(max - i2) / diff, yy[i2]);
        }
        for (i2 = max - 1; i2 >= 0; --i2) {
            if (i2 < max1) {
                this.mTrunk.lineTo(xx[i2] + trunkSize, yy[i2]);
                continue;
            }
            this.mTrunk.lineTo(xx[i2] + trunkSize * (float)(max - i2) / diff, yy[i2]);
        }
        this.mTrunk.close();
        this.mBranch.reset();
        int min = 20;
        diff = 50 - min;
        this.mBranch.addArc(new RectF(xx[min] - branchSize, yy[min] - branchSize, xx[min] + branchSize, yy[min] + branchSize), 0.0f, 180.0f);
        for (i = min; i <= 50; ++i) {
            this.mBranch.lineTo(xx[i] + branchSize - (float)(i - min) / diff * branchSize, yy[i]);
        }
        for (i = 50; i >= min; --i) {
            this.mBranch.lineTo(xx[i] - branchSize + (float)(i - min) / diff * branchSize, yy[i]);
        }
        this.mBranch.close();
    }

    public int getIntrinsicWidth() {
        return (int)(100.0f * this.mSizeFactor);
    }

    public int getIntrinsicHeight() {
        return (int)(200.0f * this.mSizeFactor);
    }

    public void draw(Canvas canvas) {
        canvas.drawPath(this.mBranch, this.mBranchPaint);
        canvas.drawPath(this.mTrunk, this.mTrunkPaint);
        canvas.drawPath(this.mBaseLine, this.mBaseLinePaint);
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return 0;
    }

    private static float getQuadPoint(float x0, float y0, float x1, float y1, float x2, float y2, float x) {
        float a = x0 - 2.0f * x1 + x2;
        float b = 2.0f * (x1 - x0);
        float c = x1 - x;
        float t = (double)a < 1.0E-10 ? (x1 - x) / (2.0f * (x1 - x0)) : (FloatMath.sqrt((float)(b * b - 4.0f * a * c)) + b) / (2.0f * a);
        float t1 = 1.0f - t;
        return t1 * t1 * y0 + 2.0f * t * t1 * y1 + t * t * y2;
    }
}

