/*
 * Decompiled with CFR 0.152.
 */
package com.race604.flyrefresh;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Scroller;
import com.getbase.floatingactionbutton.FloatingActionButton;
import com.race604.flyrefresh.DefalutScrollHandler;
import com.race604.flyrefresh.HeaderController;
import com.race604.flyrefresh.IPullHeader;
import com.race604.flyrefresh.IScrollHandler;
import com.race604.flyrefresh.R;
import com.race604.flyrefresh.internal.ElasticOutInterpolator;
import com.race604.flyrefresh.internal.SimpleAnimatorListener;
import com.race604.utils.UIUtils;

public class PullHeaderLayout
extends ViewGroup {
    private static final String TAG = PullHeaderLayout.class.getCanonicalName();
    private static final boolean D = true;
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGE = 1;
    public static final int STATE_FLING = 2;
    public static final int STATE_BOUNCE = 3;
    static final int ACTION_BUTTON_CENTER = UIUtils.dpToPx(40);
    static final int ACTION_ICON_SIZE = UIUtils.dpToPx(32);
    private static final int DEFAULT_EXPAND = UIUtils.dpToPx(300);
    private static final int DEFAULT_HEIGHT = UIUtils.dpToPx(240);
    private static final int DEFAULT_SHRINK = UIUtils.dpToPx(48);
    private int mHeaderId = 0;
    private int mContentId = 0;
    private int mPagingTouchSlop;
    private MotionEvent mDownEvent;
    private MotionEvent mLastMoveEvent;
    private boolean mHasSendCancelEvent = false;
    private boolean mPreventForHorizontal = false;
    private boolean mDisableWhenHorizontalMove = false;
    private Drawable mActionDrawable;
    private FloatingActionButton mActionView;
    private ImageView mFlyView;
    private View mHeaderView;
    private IPullHeader mPullHeaderView;
    protected View mContent;
    protected HeaderController mHeaderController;
    private IScrollHandler mScrollHandler;
    private ScrollChecker mScrollChecker;
    private VelocityTracker mVelocityTracker;
    private ValueAnimator mBounceAnim;
    private int mMaxVelocity;
    private int mPullState = 0;
    private OnPullListener mPullListener;

    public PullHeaderLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public PullHeaderLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public PullHeaderLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public PullHeaderLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        int headerHeight = DEFAULT_HEIGHT;
        int headerExpandHeight = DEFAULT_EXPAND;
        int headerShrinkHeight = DEFAULT_SHRINK;
        if (attrs != null) {
            TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.PullHeaderLayout);
            headerHeight = arr.getDimensionPixelOffset(R.styleable.PullHeaderLayout_phl_header_height, DEFAULT_HEIGHT);
            headerExpandHeight = arr.getDimensionPixelOffset(R.styleable.PullHeaderLayout_phl_header_expand_height, DEFAULT_EXPAND);
            headerShrinkHeight = arr.getDimensionPixelOffset(R.styleable.PullHeaderLayout_phl_header_shrink_height, DEFAULT_SHRINK);
            this.mHeaderId = arr.getResourceId(R.styleable.PullHeaderLayout_phl_header, this.mHeaderId);
            this.mContentId = arr.getResourceId(R.styleable.PullHeaderLayout_phl_content, this.mContentId);
            this.mActionDrawable = arr.getDrawable(R.styleable.PullHeaderLayout_phl_action);
            arr.recycle();
        }
        this.mHeaderController = new HeaderController(headerHeight, headerExpandHeight, headerShrinkHeight);
        ViewConfiguration conf = ViewConfiguration.get((Context)this.getContext());
        this.mPagingTouchSlop = conf.getScaledTouchSlop() * 2;
        this.mScrollHandler = new DefalutScrollHandler();
        this.mScrollChecker = new ScrollChecker();
        this.mMaxVelocity = conf.getScaledMaximumFlingVelocity();
    }

    public void setHeaderSize(int height, int maxHeight, int minHeight) {
        this.mHeaderController.setSize(height, maxHeight, minHeight);
        if (this.isLayoutRequested()) {
            this.requestLayout();
        }
    }

    public void setScrollHandler(IScrollHandler handler) {
        this.mScrollHandler = handler;
    }

    public void setOnPullListener(OnPullListener listener) {
        this.mPullListener = listener;
    }

    public void setActionDrawable(Drawable actionDrawable) {
        this.mActionDrawable = actionDrawable;
        if (this.mActionDrawable != null) {
            if (this.mActionView == null) {
                int bgColor = UIUtils.getThemeColorFromAttrOrRes(this.getContext(), R.attr.colorAccent, R.color.accent);
                int pressedColor = UIUtils.darkerColor(bgColor, 0.8f);
                this.mActionView = new FloatingActionButton(this.getContext());
                this.mActionView.setColorNormal(bgColor);
                this.mActionView.setColorPressed(pressedColor);
                this.addView((View)this.mActionView);
            }
            if (this.mFlyView == null) {
                this.mFlyView = new ImageView(this.getContext());
                this.mFlyView.setScaleType(ImageView.ScaleType.FIT_XY);
                this.addView((View)this.mFlyView, (ViewGroup.LayoutParams)new LayoutParams(ACTION_ICON_SIZE, ACTION_ICON_SIZE));
            }
            this.mFlyView.setImageDrawable(this.mActionDrawable);
        } else if (this.mActionView != null) {
            this.removeView((View)this.mActionView);
            this.removeView((View)this.mFlyView);
            this.mActionView = null;
            this.mFlyView = null;
        }
    }

    public View getIconView() {
        return this.mFlyView;
    }

    public void setHeaderView(View headerView, LayoutParams lp) {
        if (this.mHeaderView != null) {
            this.removeView(this.mHeaderView);
            this.mPullHeaderView = null;
        }
        this.addView(headerView, 0, (ViewGroup.LayoutParams)lp);
        this.mHeaderView = headerView;
        if (this.mHeaderView instanceof IPullHeader) {
            this.mPullHeaderView = (IPullHeader)this.mHeaderView;
        }
    }

    protected void onFinishInflate() {
        int childCount = this.getChildCount();
        if (childCount > 2) {
            throw new IllegalStateException("FlyRefreshLayout only can host 2 elements");
        }
        if (childCount == 2) {
            if (this.mHeaderId != 0 && this.mHeaderView == null) {
                this.mHeaderView = this.findViewById(this.mHeaderId);
            }
            if (this.mContentId != 0 && this.mContent == null) {
                this.mContent = this.findViewById(this.mContentId);
            }
            if (this.mContent == null || this.mHeaderView == null) {
                View child1 = this.getChildAt(0);
                View child2 = this.getChildAt(1);
                if (child1 instanceof IPullHeader) {
                    this.mHeaderView = child1;
                    this.mContent = child2;
                    this.mPullHeaderView = (IPullHeader)this.mHeaderView;
                } else if (child2 instanceof IPullHeader) {
                    this.mHeaderView = child2;
                    this.mContent = child1;
                    this.mPullHeaderView = (IPullHeader)this.mHeaderView;
                } else if (this.mContent == null && this.mHeaderView == null) {
                    this.mHeaderView = child1;
                    this.mContent = child2;
                } else if (this.mHeaderView == null) {
                    this.mHeaderView = this.mContent == child1 ? child2 : child1;
                } else {
                    this.mContent = this.mHeaderView == child1 ? child2 : child1;
                }
            }
        } else if (childCount == 1) {
            this.mContent = this.getChildAt(0);
        }
        this.setActionDrawable(this.mActionDrawable);
        super.onFinishInflate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mHeaderView != null) {
            this.measureChildWithMargins(this.mHeaderView, widthMeasureSpec, 0, heightMeasureSpec, 0);
        }
        if (this.mContent != null) {
            this.measureChildWithMargins(this.mContent, widthMeasureSpec, 0, heightMeasureSpec, this.mHeaderController.getMinHeight());
        }
        if (this.mActionView != null) {
            this.measureChild((View)this.mActionView, widthMeasureSpec, heightMeasureSpec);
            this.measureChild((View)this.mFlyView, widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren();
    }

    private void layoutChildren() {
        int bottom;
        int right;
        int top;
        int left;
        ViewGroup.MarginLayoutParams lp;
        int offsetY = this.mHeaderController.getCurrentPos();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        if (this.mHeaderView != null) {
            lp = (ViewGroup.MarginLayoutParams)this.mHeaderView.getLayoutParams();
            left = paddingLeft + lp.leftMargin;
            top = paddingTop + lp.topMargin;
            right = left + this.mHeaderView.getMeasuredWidth();
            bottom = top + this.mHeaderView.getMeasuredHeight();
            this.mHeaderView.layout(left, top, right, bottom);
        }
        if (this.mContent != null) {
            lp = (ViewGroup.MarginLayoutParams)this.mContent.getLayoutParams();
            left = paddingLeft + lp.leftMargin;
            top = paddingTop + lp.topMargin + offsetY;
            right = left + this.mContent.getMeasuredWidth();
            bottom = top + this.mContent.getMeasuredHeight();
            this.mContent.layout(left, top, right, bottom);
        }
        if (this.mActionView != null) {
            int center = ACTION_BUTTON_CENTER;
            int halfWidth = (this.mActionView.getMeasuredWidth() + 1) / 2;
            int halfHeight = (this.mActionView.getMeasuredHeight() + 1) / 2;
            int adjustCenter = UIUtils.dpToPx(2);
            this.mActionView.layout(center - halfWidth, offsetY - halfHeight + adjustCenter, center + halfWidth, offsetY + halfHeight + adjustCenter);
            halfWidth = (this.mFlyView.getMeasuredWidth() + 1) / 2;
            halfHeight = (this.mFlyView.getMeasuredHeight() + 1) / 2;
            this.mFlyView.layout(center - halfWidth, offsetY - halfHeight, center + halfWidth, offsetY + halfHeight);
        }
    }

    private void sendCancelEvent() {
        MotionEvent last = this.mLastMoveEvent;
        MotionEvent e = MotionEvent.obtain((long)last.getDownTime(), (long)(last.getEventTime() + (long)ViewConfiguration.getLongPressTimeout()), (int)3, (float)last.getX(), (float)last.getY(), (int)last.getMetaState());
        super.dispatchTouchEvent(e);
    }

    private void sendDownEvent() {
        MotionEvent last = this.mLastMoveEvent;
        MotionEvent e = MotionEvent.obtain((long)last.getDownTime(), (long)last.getEventTime(), (int)0, (float)last.getX(), (float)last.getY(), (int)last.getMetaState());
        super.dispatchTouchEvent(e);
    }

    private void obtainVelocityTracker(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private float getInitVelocity() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
            return this.mVelocityTracker.getYVelocity();
        }
        return 0.0f;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.isEnabled() || this.mContent == null || this.mHeaderView == null) {
            return super.dispatchTouchEvent(ev);
        }
        this.obtainVelocityTracker(ev);
        int action = ev.getAction();
        switch (action) {
            case 1: 
            case 3: {
                float initVelocity = this.getInitVelocity();
                this.releaseVelocityTracker();
                if (this.mHeaderController.isInTouch()) {
                    this.mHeaderController.onTouchRelease();
                    this.onRelease((int)initVelocity);
                    if (this.mHeaderController.hasMoved()) {
                        this.sendCancelEvent();
                        return true;
                    }
                    return super.dispatchTouchEvent(ev);
                }
                return super.dispatchTouchEvent(ev);
            }
            case 0: {
                this.mHasSendCancelEvent = false;
                this.mDownEvent = ev;
                this.mHeaderController.onTouchDown(ev.getX(), ev.getY());
                if (this.mBounceAnim != null && this.mBounceAnim.isRunning()) {
                    this.mBounceAnim.cancel();
                }
                this.mScrollChecker.abortIfWorking();
                this.mPreventForHorizontal = false;
                super.dispatchTouchEvent(ev);
            }
            case 2: {
                boolean moveDown;
                this.mLastMoveEvent = ev;
                this.mHeaderController.onTouchMove(ev.getX(), ev.getY());
                float offsetX = this.mHeaderController.getOffsetX();
                float offsetY = this.mHeaderController.getOffsetY();
                if (this.mDisableWhenHorizontalMove && !this.mPreventForHorizontal && Math.abs(offsetX) > (float)this.mPagingTouchSlop && Math.abs(offsetX) > Math.abs(offsetY)) {
                    this.mPreventForHorizontal = true;
                }
                if (this.mPreventForHorizontal) {
                    return super.dispatchTouchEvent(ev);
                }
                boolean bl = moveDown = offsetY > 0.0f;
                if (moveDown) {
                    if (this.mContent != null && this.mScrollHandler.canScrollUp(this.mContent)) {
                        if (this.mHeaderController.isInTouch()) {
                            this.mHeaderController.onTouchRelease();
                            this.sendDownEvent();
                        }
                        return super.dispatchTouchEvent(ev);
                    }
                    if (!this.mHeaderController.isInTouch()) {
                        this.mHeaderController.onTouchDown(ev.getX(), ev.getY());
                        offsetY = this.mHeaderController.getOffsetY();
                    }
                    this.willMovePos(offsetY);
                    return true;
                }
                if (this.mHeaderController.canMoveUp()) {
                    this.willMovePos(offsetY);
                    return true;
                }
                if (this.mHeaderController.isInTouch()) {
                    this.mHeaderController.onTouchRelease();
                    this.sendDownEvent();
                }
                return super.dispatchTouchEvent(ev);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void willMovePos(float deltaY) {
        int delta = this.mHeaderController.willMove(deltaY);
        if (delta == 0) {
            return;
        }
        if (!this.mHasSendCancelEvent && this.mHeaderController.isInTouch()) {
            this.sendCancelEvent();
        }
        if (this.mPullState != 1) {
            this.mPullState = 1;
        }
        this.movePos(delta);
    }

    protected void onMoveHeader(int state, float progress) {
    }

    private void movePos(float delta) {
        if (this.mContent != null) {
            this.mContent.offsetTopAndBottom((int)delta);
        }
        if (this.mActionView != null) {
            this.mActionView.offsetTopAndBottom((int)delta);
            this.mFlyView.offsetTopAndBottom((int)delta);
            float percentage = this.mHeaderController.getMovePercentage();
            this.onMoveHeader(this.mPullState, percentage);
            if (this.mPullHeaderView != null) {
                this.mPullHeaderView.onPullProgress(this, this.mPullState, percentage);
            }
            if (this.mPullListener != null) {
                this.mPullListener.onPullProgress(this, this.mPullState, percentage);
            }
        }
    }

    private void onRelease(int velocity) {
        this.mScrollChecker.tryToScrollTo(velocity);
    }

    private void onScrollFinish() {
        if (this.mHeaderController.isOverHeight()) {
            this.mBounceAnim = ObjectAnimator.ofFloat((float[])new float[]{this.mHeaderController.getCurrentPos(), this.mHeaderController.getHeight()});
            this.mBounceAnim.setInterpolator((TimeInterpolator)new ElasticOutInterpolator());
            this.mBounceAnim.setDuration(500L);
            this.mBounceAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    PullHeaderLayout.this.movePos(PullHeaderLayout.this.mHeaderController.moveTo(value));
                }
            });
            this.mBounceAnim.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    PullHeaderLayout.this.mPullState = 0;
                }
            });
            this.mBounceAnim.start();
            this.mPullState = 3;
            if (this.mHeaderController.needSendRefresh()) {
                this.onStartRefreshAnimation();
            }
        } else {
            this.mPullState = 0;
        }
    }

    protected void onStartRefreshAnimation() {
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public static interface OnPullListener {
        public void onPullProgress(PullHeaderLayout var1, int var2, float var3);
    }

    class ScrollChecker
    implements Runnable {
        private Scroller mScroller;
        private boolean mIsRunning = false;
        private int mStart;

        public ScrollChecker() {
            this.mScroller = new Scroller(PullHeaderLayout.this.getContext());
        }

        @Override
        public void run() {
            boolean finish = !this.mScroller.computeScrollOffset();
            int curY = this.mScroller.getCurrY();
            int deltaY = PullHeaderLayout.this.mHeaderController.moveTo(curY);
            if (!finish) {
                PullHeaderLayout.this.movePos(deltaY);
                PullHeaderLayout.this.postDelayed(this, 10L);
            } else {
                this.finish();
            }
        }

        private void finish() {
            this.reset();
            PullHeaderLayout.this.onScrollFinish();
        }

        private void reset() {
            this.mIsRunning = false;
            PullHeaderLayout.this.removeCallbacks(this);
        }

        public void abortIfWorking() {
            if (this.mIsRunning) {
                if (!this.mScroller.isFinished()) {
                    this.mScroller.forceFinished(true);
                }
                this.reset();
            }
        }

        public void tryToScrollTo(int velocity) {
            PullHeaderLayout.this.mPullState = 2;
            this.mStart = PullHeaderLayout.this.mHeaderController.getCurrentPos();
            PullHeaderLayout.this.removeCallbacks(this);
            if (!this.mScroller.isFinished()) {
                this.mScroller.forceFinished(true);
            }
            PullHeaderLayout.this.mHeaderController.startMove();
            this.mScroller.setFriction(ViewConfiguration.getScrollFriction() * 4.0f);
            this.mScroller.fling(0, this.mStart, 0, velocity, 0, 0, PullHeaderLayout.this.mHeaderController.getMinHeight(), PullHeaderLayout.this.mHeaderController.getMaxHeight());
            PullHeaderLayout.this.post(this);
            this.mIsRunning = true;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

