/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.observation.micrometer;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageHandler;
import com.rabbitmq.stream.ObservationCollector;
import com.rabbitmq.stream.observation.micrometer.ProcessContext;
import com.rabbitmq.stream.observation.micrometer.ProcessObservationConvention;
import com.rabbitmq.stream.observation.micrometer.PublishContext;
import com.rabbitmq.stream.observation.micrometer.PublishObservationConvention;
import com.rabbitmq.stream.observation.micrometer.StreamObservationDocumentation;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MicrometerObservationCollector
implements ObservationCollector<Observation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrometerObservationCollector.class);
    private final ObservationRegistry registry;
    private final PublishObservationConvention customPublishConvention;
    private final PublishObservationConvention defaultPublishConvention;
    private final ProcessObservationConvention customProcessConvention;
    private final ProcessObservationConvention defaultProcessConvention;

    MicrometerObservationCollector(ObservationRegistry registry, PublishObservationConvention customPublishConvention, PublishObservationConvention defaultPublishConvention, ProcessObservationConvention customProcessConvention, ProcessObservationConvention defaultProcessConvention) {
        this.registry = registry;
        this.customPublishConvention = customPublishConvention;
        this.defaultPublishConvention = defaultPublishConvention;
        this.customProcessConvention = customProcessConvention;
        this.defaultProcessConvention = defaultProcessConvention;
    }

    @Override
    public void published(Observation observation, Message message) {
        try {
            observation.stop();
        }
        catch (Exception e) {
            LOGGER.warn("Error while stopping Micrometer observation: {}", (Object)e.getMessage());
        }
    }

    @Override
    public Observation prePublish(String stream, Message message) {
        PublishContext context = new PublishContext(stream, message);
        Observation observation = StreamObservationDocumentation.PUBLISH_OBSERVATION.observation(this.customPublishConvention, this.defaultPublishConvention, () -> context, this.registry);
        observation.start();
        return observation;
    }

    @Override
    public MessageHandler subscribe(MessageHandler handler) {
        return new ObservationMessageHandler(handler, this.registry, this.customProcessConvention, this.defaultProcessConvention);
    }

    private static class ObservationMessageHandler
    implements MessageHandler {
        private final MessageHandler delegate;
        private final ObservationRegistry registry;
        private final ProcessObservationConvention customProcessConvention;
        private final ProcessObservationConvention defaultProcessConvention;

        private ObservationMessageHandler(MessageHandler delegate, ObservationRegistry registry, ProcessObservationConvention customProcessConvention, ProcessObservationConvention defaultProcessConvention) {
            this.delegate = delegate;
            this.registry = registry;
            this.customProcessConvention = customProcessConvention;
            this.defaultProcessConvention = defaultProcessConvention;
        }

        @Override
        public void handle(MessageHandler.Context context, Message message) {
            ProcessContext processContext = new ProcessContext(context.stream(), message);
            Observation observation = StreamObservationDocumentation.PROCESS_OBSERVATION.observation(this.customProcessConvention, this.defaultProcessConvention, () -> processContext, this.registry);
            observation.observeChecked(() -> this.delegate.handle(context, message));
        }
    }
}

