/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.StreamNotAvailableException;
import com.rabbitmq.stream.impl.ConnectionStreamException;
import java.nio.channels.ClosedChannelException;
import java.util.function.Predicate;

final class CoordinatorUtils {
    private static final Predicate<Throwable> REFRESH_CANDIDATES = e -> e instanceof ConnectionStreamException || e instanceof ClientClosedException || e instanceof StreamNotAvailableException || e instanceof ClosedChannelException;

    private CoordinatorUtils() {
    }

    static boolean shouldRefreshCandidates(Throwable e) {
        return REFRESH_CANDIDATES.test(e) || REFRESH_CANDIDATES.test(e.getCause());
    }

    static class ClientClosedException
    extends StreamException {
        public ClientClosedException() {
            super("Client already closed", new Object[0]);
        }
    }
}

