/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.codec;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageBuilder;
import com.rabbitmq.stream.codec.QpidProtonCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

class QpidProtonMessageBuilder
implements MessageBuilder {
    private final org.apache.qpid.proton.message.Message message = Message.Factory.create();
    private final AtomicBoolean built = new AtomicBoolean(false);
    private boolean hasPublishingId = false;
    private long publishingId = 0L;
    private QpidProtonjPropertiesBuilder propertiesBuilder;
    private QpidProtonjApplicationPropertiesBuilder applicationPropertiesBuilder;
    private QpidProtonjMessageAnnotationsBuilder messageAnnotationsBuilder;

    QpidProtonMessageBuilder() {
    }

    @Override
    public Message build() {
        if (this.built.compareAndSet(false, true)) {
            if (this.propertiesBuilder != null) {
                this.message.setProperties(this.propertiesBuilder.properties);
            }
            if (this.applicationPropertiesBuilder != null) {
                this.message.setApplicationProperties(new ApplicationProperties(this.applicationPropertiesBuilder.applicationProperties));
            }
            if (this.messageAnnotationsBuilder != null) {
                this.message.setMessageAnnotations(new MessageAnnotations(this.messageAnnotationsBuilder.messageAnnotations));
            }
            if (this.message.getBody() == null) {
                this.message.setBody(QpidProtonCodec.EMPTY_BODY);
            }
            return new QpidProtonCodec.QpidProtonAmqpMessageWrapper(this.hasPublishingId, this.publishingId, this.message);
        }
        throw new IllegalStateException("A message builder can build only one message");
    }

    @Override
    @SuppressFBWarnings(value={"AT_NONATOMIC_64BIT_PRIMITIVE", "AT_STALE_THREAD_WRITE_OF_PRIMITIVE"})
    public MessageBuilder publishingId(long publishingId) {
        this.publishingId = publishingId;
        this.hasPublishingId = true;
        return this;
    }

    @Override
    public MessageBuilder.PropertiesBuilder properties() {
        if (this.propertiesBuilder == null) {
            this.propertiesBuilder = new QpidProtonjPropertiesBuilder(this);
        }
        return this.propertiesBuilder;
    }

    @Override
    public MessageBuilder.ApplicationPropertiesBuilder applicationProperties() {
        if (this.applicationPropertiesBuilder == null) {
            this.applicationPropertiesBuilder = new QpidProtonjApplicationPropertiesBuilder(this);
        }
        return this.applicationPropertiesBuilder;
    }

    @Override
    public MessageBuilder.MessageAnnotationsBuilder messageAnnotations() {
        if (this.messageAnnotationsBuilder == null) {
            this.messageAnnotationsBuilder = new QpidProtonjMessageAnnotationsBuilder(this);
        }
        return this.messageAnnotationsBuilder;
    }

    @Override
    public MessageBuilder addData(byte[] data) {
        this.message.setBody((Section)new Data(new Binary(data)));
        return this;
    }

    private static class QpidProtonjApplicationPropertiesBuilder
    implements MessageBuilder.ApplicationPropertiesBuilder {
        private final Map<String, Object> applicationProperties = new LinkedHashMap<String, Object>();
        private final MessageBuilder messageBuilder;

        private QpidProtonjApplicationPropertiesBuilder(MessageBuilder messageBuilder) {
            this.messageBuilder = messageBuilder;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, boolean value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, byte value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, short value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, int value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, long value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, byte value) {
            this.applicationProperties.put(key, new UnsignedByte(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, short value) {
            this.applicationProperties.put(key, new UnsignedShort(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, int value) {
            this.applicationProperties.put(key, new UnsignedInteger(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, long value) {
            this.applicationProperties.put(key, new UnsignedLong(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, float value) {
            this.applicationProperties.put(key, Float.valueOf(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, double value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryDecimal32(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryDecimal64(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryDecimal128(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, char value) {
            this.applicationProperties.put(key, Character.valueOf(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryTimestamp(String key, long value) {
            this.applicationProperties.put(key, new Date(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, UUID uuid) {
            this.applicationProperties.put(key, uuid);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, byte[] value) {
            this.applicationProperties.put(key, new Binary(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, String value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entrySymbol(String key, String value) {
            this.applicationProperties.put(key, Symbol.valueOf((String)value));
            return this;
        }

        @Override
        public MessageBuilder messageBuilder() {
            return this.messageBuilder;
        }
    }

    private static class QpidProtonjMessageAnnotationsBuilder
    implements MessageBuilder.MessageAnnotationsBuilder {
        private final Map<Symbol, Object> messageAnnotations = new LinkedHashMap<Symbol, Object>();
        private final MessageBuilder messageBuilder;

        private QpidProtonjMessageAnnotationsBuilder(MessageBuilder messageBuilder) {
            this.messageBuilder = messageBuilder;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, boolean value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, byte value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, short value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, int value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, long value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, byte value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), new UnsignedByte(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, short value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), new UnsignedShort(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, int value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), new UnsignedInteger(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, long value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), new UnsignedLong(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, float value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), Float.valueOf(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, double value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryDecimal32(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryDecimal64(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryDecimal128(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, char value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), Character.valueOf(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryTimestamp(String key, long value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), new Date(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, UUID uuid) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), uuid);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, byte[] value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), new Binary(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, String value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entrySymbol(String key, String value) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), Symbol.valueOf((String)value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, List<?> list) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), list);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, Map<?, ?> map) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), map);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryArray(String key, Object[] array) {
            this.messageAnnotations.put(Symbol.getSymbol((String)key), array);
            return this;
        }

        @Override
        public MessageBuilder messageBuilder() {
            return this.messageBuilder;
        }
    }

    private static class QpidProtonjPropertiesBuilder
    implements MessageBuilder.PropertiesBuilder {
        private final Properties properties = new Properties();
        private final MessageBuilder messageBuilder;

        private QpidProtonjPropertiesBuilder(MessageBuilder messageBuilder) {
            this.messageBuilder = messageBuilder;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(String id) {
            this.properties.setMessageId((Object)id);
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(long id) {
            this.properties.setMessageId((Object)new UnsignedLong(id));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(byte[] id) {
            this.properties.setMessageId((Object)new Binary(id));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(UUID id) {
            this.properties.setMessageId((Object)id);
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder userId(byte[] userId) {
            this.properties.setUserId(new Binary(userId));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder to(String address) {
            this.properties.setTo(address);
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder subject(String subject) {
            this.properties.setSubject(subject);
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder replyTo(String replyTo) {
            this.properties.setReplyTo(replyTo);
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(String correlationId) {
            this.properties.setCorrelationId((Object)correlationId);
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(long correlationId) {
            this.properties.setCorrelationId((Object)new UnsignedLong(correlationId));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(byte[] correlationId) {
            this.properties.setCorrelationId((Object)new Binary(correlationId));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(UUID correlationId) {
            this.properties.setCorrelationId((Object)correlationId);
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder contentType(String contentType) {
            this.properties.setContentType(Symbol.valueOf((String)contentType));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder contentEncoding(String contentEncoding) {
            this.properties.setContentEncoding(Symbol.valueOf((String)contentEncoding));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder absoluteExpiryTime(long absoluteExpiryTime) {
            this.properties.setAbsoluteExpiryTime(new Date(absoluteExpiryTime));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder creationTime(long creationTime) {
            this.properties.setCreationTime(new Date(creationTime));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder groupId(String groupId) {
            this.properties.setGroupId(groupId);
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder groupSequence(long groupSequence) {
            this.properties.setGroupSequence(UnsignedInteger.valueOf((long)groupSequence));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder replyToGroupId(String replyToGroupId) {
            this.properties.setReplyToGroupId(replyToGroupId);
            return this;
        }

        @Override
        public MessageBuilder messageBuilder() {
            return this.messageBuilder;
        }
    }
}

