/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Consumer;
import com.rabbitmq.stream.ConsumerBuilder;
import com.rabbitmq.stream.ConsumerUpdateListener;
import com.rabbitmq.stream.MessageHandler;
import com.rabbitmq.stream.OffsetSpecification;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.SubscriptionListener;
import com.rabbitmq.stream.impl.StreamConsumer;
import com.rabbitmq.stream.impl.StreamEnvironment;
import com.rabbitmq.stream.impl.SuperStreamConsumer;
import com.rabbitmq.stream.impl.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class StreamConsumerBuilder
implements ConsumerBuilder {
    private static final int NAME_MAX_SIZE = 256;
    private final StreamEnvironment environment;
    private String stream;
    private String superStream;
    private OffsetSpecification offsetSpecification = null;
    private MessageHandler messageHandler;
    private String name;
    private DefaultAutoTrackingStrategy autoTrackingStrategy;
    private DefaultManualTrackingStrategy manualTrackingStrategy;
    private boolean noTrackingStrategy = false;
    private boolean lazyInit = false;
    private SubscriptionListener subscriptionListener = subscriptionContext -> {};
    private Map<String, String> subscriptionProperties = new ConcurrentHashMap<String, String>();
    private ConsumerUpdateListener consumerUpdateListener;
    private static final TrackingConfiguration DISABLED_TRACKING_CONFIGURATION = new TrackingConfiguration(false, false, -1, Duration.ZERO, Duration.ZERO);

    public StreamConsumerBuilder(StreamEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public ConsumerBuilder stream(String stream) {
        this.stream = stream;
        return this;
    }

    @Override
    public ConsumerBuilder superStream(String superStream) {
        this.superStream = superStream;
        return this;
    }

    @Override
    public ConsumerBuilder offset(OffsetSpecification offsetSpecification) {
        this.offsetSpecification = offsetSpecification;
        return this;
    }

    @Override
    public ConsumerBuilder messageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    MessageHandler messageHandler() {
        return this.messageHandler;
    }

    @Override
    public ConsumerBuilder name(String name) {
        if (name == null || name.length() > 256) {
            throw new IllegalArgumentException("The consumer name must be non-null and under 256 characters");
        }
        this.name = name;
        return this;
    }

    @Override
    public ConsumerBuilder singleActiveConsumer() {
        this.subscriptionProperties.put("single-active-consumer", "true");
        return this;
    }

    @Override
    public ConsumerBuilder consumerUpdateListener(ConsumerUpdateListener consumerUpdateListener) {
        this.consumerUpdateListener = consumerUpdateListener;
        return this;
    }

    @Override
    public ConsumerBuilder subscriptionListener(SubscriptionListener subscriptionListener) {
        if (subscriptionListener == null) {
            throw new IllegalArgumentException("The subscription listener cannot be null");
        }
        this.subscriptionListener = subscriptionListener;
        return this;
    }

    @Override
    public ConsumerBuilder.ManualTrackingStrategy manualTrackingStrategy() {
        this.manualTrackingStrategy = new DefaultManualTrackingStrategy(this);
        this.autoTrackingStrategy = null;
        this.noTrackingStrategy = false;
        return this.manualTrackingStrategy;
    }

    @Override
    public ConsumerBuilder.AutoTrackingStrategy autoTrackingStrategy() {
        this.autoTrackingStrategy = new DefaultAutoTrackingStrategy(this);
        this.manualTrackingStrategy = null;
        this.noTrackingStrategy = false;
        return this.autoTrackingStrategy;
    }

    @Override
    public ConsumerBuilder noTrackingStrategy() {
        this.noTrackingStrategy = true;
        this.autoTrackingStrategy = null;
        this.manualTrackingStrategy = null;
        return this;
    }

    StreamConsumerBuilder lazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
        return this;
    }

    @Override
    public Consumer build() {
        Consumer consumer;
        if (this.stream == null && this.superStream == null) {
            throw new IllegalArgumentException("A stream must be specified");
        }
        if (this.stream != null && this.superStream != null) {
            throw new IllegalArgumentException("Stream and superStream cannot be set at the same time");
        }
        if (this.messageHandler == null) {
            throw new IllegalArgumentException("A message handler must be set");
        }
        if (!(this.name != null || this.noTrackingStrategy || this.autoTrackingStrategy == null && this.manualTrackingStrategy == null)) {
            throw new IllegalArgumentException("A name must be set if a tracking strategy is specified");
        }
        if (Utils.isSac(this.subscriptionProperties) && this.name == null) {
            throw new IllegalArgumentException("A name must be set if single active consumer is enabled");
        }
        this.environment.maybeInitializeLocator();
        TrackingConfiguration trackingConfiguration = this.autoTrackingStrategy != null ? new TrackingConfiguration(true, true, this.autoTrackingStrategy.messageCountBeforeStorage, this.autoTrackingStrategy.flushInterval, Duration.ZERO) : (this.manualTrackingStrategy != null ? new TrackingConfiguration(true, false, -1, Duration.ZERO, this.manualTrackingStrategy.checkInterval) : (this.noTrackingStrategy ? DISABLED_TRACKING_CONFIGURATION : (this.name != null ? new TrackingConfiguration(true, true, 10000, Duration.ofSeconds(5L), Duration.ZERO) : DISABLED_TRACKING_CONFIGURATION)));
        if (this.stream != null) {
            consumer = new StreamConsumer(this.stream, this.offsetSpecification, this.messageHandler, this.name, this.environment, trackingConfiguration, this.lazyInit, this.subscriptionListener, this.subscriptionProperties, this.consumerUpdateListener);
            this.environment.addConsumer((StreamConsumer)consumer);
        } else {
            if (Utils.isSac(this.subscriptionProperties)) {
                this.subscriptionProperties.put("super-stream", this.superStream);
            }
            consumer = new SuperStreamConsumer(this, this.superStream, this.environment, trackingConfiguration);
        }
        return consumer;
    }

    StreamConsumerBuilder duplicate() {
        StreamConsumerBuilder duplicate = new StreamConsumerBuilder(this.environment);
        for (Field field : StreamConsumerBuilder.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(duplicate, field.get(this));
            }
            catch (IllegalAccessException e) {
                throw new StreamException("Error while duplicating stream producer builder", e);
            }
        }
        return duplicate;
    }

    public ConsumerUpdateListener consumerUpdateListener() {
        return this.consumerUpdateListener;
    }

    private static final class DefaultManualTrackingStrategy
    implements ConsumerBuilder.ManualTrackingStrategy {
        private final StreamConsumerBuilder builder;
        private Duration checkInterval = Duration.ofSeconds(5L);

        private DefaultManualTrackingStrategy(StreamConsumerBuilder builder) {
            this.builder = builder;
        }

        @Override
        public ConsumerBuilder.ManualTrackingStrategy checkInterval(Duration checkInterval) {
            if (checkInterval.toMillis() <= 1000L && !checkInterval.isZero()) {
                throw new IllegalArgumentException("the check interval cannot be shorter than 1 second");
            }
            this.checkInterval = checkInterval;
            return this;
        }

        @Override
        public ConsumerBuilder builder() {
            return this.builder;
        }
    }

    private static final class DefaultAutoTrackingStrategy
    implements ConsumerBuilder.AutoTrackingStrategy {
        private final StreamConsumerBuilder builder;
        private int messageCountBeforeStorage = 10000;
        private Duration flushInterval = Duration.ofSeconds(5L);

        private DefaultAutoTrackingStrategy(StreamConsumerBuilder builder) {
            this.builder = builder;
        }

        @Override
        public ConsumerBuilder.AutoTrackingStrategy messageCountBeforeStorage(int messageCountBeforeStorage) {
            if (messageCountBeforeStorage <= 0) {
                throw new IllegalArgumentException("the number of messages before storing must be positive");
            }
            this.messageCountBeforeStorage = messageCountBeforeStorage;
            return this;
        }

        @Override
        public ConsumerBuilder.AutoTrackingStrategy flushInterval(Duration flushInterval) {
            if (flushInterval.toMillis() <= 1000L) {
                throw new IllegalArgumentException("the flush interval cannot be shorter than 1 second");
            }
            this.flushInterval = flushInterval;
            return this;
        }

        @Override
        public ConsumerBuilder builder() {
            return this.builder;
        }
    }

    static class TrackingConfiguration {
        private final boolean enabled;
        private final boolean auto;
        private final int autoMessageCountBeforeStorage;
        private final Duration autoFlushInterval;
        private final Duration manualCheckInterval;

        TrackingConfiguration(boolean enabled, boolean auto, int autoMessageCountBeforeStorage, Duration autoFlushInterval, Duration manualCheckInterval) {
            this.enabled = enabled;
            this.auto = auto;
            this.autoMessageCountBeforeStorage = autoMessageCountBeforeStorage;
            this.autoFlushInterval = autoFlushInterval;
            this.manualCheckInterval = manualCheckInterval;
        }

        boolean auto() {
            return this.auto;
        }

        boolean manual() {
            return !this.auto();
        }

        boolean enabled() {
            return this.enabled;
        }

        public int autoMessageCountBeforeStorage() {
            return this.autoMessageCountBeforeStorage;
        }

        public Duration autoFlushInterval() {
            return this.autoFlushInterval;
        }

        public Duration manualCheckInterval() {
            return this.manualCheckInterval;
        }
    }
}

