/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream;

import com.rabbitmq.stream.ByteCapacity;
import java.time.Duration;

public interface StreamCreator {
    public static final ByteCapacity MAX_SEGMENT_SIZE = ByteCapacity.from("3GB");

    public StreamCreator stream(String var1);

    public StreamCreator maxLengthBytes(ByteCapacity var1);

    public StreamCreator maxSegmentSizeBytes(ByteCapacity var1);

    public StreamCreator maxAge(Duration var1);

    public StreamCreator leaderLocator(LeaderLocator var1);

    public void create();

    public static enum LeaderLocator {
        CLIENT_LOCAL("client-local"),
        BALANCED("balanced"),
        RANDOM("random"),
        LEAST_LEADERS("least-leaders");

        String value;

        private LeaderLocator(String value) {
            this.value = value;
        }

        public static LeaderLocator from(String value) {
            for (LeaderLocator leaderLocator : LeaderLocator.values()) {
                if (!leaderLocator.value.equals(value)) continue;
                return leaderLocator;
            }
            throw new IllegalArgumentException("Unknown leader locator value: " + value);
        }

        public String value() {
            return this.value;
        }
    }
}

