/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.amqp;

public final class UnsignedShort
extends Number
implements Comparable<UnsignedShort> {
    public static final UnsignedShort MAX_VALUE = new UnsignedShort(-1);
    private static final UnsignedShort[] cachedValues = new UnsignedShort[256];
    private final short _underlying;

    public UnsignedShort(short underlying) {
        this._underlying = underlying;
    }

    public static UnsignedShort valueOf(short underlying) {
        if ((underlying & 0xFF00) == 0) {
            return cachedValues[underlying];
        }
        return new UnsignedShort(underlying);
    }

    public static UnsignedShort valueOf(String value) {
        int intVal = Integer.parseInt(value);
        if (intVal < 0 || intVal >= 65536) {
            throw new NumberFormatException("Value \"" + value + "\" lies outside the range [0-65536).");
        }
        return UnsignedShort.valueOf((short)intVal);
    }

    @Override
    public short shortValue() {
        return this._underlying;
    }

    @Override
    public int intValue() {
        return this._underlying & 0xFFFF;
    }

    @Override
    public long longValue() {
        return (long)this._underlying & 0xFFFFL;
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedShort that = (UnsignedShort)o;
        return this._underlying == that._underlying;
    }

    @Override
    public int compareTo(UnsignedShort o) {
        return Integer.signum(this.intValue() - o.intValue());
    }

    public int hashCode() {
        return this._underlying;
    }

    public String toString() {
        return String.valueOf(this.longValue());
    }

    static {
        for (short i = 0; i < 256; i = (short)(i + 1)) {
            UnsignedShort.cachedValues[i] = new UnsignedShort(i);
        }
    }
}

