/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.jms.util.TimeTracker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Completion {
    private final FutureBoolean fb = new FutureBoolean();

    public void setComplete() {
        this.fb.setComplete();
    }

    public boolean isComplete() {
        return this.fb.isComplete();
    }

    public void waitUntilComplete() throws InterruptedException {
        this.fb.get();
    }

    public void waitUntilComplete(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        this.fb.get(new TimeTracker(timeout, unit));
    }

    public void waitUntilComplete(TimeTracker tt) throws TimeoutException, InterruptedException {
        this.fb.get(tt);
    }

    private class FutureBoolean {
        private final Object lock = new Object();
        private boolean completed = false;

        private FutureBoolean() {
        }

        public boolean get() throws InterruptedException {
            try {
                return this.get(new TimeTracker());
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("Impossible timeout.", e);
            }
        }

        public boolean get(TimeTracker tt) throws InterruptedException, TimeoutException {
            Object object = this.lock;
            synchronized (object) {
                while (!this.completed && !tt.timedOut()) {
                    tt.timedWait(this.lock);
                }
                if (this.completed) {
                    return true;
                }
                throw new TimeoutException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setComplete() {
            Object object = this.lock;
            synchronized (object) {
                this.completed = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isComplete() {
            Object object = this.lock;
            synchronized (object) {
                return this.completed;
            }
        }
    }
}

