/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.nio;

import com.rabbitmq.client.impl.nio.NioHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SslEngineByteBufferInputStream
extends InputStream {
    private final SSLEngine sslEngine;
    private final ByteBuffer plainIn;
    private final ByteBuffer cipherIn;
    private final ReadableByteChannel channel;

    public SslEngineByteBufferInputStream(SSLEngine sslEngine, ByteBuffer plainIn, ByteBuffer cipherIn, ReadableByteChannel channel) {
        this.sslEngine = sslEngine;
        this.plainIn = plainIn;
        this.cipherIn = cipherIn;
        this.channel = channel;
    }

    @Override
    public int read() throws IOException {
        SSLEngineResult result;
        if (this.plainIn.hasRemaining()) {
            return this.readFromBuffer(this.plainIn);
        }
        this.plainIn.clear();
        block6: while (true) {
            result = this.sslEngine.unwrap(this.cipherIn, this.plainIn);
            switch (result.getStatus()) {
                case OK: {
                    this.plainIn.flip();
                    if (this.plainIn.hasRemaining()) {
                        return this.readFromBuffer(this.plainIn);
                    }
                    this.plainIn.clear();
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("buffer overflow in read");
                }
                case BUFFER_UNDERFLOW: {
                    this.cipherIn.compact();
                    int bytesRead = NioHelper.readWithRetry(this.channel, this.cipherIn);
                    if (bytesRead <= 0) {
                        throw new IllegalStateException("Should be reading something from the network");
                    }
                    this.cipherIn.flip();
                    continue block6;
                }
                case CLOSED: {
                    throw new SSLException("closed in read");
                }
            }
            break;
        }
        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
    }

    private int readFromBuffer(ByteBuffer buffer) {
        return buffer.get() & 0xFF;
    }
}

