/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.TopologyRecoveryException;
import java.io.IOException;
import java.net.ConnectException;

public class DefaultExceptionHandler
implements ExceptionHandler {
    public void handleUnexpectedConnectionDriverException(Connection conn, Throwable exception) {
    }

    public void handleReturnListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "ReturnListener.handleReturn");
    }

    public void handleFlowListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "FlowListener.handleFlow");
    }

    public void handleConfirmListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "ConfirmListener.handle{N,A}ck");
    }

    public void handleBlockedListenerException(Connection connection, Throwable exception) {
        this.handleConnectionKiller(connection, exception, "BlockedListener");
    }

    public void handleConsumerException(Channel channel, Throwable exception, Consumer consumer, String consumerTag, String methodName) {
        this.handleChannelKiller(channel, exception, "Consumer " + consumer + " (" + consumerTag + ")" + " method " + methodName + " for channel " + channel);
    }

    public void handleConnectionRecoveryException(Connection conn, Throwable exception) {
        if (!(exception instanceof ConnectException)) {
            System.err.println("Caught an exception during connection recovery!");
            exception.printStackTrace(System.err);
        }
    }

    public void handleChannelRecoveryException(Channel ch, Throwable exception) {
        System.err.println("Caught an exception when recovering channel " + ch.getChannelNumber());
        exception.printStackTrace(System.err);
    }

    public void handleTopologyRecoveryException(Connection conn, Channel ch, TopologyRecoveryException exception) {
        System.err.println("Caught an exception when recovering topology " + exception.getMessage());
        exception.printStackTrace(System.err);
    }

    protected void handleChannelKiller(Channel channel, Throwable exception, String what) {
        System.err.println("DefaultExceptionHandler: " + what + " threw an exception for channel " + channel + ":");
        exception.printStackTrace();
        try {
            channel.close(200, "Closed due to exception from " + what);
        }
        catch (AlreadyClosedException ace) {
        }
        catch (IOException ioe) {
            System.err.println("Failure during close of channel " + channel + " after " + exception + ":");
            ioe.printStackTrace();
            channel.getConnection().abort(541, "Internal error closing channel for " + what);
        }
    }

    protected void handleConnectionKiller(Connection connection, Throwable exception, String what) {
        System.err.println("DefaultExceptionHandler: " + what + " threw an exception for connection " + connection + ":");
        exception.printStackTrace();
        try {
            connection.close(200, "Closed due to exception from " + what);
        }
        catch (AlreadyClosedException ace) {
        }
        catch (IOException ioe) {
            System.err.println("Failure during close of connection " + connection + " after " + exception + ":");
            ioe.printStackTrace();
            connection.abort(541, "Internal error closing connection for " + what);
        }
    }
}

