/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.MethodArgumentReader;
import com.rabbitmq.client.impl.MethodArgumentWriter;
import com.rabbitmq.client.impl.ValueReader;
import com.rabbitmq.client.impl.ValueWriter;
import com.rabbitmq.utility.BlockingCell;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpcClient {
    private final Channel _channel;
    private final String _exchange;
    private final String _routingKey;
    private final int _timeout;
    protected static final int NO_TIMEOUT = -1;
    private final Map<String, BlockingCell<Object>> _continuationMap = new HashMap<String, BlockingCell<Object>>();
    private int _correlationId;
    private String _replyQueue;
    private DefaultConsumer _consumer;

    public RpcClient(Channel channel, String exchange, String routingKey, int timeout) throws IOException {
        this._channel = channel;
        this._exchange = exchange;
        this._routingKey = routingKey;
        if (timeout < -1) {
            throw new IllegalArgumentException("Timeout arguument must be NO_TIMEOUT(-1) or non-negative.");
        }
        this._timeout = timeout;
        this._correlationId = 0;
        this._replyQueue = this.setupReplyQueue();
        this._consumer = this.setupConsumer();
    }

    public RpcClient(Channel channel, String exchange, String routingKey) throws IOException {
        this(channel, exchange, routingKey, -1);
    }

    public void checkConsumer() throws IOException {
        if (this._consumer == null) {
            throw new EOFException("RpcClient is closed");
        }
    }

    public void close() throws IOException {
        if (this._consumer != null) {
            this._channel.basicCancel(this._consumer.getConsumerTag());
            this._consumer = null;
        }
    }

    protected String setupReplyQueue() throws IOException {
        return this._channel.queueDeclare("", false, true, true, null).getQueue();
    }

    protected DefaultConsumer setupConsumer() throws IOException {
        DefaultConsumer consumer = new DefaultConsumer(this._channel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleShutdownSignal(String consumerTag, ShutdownSignalException signal) {
                Map map = RpcClient.this._continuationMap;
                synchronized (map) {
                    for (Map.Entry entry : RpcClient.this._continuationMap.entrySet()) {
                        ((BlockingCell)entry.getValue()).set(signal);
                    }
                    RpcClient.this._consumer = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                Map map = RpcClient.this._continuationMap;
                synchronized (map) {
                    String replyId = properties.getCorrelationId();
                    BlockingCell blocker = (BlockingCell)RpcClient.this._continuationMap.get(replyId);
                    RpcClient.this._continuationMap.remove(replyId);
                    blocker.set(body);
                }
            }
        };
        this._channel.basicConsume(this._replyQueue, true, consumer);
        return consumer;
    }

    public void publish(AMQP.BasicProperties props, byte[] message) throws IOException {
        this._channel.basicPublish(this._exchange, this._routingKey, props, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] primitiveCall(AMQP.BasicProperties props, byte[] message) throws IOException, ShutdownSignalException, TimeoutException {
        this.checkConsumer();
        BlockingCell k = new BlockingCell();
        Map<String, BlockingCell<Object>> map = this._continuationMap;
        synchronized (map) {
            ++this._correlationId;
            String replyId = "" + this._correlationId;
            props = (props == null ? new AMQP.BasicProperties.Builder() : props.builder()).correlationId(replyId).replyTo(this._replyQueue).build();
            this._continuationMap.put(replyId, k);
        }
        this.publish(props, message);
        Object reply = k.uninterruptibleGet(this._timeout);
        if (reply instanceof ShutdownSignalException) {
            ShutdownSignalException sig = (ShutdownSignalException)reply;
            ShutdownSignalException wrapper = new ShutdownSignalException(sig.isHardError(), sig.isInitiatedByApplication(), sig.getReason(), sig.getReference());
            wrapper.initCause(sig);
            throw wrapper;
        }
        return (byte[])reply;
    }

    public byte[] primitiveCall(byte[] message) throws IOException, ShutdownSignalException, TimeoutException {
        return this.primitiveCall(null, message);
    }

    public String stringCall(String message) throws IOException, ShutdownSignalException, TimeoutException {
        return new String(this.primitiveCall(message.getBytes()));
    }

    public Map<String, Object> mapCall(Map<String, Object> message) throws IOException, ShutdownSignalException, TimeoutException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MethodArgumentWriter writer = new MethodArgumentWriter(new ValueWriter(new DataOutputStream(buffer)));
        writer.writeTable(message);
        writer.flush();
        byte[] reply = this.primitiveCall(buffer.toByteArray());
        MethodArgumentReader reader = new MethodArgumentReader(new ValueReader(new DataInputStream(new ByteArrayInputStream(reply))));
        return reader.readTable();
    }

    public Map<String, Object> mapCall(Object[] keyValuePairs) throws IOException, ShutdownSignalException, TimeoutException {
        HashMap<String, Object> message = new HashMap<String, Object>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            message.put((String)keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return this.mapCall(message);
    }

    public Channel getChannel() {
        return this._channel;
    }

    public String getExchange() {
        return this._exchange;
    }

    public String getRoutingKey() {
        return this._routingKey;
    }

    public Map<String, BlockingCell<Object>> getContinuationMap() {
        return this._continuationMap;
    }

    public int getCorrelationId() {
        return this._correlationId;
    }

    public String getReplyQueue() {
        return this._replyQueue;
    }

    public Consumer getConsumer() {
        return this._consumer;
    }
}

