/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.impl.AMQBasicProperties;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.ContentHeaderPropertyReader;
import com.rabbitmq.client.impl.ContentHeaderPropertyWriter;
import com.rabbitmq.client.impl.LongStringHelper;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public interface AMQP {
    public static final int FRAME_METHOD = 1;
    public static final int FRAME_HEADER = 2;
    public static final int FRAME_BODY = 3;
    public static final int FRAME_HEARTBEAT = 8;
    public static final int FRAME_MIN_SIZE = 4096;
    public static final int FRAME_END = 206;
    public static final int REPLY_SUCCESS = 200;
    public static final int CONTENT_TOO_LARGE = 311;
    public static final int NO_ROUTE = 312;
    public static final int NO_CONSUMERS = 313;
    public static final int ACCESS_REFUSED = 403;
    public static final int NOT_FOUND = 404;
    public static final int RESOURCE_LOCKED = 405;
    public static final int PRECONDITION_FAILED = 406;
    public static final int CONNECTION_FORCED = 320;
    public static final int INVALID_PATH = 402;
    public static final int FRAME_ERROR = 501;
    public static final int SYNTAX_ERROR = 502;
    public static final int COMMAND_INVALID = 503;
    public static final int CHANNEL_ERROR = 504;
    public static final int UNEXPECTED_FRAME = 505;
    public static final int RESOURCE_ERROR = 506;
    public static final int NOT_ALLOWED = 530;
    public static final int NOT_IMPLEMENTED = 540;
    public static final int INTERNAL_ERROR = 541;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicProperties
    extends AMQBasicProperties {
        private String contentType;
        private String contentEncoding;
        private Map<String, Object> headers;
        private Integer deliveryMode;
        private Integer priority;
        private String correlationId;
        private String replyTo;
        private String expiration;
        private String messageId;
        private Date timestamp;
        private String type;
        private String userId;
        private String appId;
        private String clusterId;

        public BasicProperties(String contentType, String contentEncoding, Map<String, Object> headers, Integer deliveryMode, Integer priority, String correlationId, String replyTo, String expiration, String messageId, Date timestamp, String type, String userId, String appId, String clusterId) {
            this.contentType = contentType;
            this.contentEncoding = contentEncoding;
            this.headers = headers == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(headers));
            this.deliveryMode = deliveryMode;
            this.priority = priority;
            this.correlationId = correlationId;
            this.replyTo = replyTo;
            this.expiration = expiration;
            this.messageId = messageId;
            this.timestamp = timestamp;
            this.type = type;
            this.userId = userId;
            this.appId = appId;
            this.clusterId = clusterId;
        }

        public BasicProperties(DataInputStream in) throws IOException {
            super(in);
            ContentHeaderPropertyReader reader = new ContentHeaderPropertyReader(in);
            boolean contentType_present = reader.readPresence();
            boolean contentEncoding_present = reader.readPresence();
            boolean headers_present = reader.readPresence();
            boolean deliveryMode_present = reader.readPresence();
            boolean priority_present = reader.readPresence();
            boolean correlationId_present = reader.readPresence();
            boolean replyTo_present = reader.readPresence();
            boolean expiration_present = reader.readPresence();
            boolean messageId_present = reader.readPresence();
            boolean timestamp_present = reader.readPresence();
            boolean type_present = reader.readPresence();
            boolean userId_present = reader.readPresence();
            boolean appId_present = reader.readPresence();
            boolean clusterId_present = reader.readPresence();
            reader.finishPresence();
            this.contentType = contentType_present ? reader.readShortstr() : null;
            this.contentEncoding = contentEncoding_present ? reader.readShortstr() : null;
            this.headers = headers_present ? reader.readTable() : null;
            this.deliveryMode = deliveryMode_present ? Integer.valueOf(reader.readOctet()) : null;
            this.priority = priority_present ? Integer.valueOf(reader.readOctet()) : null;
            this.correlationId = correlationId_present ? reader.readShortstr() : null;
            this.replyTo = replyTo_present ? reader.readShortstr() : null;
            this.expiration = expiration_present ? reader.readShortstr() : null;
            this.messageId = messageId_present ? reader.readShortstr() : null;
            this.timestamp = timestamp_present ? reader.readTimestamp() : null;
            this.type = type_present ? reader.readShortstr() : null;
            this.userId = userId_present ? reader.readShortstr() : null;
            this.appId = appId_present ? reader.readShortstr() : null;
            this.clusterId = clusterId_present ? reader.readShortstr() : null;
        }

        public BasicProperties() {
        }

        @Override
        public int getClassId() {
            return 60;
        }

        @Override
        public String getClassName() {
            return "basic";
        }

        public Builder builder() {
            Builder builder = new Builder();
            builder.contentType(this.contentType).contentEncoding(this.contentEncoding).headers(this.headers).deliveryMode(this.deliveryMode).priority(this.priority).correlationId(this.correlationId).replyTo(this.replyTo).expiration(this.expiration).messageId(this.messageId).timestamp(this.timestamp).type(this.type).userId(this.userId).appId(this.appId).clusterId(this.clusterId);
            return builder;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        @Deprecated
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        @Deprecated
        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @Override
        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        @Override
        @Deprecated
        public void setHeaders(Map<String, Object> headers) {
            this.headers = headers == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(headers));
        }

        @Override
        public Integer getDeliveryMode() {
            return this.deliveryMode;
        }

        @Override
        @Deprecated
        public void setDeliveryMode(Integer deliveryMode) {
            this.deliveryMode = deliveryMode;
        }

        @Override
        public Integer getPriority() {
            return this.priority;
        }

        @Override
        @Deprecated
        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public String getCorrelationId() {
            return this.correlationId;
        }

        @Override
        @Deprecated
        public void setCorrelationId(String correlationId) {
            this.correlationId = correlationId;
        }

        @Override
        public String getReplyTo() {
            return this.replyTo;
        }

        @Override
        @Deprecated
        public void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        @Override
        public String getExpiration() {
            return this.expiration;
        }

        @Override
        @Deprecated
        public void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        @Deprecated
        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        @Deprecated
        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        @Deprecated
        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }

        @Override
        @Deprecated
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public String getAppId() {
            return this.appId;
        }

        @Override
        @Deprecated
        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        @Deprecated
        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
            writer.writePresence(this.contentType != null);
            writer.writePresence(this.contentEncoding != null);
            writer.writePresence(this.headers != null);
            writer.writePresence(this.deliveryMode != null);
            writer.writePresence(this.priority != null);
            writer.writePresence(this.correlationId != null);
            writer.writePresence(this.replyTo != null);
            writer.writePresence(this.expiration != null);
            writer.writePresence(this.messageId != null);
            writer.writePresence(this.timestamp != null);
            writer.writePresence(this.type != null);
            writer.writePresence(this.userId != null);
            writer.writePresence(this.appId != null);
            writer.writePresence(this.clusterId != null);
            writer.finishPresence();
            if (this.contentType != null) {
                writer.writeShortstr(this.contentType);
            }
            if (this.contentEncoding != null) {
                writer.writeShortstr(this.contentEncoding);
            }
            if (this.headers != null) {
                writer.writeTable(this.headers);
            }
            if (this.deliveryMode != null) {
                writer.writeOctet(this.deliveryMode);
            }
            if (this.priority != null) {
                writer.writeOctet(this.priority);
            }
            if (this.correlationId != null) {
                writer.writeShortstr(this.correlationId);
            }
            if (this.replyTo != null) {
                writer.writeShortstr(this.replyTo);
            }
            if (this.expiration != null) {
                writer.writeShortstr(this.expiration);
            }
            if (this.messageId != null) {
                writer.writeShortstr(this.messageId);
            }
            if (this.timestamp != null) {
                writer.writeTimestamp(this.timestamp);
            }
            if (this.type != null) {
                writer.writeShortstr(this.type);
            }
            if (this.userId != null) {
                writer.writeShortstr(this.userId);
            }
            if (this.appId != null) {
                writer.writeShortstr(this.appId);
            }
            if (this.clusterId != null) {
                writer.writeShortstr(this.clusterId);
            }
        }

        public void appendArgumentDebugStringTo(StringBuilder acc) {
            acc.append("(content-type=").append(this.contentType).append(", content-encoding=").append(this.contentEncoding).append(", headers=").append(this.headers).append(", delivery-mode=").append(this.deliveryMode).append(", priority=").append(this.priority).append(", correlation-id=").append(this.correlationId).append(", reply-to=").append(this.replyTo).append(", expiration=").append(this.expiration).append(", message-id=").append(this.messageId).append(", timestamp=").append(this.timestamp).append(", type=").append(this.type).append(", user-id=").append(this.userId).append(", app-id=").append(this.appId).append(", cluster-id=").append(this.clusterId).append(")");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Builder {
            private String contentType;
            private String contentEncoding;
            private Map<String, Object> headers;
            private Integer deliveryMode;
            private Integer priority;
            private String correlationId;
            private String replyTo;
            private String expiration;
            private String messageId;
            private Date timestamp;
            private String type;
            private String userId;
            private String appId;
            private String clusterId;

            public Builder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public Builder contentEncoding(String contentEncoding) {
                this.contentEncoding = contentEncoding;
                return this;
            }

            public Builder headers(Map<String, Object> headers) {
                this.headers = headers;
                return this;
            }

            public Builder deliveryMode(Integer deliveryMode) {
                this.deliveryMode = deliveryMode;
                return this;
            }

            public Builder priority(Integer priority) {
                this.priority = priority;
                return this;
            }

            public Builder correlationId(String correlationId) {
                this.correlationId = correlationId;
                return this;
            }

            public Builder replyTo(String replyTo) {
                this.replyTo = replyTo;
                return this;
            }

            public Builder expiration(String expiration) {
                this.expiration = expiration;
                return this;
            }

            public Builder messageId(String messageId) {
                this.messageId = messageId;
                return this;
            }

            public Builder timestamp(Date timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder userId(String userId) {
                this.userId = userId;
                return this;
            }

            public Builder appId(String appId) {
                this.appId = appId;
                return this;
            }

            public Builder clusterId(String clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            public BasicProperties build() {
                return new BasicProperties(this.contentType, this.contentEncoding, this.headers, this.deliveryMode, this.priority, this.correlationId, this.replyTo, this.expiration, this.messageId, this.timestamp, this.type, this.userId, this.appId, this.clusterId);
            }
        }
    }

    public static class Confirm {

        public static interface SelectOk
        extends Method {

            public static final class Builder {
                public SelectOk build() {
                    return new AMQImpl.Confirm.SelectOk();
                }
            }
        }

        public static interface Select
        extends Method {
            public boolean getNowait();

            public static final class Builder {
                private boolean nowait = false;

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Select build() {
                    return new AMQImpl.Confirm.Select(this.nowait);
                }
            }
        }
    }

    public static class Tx {

        public static interface RollbackOk
        extends Method {

            public static final class Builder {
                public RollbackOk build() {
                    return new AMQImpl.Tx.RollbackOk();
                }
            }
        }

        public static interface Rollback
        extends Method {

            public static final class Builder {
                public Rollback build() {
                    return new AMQImpl.Tx.Rollback();
                }
            }
        }

        public static interface CommitOk
        extends Method {

            public static final class Builder {
                public CommitOk build() {
                    return new AMQImpl.Tx.CommitOk();
                }
            }
        }

        public static interface Commit
        extends Method {

            public static final class Builder {
                public Commit build() {
                    return new AMQImpl.Tx.Commit();
                }
            }
        }

        public static interface SelectOk
        extends Method {

            public static final class Builder {
                public SelectOk build() {
                    return new AMQImpl.Tx.SelectOk();
                }
            }
        }

        public static interface Select
        extends Method {

            public static final class Builder {
                public Select build() {
                    return new AMQImpl.Tx.Select();
                }
            }
        }
    }

    public static class Basic {

        public static interface Nack
        extends Method {
            public long getDeliveryTag();

            public boolean getMultiple();

            public boolean getRequeue();

            public static final class Builder {
                private long deliveryTag = 0L;
                private boolean multiple = false;
                private boolean requeue = true;

                public Builder deliveryTag(long deliveryTag) {
                    this.deliveryTag = deliveryTag;
                    return this;
                }

                public Builder multiple(boolean multiple) {
                    this.multiple = multiple;
                    return this;
                }

                public Builder multiple() {
                    return this.multiple(true);
                }

                public Builder requeue(boolean requeue) {
                    this.requeue = requeue;
                    return this;
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public Nack build() {
                    return new AMQImpl.Basic.Nack(this.deliveryTag, this.multiple, this.requeue);
                }
            }
        }

        public static interface RecoverOk
        extends Method {

            public static final class Builder {
                public RecoverOk build() {
                    return new AMQImpl.Basic.RecoverOk();
                }
            }
        }

        public static interface Recover
        extends Method {
            public boolean getRequeue();

            public static final class Builder {
                private boolean requeue = false;

                public Builder requeue(boolean requeue) {
                    this.requeue = requeue;
                    return this;
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public Recover build() {
                    return new AMQImpl.Basic.Recover(this.requeue);
                }
            }
        }

        public static interface RecoverAsync
        extends Method {
            public boolean getRequeue();

            public static final class Builder {
                private boolean requeue = false;

                public Builder requeue(boolean requeue) {
                    this.requeue = requeue;
                    return this;
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public RecoverAsync build() {
                    return new AMQImpl.Basic.RecoverAsync(this.requeue);
                }
            }
        }

        public static interface Reject
        extends Method {
            public long getDeliveryTag();

            public boolean getRequeue();

            public static final class Builder {
                private long deliveryTag;
                private boolean requeue = true;

                public Builder deliveryTag(long deliveryTag) {
                    this.deliveryTag = deliveryTag;
                    return this;
                }

                public Builder requeue(boolean requeue) {
                    this.requeue = requeue;
                    return this;
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public Reject build() {
                    return new AMQImpl.Basic.Reject(this.deliveryTag, this.requeue);
                }
            }
        }

        public static interface Ack
        extends Method {
            public long getDeliveryTag();

            public boolean getMultiple();

            public static final class Builder {
                private long deliveryTag = 0L;
                private boolean multiple = false;

                public Builder deliveryTag(long deliveryTag) {
                    this.deliveryTag = deliveryTag;
                    return this;
                }

                public Builder multiple(boolean multiple) {
                    this.multiple = multiple;
                    return this;
                }

                public Builder multiple() {
                    return this.multiple(true);
                }

                public Ack build() {
                    return new AMQImpl.Basic.Ack(this.deliveryTag, this.multiple);
                }
            }
        }

        public static interface GetEmpty
        extends Method {
            public String getClusterId();

            public static final class Builder {
                private String clusterId = "";

                public Builder clusterId(String clusterId) {
                    this.clusterId = clusterId;
                    return this;
                }

                public GetEmpty build() {
                    return new AMQImpl.Basic.GetEmpty(this.clusterId);
                }
            }
        }

        public static interface GetOk
        extends Method {
            public long getDeliveryTag();

            public boolean getRedelivered();

            public String getExchange();

            public String getRoutingKey();

            public int getMessageCount();

            public static final class Builder {
                private long deliveryTag;
                private boolean redelivered = false;
                private String exchange;
                private String routingKey;
                private int messageCount;

                public Builder deliveryTag(long deliveryTag) {
                    this.deliveryTag = deliveryTag;
                    return this;
                }

                public Builder redelivered(boolean redelivered) {
                    this.redelivered = redelivered;
                    return this;
                }

                public Builder redelivered() {
                    return this.redelivered(true);
                }

                public Builder exchange(String exchange) {
                    this.exchange = exchange;
                    return this;
                }

                public Builder routingKey(String routingKey) {
                    this.routingKey = routingKey;
                    return this;
                }

                public Builder messageCount(int messageCount) {
                    this.messageCount = messageCount;
                    return this;
                }

                public GetOk build() {
                    return new AMQImpl.Basic.GetOk(this.deliveryTag, this.redelivered, this.exchange, this.routingKey, this.messageCount);
                }
            }
        }

        public static interface Get
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getNoAck();

            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private boolean noAck = false;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder queue(String queue) {
                    this.queue = queue;
                    return this;
                }

                public Builder noAck(boolean noAck) {
                    this.noAck = noAck;
                    return this;
                }

                public Builder noAck() {
                    return this.noAck(true);
                }

                public Get build() {
                    return new AMQImpl.Basic.Get(this.ticket, this.queue, this.noAck);
                }
            }
        }

        public static interface Deliver
        extends Method {
            public String getConsumerTag();

            public long getDeliveryTag();

            public boolean getRedelivered();

            public String getExchange();

            public String getRoutingKey();

            public static final class Builder {
                private String consumerTag;
                private long deliveryTag;
                private boolean redelivered = false;
                private String exchange;
                private String routingKey;

                public Builder consumerTag(String consumerTag) {
                    this.consumerTag = consumerTag;
                    return this;
                }

                public Builder deliveryTag(long deliveryTag) {
                    this.deliveryTag = deliveryTag;
                    return this;
                }

                public Builder redelivered(boolean redelivered) {
                    this.redelivered = redelivered;
                    return this;
                }

                public Builder redelivered() {
                    return this.redelivered(true);
                }

                public Builder exchange(String exchange) {
                    this.exchange = exchange;
                    return this;
                }

                public Builder routingKey(String routingKey) {
                    this.routingKey = routingKey;
                    return this;
                }

                public Deliver build() {
                    return new AMQImpl.Basic.Deliver(this.consumerTag, this.deliveryTag, this.redelivered, this.exchange, this.routingKey);
                }
            }
        }

        public static interface Return
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public String getExchange();

            public String getRoutingKey();

            public static final class Builder {
                private int replyCode;
                private String replyText = "";
                private String exchange;
                private String routingKey;

                public Builder replyCode(int replyCode) {
                    this.replyCode = replyCode;
                    return this;
                }

                public Builder replyText(String replyText) {
                    this.replyText = replyText;
                    return this;
                }

                public Builder exchange(String exchange) {
                    this.exchange = exchange;
                    return this;
                }

                public Builder routingKey(String routingKey) {
                    this.routingKey = routingKey;
                    return this;
                }

                public Return build() {
                    return new AMQImpl.Basic.Return(this.replyCode, this.replyText, this.exchange, this.routingKey);
                }
            }
        }

        public static interface Publish
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getRoutingKey();

            public boolean getMandatory();

            public boolean getImmediate();

            public static final class Builder {
                private int ticket = 0;
                private String exchange = "";
                private String routingKey = "";
                private boolean mandatory = false;
                private boolean immediate = false;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder exchange(String exchange) {
                    this.exchange = exchange;
                    return this;
                }

                public Builder routingKey(String routingKey) {
                    this.routingKey = routingKey;
                    return this;
                }

                public Builder mandatory(boolean mandatory) {
                    this.mandatory = mandatory;
                    return this;
                }

                public Builder mandatory() {
                    return this.mandatory(true);
                }

                public Builder immediate(boolean immediate) {
                    this.immediate = immediate;
                    return this;
                }

                public Builder immediate() {
                    return this.immediate(true);
                }

                public Publish build() {
                    return new AMQImpl.Basic.Publish(this.ticket, this.exchange, this.routingKey, this.mandatory, this.immediate);
                }
            }
        }

        public static interface CancelOk
        extends Method {
            public String getConsumerTag();

            public static final class Builder {
                private String consumerTag;

                public Builder consumerTag(String consumerTag) {
                    this.consumerTag = consumerTag;
                    return this;
                }

                public CancelOk build() {
                    return new AMQImpl.Basic.CancelOk(this.consumerTag);
                }
            }
        }

        public static interface Cancel
        extends Method {
            public String getConsumerTag();

            public boolean getNowait();

            public static final class Builder {
                private String consumerTag;
                private boolean nowait = false;

                public Builder consumerTag(String consumerTag) {
                    this.consumerTag = consumerTag;
                    return this;
                }

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Cancel build() {
                    return new AMQImpl.Basic.Cancel(this.consumerTag, this.nowait);
                }
            }
        }

        public static interface ConsumeOk
        extends Method {
            public String getConsumerTag();

            public static final class Builder {
                private String consumerTag;

                public Builder consumerTag(String consumerTag) {
                    this.consumerTag = consumerTag;
                    return this;
                }

                public ConsumeOk build() {
                    return new AMQImpl.Basic.ConsumeOk(this.consumerTag);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Consume
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getConsumerTag();

            public boolean getNoLocal();

            public boolean getNoAck();

            public boolean getExclusive();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private String consumerTag = "";
                private boolean noLocal = false;
                private boolean noAck = false;
                private boolean exclusive = false;
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder queue(String queue) {
                    this.queue = queue;
                    return this;
                }

                public Builder consumerTag(String consumerTag) {
                    this.consumerTag = consumerTag;
                    return this;
                }

                public Builder noLocal(boolean noLocal) {
                    this.noLocal = noLocal;
                    return this;
                }

                public Builder noLocal() {
                    return this.noLocal(true);
                }

                public Builder noAck(boolean noAck) {
                    this.noAck = noAck;
                    return this;
                }

                public Builder noAck() {
                    return this.noAck(true);
                }

                public Builder exclusive(boolean exclusive) {
                    this.exclusive = exclusive;
                    return this;
                }

                public Builder exclusive() {
                    return this.exclusive(true);
                }

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> arguments) {
                    this.arguments = arguments;
                    return this;
                }

                public Consume build() {
                    return new AMQImpl.Basic.Consume(this.ticket, this.queue, this.consumerTag, this.noLocal, this.noAck, this.exclusive, this.nowait, this.arguments);
                }
            }
        }

        public static interface QosOk
        extends Method {

            public static final class Builder {
                public QosOk build() {
                    return new AMQImpl.Basic.QosOk();
                }
            }
        }

        public static interface Qos
        extends Method {
            public int getPrefetchSize();

            public int getPrefetchCount();

            public boolean getGlobal();

            public static final class Builder {
                private int prefetchSize = 0;
                private int prefetchCount = 0;
                private boolean global = false;

                public Builder prefetchSize(int prefetchSize) {
                    this.prefetchSize = prefetchSize;
                    return this;
                }

                public Builder prefetchCount(int prefetchCount) {
                    this.prefetchCount = prefetchCount;
                    return this;
                }

                public Builder global(boolean global) {
                    this.global = global;
                    return this;
                }

                public Builder global() {
                    return this.global(true);
                }

                public Qos build() {
                    return new AMQImpl.Basic.Qos(this.prefetchSize, this.prefetchCount, this.global);
                }
            }
        }
    }

    public static class Queue {

        public static interface UnbindOk
        extends Method {

            public static final class Builder {
                public UnbindOk build() {
                    return new AMQImpl.Queue.UnbindOk();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Unbind
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getExchange();

            public String getRoutingKey();

            public Map<String, Object> getArguments();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private String exchange;
                private String routingKey = "";
                private Map<String, Object> arguments = null;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder queue(String queue) {
                    this.queue = queue;
                    return this;
                }

                public Builder exchange(String exchange) {
                    this.exchange = exchange;
                    return this;
                }

                public Builder routingKey(String routingKey) {
                    this.routingKey = routingKey;
                    return this;
                }

                public Builder arguments(Map<String, Object> arguments) {
                    this.arguments = arguments;
                    return this;
                }

                public Unbind build() {
                    return new AMQImpl.Queue.Unbind(this.ticket, this.queue, this.exchange, this.routingKey, this.arguments);
                }
            }
        }

        public static interface DeleteOk
        extends Method {
            public int getMessageCount();

            public static final class Builder {
                private int messageCount;

                public Builder messageCount(int messageCount) {
                    this.messageCount = messageCount;
                    return this;
                }

                public DeleteOk build() {
                    return new AMQImpl.Queue.DeleteOk(this.messageCount);
                }
            }
        }

        public static interface Delete
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getIfUnused();

            public boolean getIfEmpty();

            public boolean getNowait();

            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private boolean ifUnused = false;
                private boolean ifEmpty = false;
                private boolean nowait = false;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder queue(String queue) {
                    this.queue = queue;
                    return this;
                }

                public Builder ifUnused(boolean ifUnused) {
                    this.ifUnused = ifUnused;
                    return this;
                }

                public Builder ifUnused() {
                    return this.ifUnused(true);
                }

                public Builder ifEmpty(boolean ifEmpty) {
                    this.ifEmpty = ifEmpty;
                    return this;
                }

                public Builder ifEmpty() {
                    return this.ifEmpty(true);
                }

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Delete build() {
                    return new AMQImpl.Queue.Delete(this.ticket, this.queue, this.ifUnused, this.ifEmpty, this.nowait);
                }
            }
        }

        public static interface PurgeOk
        extends Method {
            public int getMessageCount();

            public static final class Builder {
                private int messageCount;

                public Builder messageCount(int messageCount) {
                    this.messageCount = messageCount;
                    return this;
                }

                public PurgeOk build() {
                    return new AMQImpl.Queue.PurgeOk(this.messageCount);
                }
            }
        }

        public static interface Purge
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getNowait();

            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private boolean nowait = false;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder queue(String queue) {
                    this.queue = queue;
                    return this;
                }

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Purge build() {
                    return new AMQImpl.Queue.Purge(this.ticket, this.queue, this.nowait);
                }
            }
        }

        public static interface BindOk
        extends Method {

            public static final class Builder {
                public BindOk build() {
                    return new AMQImpl.Queue.BindOk();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Bind
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getExchange();

            public String getRoutingKey();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private String exchange;
                private String routingKey = "";
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder queue(String queue) {
                    this.queue = queue;
                    return this;
                }

                public Builder exchange(String exchange) {
                    this.exchange = exchange;
                    return this;
                }

                public Builder routingKey(String routingKey) {
                    this.routingKey = routingKey;
                    return this;
                }

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> arguments) {
                    this.arguments = arguments;
                    return this;
                }

                public Bind build() {
                    return new AMQImpl.Queue.Bind(this.ticket, this.queue, this.exchange, this.routingKey, this.nowait, this.arguments);
                }
            }
        }

        public static interface DeclareOk
        extends Method {
            public String getQueue();

            public int getMessageCount();

            public int getConsumerCount();

            public static final class Builder {
                private String queue;
                private int messageCount;
                private int consumerCount;

                public Builder queue(String queue) {
                    this.queue = queue;
                    return this;
                }

                public Builder messageCount(int messageCount) {
                    this.messageCount = messageCount;
                    return this;
                }

                public Builder consumerCount(int consumerCount) {
                    this.consumerCount = consumerCount;
                    return this;
                }

                public DeclareOk build() {
                    return new AMQImpl.Queue.DeclareOk(this.queue, this.messageCount, this.consumerCount);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Declare
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getPassive();

            public boolean getDurable();

            public boolean getExclusive();

            public boolean getAutoDelete();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private boolean passive = false;
                private boolean durable = false;
                private boolean exclusive = false;
                private boolean autoDelete = false;
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder queue(String queue) {
                    this.queue = queue;
                    return this;
                }

                public Builder passive(boolean passive) {
                    this.passive = passive;
                    return this;
                }

                public Builder passive() {
                    return this.passive(true);
                }

                public Builder durable(boolean durable) {
                    this.durable = durable;
                    return this;
                }

                public Builder durable() {
                    return this.durable(true);
                }

                public Builder exclusive(boolean exclusive) {
                    this.exclusive = exclusive;
                    return this;
                }

                public Builder exclusive() {
                    return this.exclusive(true);
                }

                public Builder autoDelete(boolean autoDelete) {
                    this.autoDelete = autoDelete;
                    return this;
                }

                public Builder autoDelete() {
                    return this.autoDelete(true);
                }

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> arguments) {
                    this.arguments = arguments;
                    return this;
                }

                public Declare build() {
                    return new AMQImpl.Queue.Declare(this.ticket, this.queue, this.passive, this.durable, this.exclusive, this.autoDelete, this.nowait, this.arguments);
                }
            }
        }
    }

    public static class Exchange {

        public static interface UnbindOk
        extends Method {

            public static final class Builder {
                public UnbindOk build() {
                    return new AMQImpl.Exchange.UnbindOk();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Unbind
        extends Method {
            public int getTicket();

            public String getDestination();

            public String getSource();

            public String getRoutingKey();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class Builder {
                private int ticket = 0;
                private String destination;
                private String source;
                private String routingKey = "";
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder destination(String destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder source(String source) {
                    this.source = source;
                    return this;
                }

                public Builder routingKey(String routingKey) {
                    this.routingKey = routingKey;
                    return this;
                }

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> arguments) {
                    this.arguments = arguments;
                    return this;
                }

                public Unbind build() {
                    return new AMQImpl.Exchange.Unbind(this.ticket, this.destination, this.source, this.routingKey, this.nowait, this.arguments);
                }
            }
        }

        public static interface BindOk
        extends Method {

            public static final class Builder {
                public BindOk build() {
                    return new AMQImpl.Exchange.BindOk();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Bind
        extends Method {
            public int getTicket();

            public String getDestination();

            public String getSource();

            public String getRoutingKey();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class Builder {
                private int ticket = 0;
                private String destination;
                private String source;
                private String routingKey = "";
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder destination(String destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder source(String source) {
                    this.source = source;
                    return this;
                }

                public Builder routingKey(String routingKey) {
                    this.routingKey = routingKey;
                    return this;
                }

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> arguments) {
                    this.arguments = arguments;
                    return this;
                }

                public Bind build() {
                    return new AMQImpl.Exchange.Bind(this.ticket, this.destination, this.source, this.routingKey, this.nowait, this.arguments);
                }
            }
        }

        public static interface DeleteOk
        extends Method {

            public static final class Builder {
                public DeleteOk build() {
                    return new AMQImpl.Exchange.DeleteOk();
                }
            }
        }

        public static interface Delete
        extends Method {
            public int getTicket();

            public String getExchange();

            public boolean getIfUnused();

            public boolean getNowait();

            public static final class Builder {
                private int ticket = 0;
                private String exchange;
                private boolean ifUnused = false;
                private boolean nowait = false;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder exchange(String exchange) {
                    this.exchange = exchange;
                    return this;
                }

                public Builder ifUnused(boolean ifUnused) {
                    this.ifUnused = ifUnused;
                    return this;
                }

                public Builder ifUnused() {
                    return this.ifUnused(true);
                }

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Delete build() {
                    return new AMQImpl.Exchange.Delete(this.ticket, this.exchange, this.ifUnused, this.nowait);
                }
            }
        }

        public static interface DeclareOk
        extends Method {

            public static final class Builder {
                public DeclareOk build() {
                    return new AMQImpl.Exchange.DeclareOk();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Declare
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getType();

            public boolean getPassive();

            public boolean getDurable();

            public boolean getAutoDelete();

            public boolean getInternal();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class Builder {
                private int ticket = 0;
                private String exchange;
                private String type = "direct";
                private boolean passive = false;
                private boolean durable = false;
                private boolean autoDelete = false;
                private boolean internal = false;
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public Builder exchange(String exchange) {
                    this.exchange = exchange;
                    return this;
                }

                public Builder type(String type) {
                    this.type = type;
                    return this;
                }

                public Builder passive(boolean passive) {
                    this.passive = passive;
                    return this;
                }

                public Builder passive() {
                    return this.passive(true);
                }

                public Builder durable(boolean durable) {
                    this.durable = durable;
                    return this;
                }

                public Builder durable() {
                    return this.durable(true);
                }

                public Builder autoDelete(boolean autoDelete) {
                    this.autoDelete = autoDelete;
                    return this;
                }

                public Builder autoDelete() {
                    return this.autoDelete(true);
                }

                public Builder internal(boolean internal) {
                    this.internal = internal;
                    return this;
                }

                public Builder internal() {
                    return this.internal(true);
                }

                public Builder nowait(boolean nowait) {
                    this.nowait = nowait;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> arguments) {
                    this.arguments = arguments;
                    return this;
                }

                public Declare build() {
                    return new AMQImpl.Exchange.Declare(this.ticket, this.exchange, this.type, this.passive, this.durable, this.autoDelete, this.internal, this.nowait, this.arguments);
                }
            }
        }
    }

    public static class Access {

        public static interface RequestOk
        extends Method {
            public int getTicket();

            public static final class Builder {
                private int ticket = 1;

                public Builder ticket(int ticket) {
                    this.ticket = ticket;
                    return this;
                }

                public RequestOk build() {
                    return new AMQImpl.Access.RequestOk(this.ticket);
                }
            }
        }

        public static interface Request
        extends Method {
            public String getRealm();

            public boolean getExclusive();

            public boolean getPassive();

            public boolean getActive();

            public boolean getWrite();

            public boolean getRead();

            public static final class Builder {
                private String realm = "/data";
                private boolean exclusive = false;
                private boolean passive = true;
                private boolean active = true;
                private boolean write = true;
                private boolean read = true;

                public Builder realm(String realm) {
                    this.realm = realm;
                    return this;
                }

                public Builder exclusive(boolean exclusive) {
                    this.exclusive = exclusive;
                    return this;
                }

                public Builder exclusive() {
                    return this.exclusive(true);
                }

                public Builder passive(boolean passive) {
                    this.passive = passive;
                    return this;
                }

                public Builder passive() {
                    return this.passive(true);
                }

                public Builder active(boolean active) {
                    this.active = active;
                    return this;
                }

                public Builder active() {
                    return this.active(true);
                }

                public Builder write(boolean write) {
                    this.write = write;
                    return this;
                }

                public Builder write() {
                    return this.write(true);
                }

                public Builder read(boolean read) {
                    this.read = read;
                    return this;
                }

                public Builder read() {
                    return this.read(true);
                }

                public Request build() {
                    return new AMQImpl.Access.Request(this.realm, this.exclusive, this.passive, this.active, this.write, this.read);
                }
            }
        }
    }

    public static class Channel {

        public static interface CloseOk
        extends Method {

            public static final class Builder {
                public CloseOk build() {
                    return new AMQImpl.Channel.CloseOk();
                }
            }
        }

        public static interface Close
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public int getClassId();

            public int getMethodId();

            public static final class Builder {
                private int replyCode;
                private String replyText = "";
                private int classId;
                private int methodId;

                public Builder replyCode(int replyCode) {
                    this.replyCode = replyCode;
                    return this;
                }

                public Builder replyText(String replyText) {
                    this.replyText = replyText;
                    return this;
                }

                public Builder classId(int classId) {
                    this.classId = classId;
                    return this;
                }

                public Builder methodId(int methodId) {
                    this.methodId = methodId;
                    return this;
                }

                public Close build() {
                    return new AMQImpl.Channel.Close(this.replyCode, this.replyText, this.classId, this.methodId);
                }
            }
        }

        public static interface FlowOk
        extends Method {
            public boolean getActive();

            public static final class Builder {
                private boolean active;

                public Builder active(boolean active) {
                    this.active = active;
                    return this;
                }

                public Builder active() {
                    return this.active(true);
                }

                public FlowOk build() {
                    return new AMQImpl.Channel.FlowOk(this.active);
                }
            }
        }

        public static interface Flow
        extends Method {
            public boolean getActive();

            public static final class Builder {
                private boolean active;

                public Builder active(boolean active) {
                    this.active = active;
                    return this;
                }

                public Builder active() {
                    return this.active(true);
                }

                public Flow build() {
                    return new AMQImpl.Channel.Flow(this.active);
                }
            }
        }

        public static interface OpenOk
        extends Method {
            public LongString getChannelId();

            public static final class Builder {
                private LongString channelId = LongStringHelper.asLongString("");

                public Builder channelId(LongString channelId) {
                    this.channelId = channelId;
                    return this;
                }

                public Builder channelId(String channelId) {
                    return this.channelId(LongStringHelper.asLongString(channelId));
                }

                public OpenOk build() {
                    return new AMQImpl.Channel.OpenOk(this.channelId);
                }
            }
        }

        public static interface Open
        extends Method {
            public String getOutOfBand();

            public static final class Builder {
                private String outOfBand = "";

                public Builder outOfBand(String outOfBand) {
                    this.outOfBand = outOfBand;
                    return this;
                }

                public Open build() {
                    return new AMQImpl.Channel.Open(this.outOfBand);
                }
            }
        }
    }

    public static class Connection {

        public static interface CloseOk
        extends Method {

            public static final class Builder {
                public CloseOk build() {
                    return new AMQImpl.Connection.CloseOk();
                }
            }
        }

        public static interface Close
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public int getClassId();

            public int getMethodId();

            public static final class Builder {
                private int replyCode;
                private String replyText = "";
                private int classId;
                private int methodId;

                public Builder replyCode(int replyCode) {
                    this.replyCode = replyCode;
                    return this;
                }

                public Builder replyText(String replyText) {
                    this.replyText = replyText;
                    return this;
                }

                public Builder classId(int classId) {
                    this.classId = classId;
                    return this;
                }

                public Builder methodId(int methodId) {
                    this.methodId = methodId;
                    return this;
                }

                public Close build() {
                    return new AMQImpl.Connection.Close(this.replyCode, this.replyText, this.classId, this.methodId);
                }
            }
        }

        public static interface OpenOk
        extends Method {
            public String getKnownHosts();

            public static final class Builder {
                private String knownHosts = "";

                public Builder knownHosts(String knownHosts) {
                    this.knownHosts = knownHosts;
                    return this;
                }

                public OpenOk build() {
                    return new AMQImpl.Connection.OpenOk(this.knownHosts);
                }
            }
        }

        public static interface Open
        extends Method {
            public String getVirtualHost();

            public String getCapabilities();

            public boolean getInsist();

            public static final class Builder {
                private String virtualHost = "/";
                private String capabilities = "";
                private boolean insist = false;

                public Builder virtualHost(String virtualHost) {
                    this.virtualHost = virtualHost;
                    return this;
                }

                public Builder capabilities(String capabilities) {
                    this.capabilities = capabilities;
                    return this;
                }

                public Builder insist(boolean insist) {
                    this.insist = insist;
                    return this;
                }

                public Builder insist() {
                    return this.insist(true);
                }

                public Open build() {
                    return new AMQImpl.Connection.Open(this.virtualHost, this.capabilities, this.insist);
                }
            }
        }

        public static interface TuneOk
        extends Method {
            public int getChannelMax();

            public int getFrameMax();

            public int getHeartbeat();

            public static final class Builder {
                private int channelMax = 0;
                private int frameMax = 0;
                private int heartbeat = 0;

                public Builder channelMax(int channelMax) {
                    this.channelMax = channelMax;
                    return this;
                }

                public Builder frameMax(int frameMax) {
                    this.frameMax = frameMax;
                    return this;
                }

                public Builder heartbeat(int heartbeat) {
                    this.heartbeat = heartbeat;
                    return this;
                }

                public TuneOk build() {
                    return new AMQImpl.Connection.TuneOk(this.channelMax, this.frameMax, this.heartbeat);
                }
            }
        }

        public static interface Tune
        extends Method {
            public int getChannelMax();

            public int getFrameMax();

            public int getHeartbeat();

            public static final class Builder {
                private int channelMax = 0;
                private int frameMax = 0;
                private int heartbeat = 0;

                public Builder channelMax(int channelMax) {
                    this.channelMax = channelMax;
                    return this;
                }

                public Builder frameMax(int frameMax) {
                    this.frameMax = frameMax;
                    return this;
                }

                public Builder heartbeat(int heartbeat) {
                    this.heartbeat = heartbeat;
                    return this;
                }

                public Tune build() {
                    return new AMQImpl.Connection.Tune(this.channelMax, this.frameMax, this.heartbeat);
                }
            }
        }

        public static interface SecureOk
        extends Method {
            public LongString getResponse();

            public static final class Builder {
                private LongString response;

                public Builder response(LongString response) {
                    this.response = response;
                    return this;
                }

                public Builder response(String response) {
                    return this.response(LongStringHelper.asLongString(response));
                }

                public SecureOk build() {
                    return new AMQImpl.Connection.SecureOk(this.response);
                }
            }
        }

        public static interface Secure
        extends Method {
            public LongString getChallenge();

            public static final class Builder {
                private LongString challenge;

                public Builder challenge(LongString challenge) {
                    this.challenge = challenge;
                    return this;
                }

                public Builder challenge(String challenge) {
                    return this.challenge(LongStringHelper.asLongString(challenge));
                }

                public Secure build() {
                    return new AMQImpl.Connection.Secure(this.challenge);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface StartOk
        extends Method {
            public Map<String, Object> getClientProperties();

            public String getMechanism();

            public LongString getResponse();

            public String getLocale();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class Builder {
                private Map<String, Object> clientProperties;
                private String mechanism = "PLAIN";
                private LongString response;
                private String locale = "en_US";

                public Builder clientProperties(Map<String, Object> clientProperties) {
                    this.clientProperties = clientProperties;
                    return this;
                }

                public Builder mechanism(String mechanism) {
                    this.mechanism = mechanism;
                    return this;
                }

                public Builder response(LongString response) {
                    this.response = response;
                    return this;
                }

                public Builder response(String response) {
                    return this.response(LongStringHelper.asLongString(response));
                }

                public Builder locale(String locale) {
                    this.locale = locale;
                    return this;
                }

                public StartOk build() {
                    return new AMQImpl.Connection.StartOk(this.clientProperties, this.mechanism, this.response, this.locale);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Start
        extends Method {
            public int getVersionMajor();

            public int getVersionMinor();

            public Map<String, Object> getServerProperties();

            public LongString getMechanisms();

            public LongString getLocales();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class Builder {
                private int versionMajor = 0;
                private int versionMinor = 9;
                private Map<String, Object> serverProperties;
                private LongString mechanisms = LongStringHelper.asLongString("PLAIN");
                private LongString locales = LongStringHelper.asLongString("en_US");

                public Builder versionMajor(int versionMajor) {
                    this.versionMajor = versionMajor;
                    return this;
                }

                public Builder versionMinor(int versionMinor) {
                    this.versionMinor = versionMinor;
                    return this;
                }

                public Builder serverProperties(Map<String, Object> serverProperties) {
                    this.serverProperties = serverProperties;
                    return this;
                }

                public Builder mechanisms(LongString mechanisms) {
                    this.mechanisms = mechanisms;
                    return this;
                }

                public Builder mechanisms(String mechanisms) {
                    return this.mechanisms(LongStringHelper.asLongString(mechanisms));
                }

                public Builder locales(LongString locales) {
                    this.locales = locales;
                    return this;
                }

                public Builder locales(String locales) {
                    return this.locales(LongStringHelper.asLongString(locales));
                }

                public Start build() {
                    return new AMQImpl.Connection.Start(this.versionMajor, this.versionMinor, this.serverProperties, this.mechanisms, this.locales);
                }
            }
        }
    }

    public static class PROTOCOL {
        public static final int MAJOR = 0;
        public static final int MINOR = 9;
        public static final int REVISION = 1;
        public static final int PORT = 5672;
    }
}

